<?php
$fargu = array(
    'post_type'         => 'folio',
    'post_status'       => 'publish',
    'posts_per_page'    => $portfolio_item,
    'orderby'           => $order_by,
    'order'             => $order
);

$folio = new WP_Query($fargu);

if($arrow_align == 2):
    $class = 'left_right';
elseif($arrow_align == 3):
    $class = 'center_bottom';
else:
    $class = 'default';
endif;

if($folio->have_posts()):
    ?>
    <div class="worksSlider owl-carousel <?php echo esc_attr($class) ?>">
        <?php
            while($folio->have_posts()):
                $folio->the_post();

                $terms = get_the_terms(get_the_ID(), 'folio_cat');
                $cats = '';
                if (is_array($terms) && !empty($terms)) 
                {
                    $p = 1;
                    $c = count($terms);
                    foreach ($terms as $term) 
                    {
                        if($p == $c)
                        {
                            $cats .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>';
                        }
                        else
                        {
                            $cats .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a> / ';
                        }
                        $p++;
                    }
                }

                ?>
                <div class="singlefolio_02">
                    <?php if(has_post_thumbnail()): ?>
                        <?php echo get_the_post_thumbnail(get_the_ID(), 'industing-team-1'); ?>
                    <?php else: ?>
                        <img src="https://via.placeholder.com/370x400.jpg" alt="<?php echo get_the_title(); ?>">
                    <?php endif; ?>
                    <div class="sf2_con">
                        <p><?php echo wp_kses_post($cats); ?></p>
                        <h3><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h3>
                    </div>
                </div>
                <?php
            endwhile;
            ?>
    </div>
    <?php
endif;
wp_reset_postdata();