<?php
$fargs = array(
    'post_type'         => 'folio',
    'post_status'       => 'publish',
    'posts_per_page'    => $portfolio_item,
    'orderby'           => $order_by,
    'order'             => $order
);

$folio = new WP_Query($fargs);
if($folio->have_posts()):
    ?>
    <div class="workCarousel_2">
        <?php

            while($folio->have_posts()):
                $folio->the_post();

                $terms = get_the_terms(get_the_ID(), 'folio_cat');
                $cats = '';
                if (is_array($terms) && !empty($terms)) 
                {
                    $p = 1;
                    $c = count($terms);
                    foreach ($terms as $term) 
                    {
                        if($p == $c)
                        {
                            $cats .= '<a class="cate" href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>';
                        }
                        else
                        {
                            $cats .= '<a class="cate" href="'.  get_category_link($term->term_id).'">'.$term->name.'</a> / ';
                        }
                        $p++;
                    }
                }

                ?>
                <div class="singleCaros">
                    <?php if(has_post_thumbnail()): ?>
                        <?php echo get_the_post_thumbnail(get_the_ID(), 'meipaly-folio-slide-2'); ?>
                    <?php else: ?>
                        <img src="https://via.placeholder.com/680x553.jpg" alt="<?php echo get_the_title(); ?>">
                    <?php endif; ?>
                    <div class="singleCarContent">
                        <h2><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h2>
                        <div class="workTag">
                            <p><?php echo wp_kses_post($cats); ?></p>
                        </div>
                    </div>
                </div>
                <?php
            endwhile;
        ?>
        </div>
    <?php
endif;
wp_reset_postdata();
