<?php

namespace Elementor;

if( !defined('ABSPATH') )
    exit;

class Tw_About_Widget extends Widget_Base{
    
    public function get_name() {
        return 'tw-about-section';
    }
    public function get_title() {
        return esc_html__( 'About Section', 'themewar' );
    }
    public function get_icon() {
        return 'eicon-section';
    }
    public function get_categories() {
        return ['industing-elements'];
    }
    
    protected function _register_controls() {
        $this->start_controls_section(
                'section_tab', [
                    'label'     => esc_html__(' About Section ', 'themewar')
                ]
        );
        $this->add_control(
                'ab_style',
                [
                        'label'         => esc_html__( 'About Style', 'themewar' ),
                        'type'          => Controls_Manager::SELECT,
                        'default'       => 0,
                        'options'       => [
                                0       => esc_html__( 'Select Style', 'themewar' ),
                                1       => esc_html__( 'About 01', 'themewar' ),
                                2       => esc_html__( 'About 02', 'themewar' ),
                        ],
                ]
        ); 
        $this->add_control(
                'ab_img_1',
                [
                        'label'         => esc_html__( 'About Image 01', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'condition'     => ['ab_style' => '2'],
                        'description'   => esc_html__('Image size should be 494x492px.', 'themewar'),
                ]
        );
        $this->add_control(
                'ab_img_2',
                [
                        'label'         => esc_html__( 'About Image 02', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'condition'     => ['ab_style' => '2'],
                        'description'   => esc_html__('Image size should be 309x289px.', 'themewar'),
                ]
        );
        $this->add_control(
                'counter',
                [
                        'label'         => esc_html__( 'Experience Year', 'themewar' ),
                        'type'          => Controls_Manager::NUMBER,
                        'default'       => '',
                        'condition'     => ['ab_style' => '2'],
                        'label_block'   => TRUE,
                        'placeholder'   => esc_html__('', 'themewar'),
                        'description'   => esc_html__('Insert your Experience Year.', 'themewar'),
                ]
        );
        $this->add_control(
                'prefix',
                [
                        'label'         => esc_html__( 'Prefix Sign', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'condition'     => ['ab_style' => '2'],
                        'placeholder'   => esc_html__('', 'themewar'),
                        'description'   => esc_html__('Insert your Prefix Sign.', 'themewar'),
                ]
        );
        $this->add_control(
                'ex_title',
                [
                        'label'         => esc_html__( 'Experience Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'condition'     => ['ab_style' => '2'],
                        'label_block'   => TRUE,
                        'placeholder'   => esc_html__('', 'themewar'),
                        'description'   => esc_html__('Insert your Experience title.', 'themewar'),
                ]
        );
        $this->add_control(
                'about_sub_title', [
                    'label'             => esc_html__('About Sub Title', 'themewar'),
                    'type'              => Controls_Manager::TEXT,
                    'default'           => '',
                    'condition'         => ['ab_style' => '1'],
                    'label_block'       => true,
                    'placeholder'       => esc_html__('Add About Sub Title', 'themewar'),
                ]
        );
        $this->add_control(
                'about_title', [
                    'label'             => esc_html__('About Title', 'themewar'),
                    'type'              => Controls_Manager::TEXT,
                    'default'           => '',
                    'condition'         => ['ab_style' => '1'],
                    'label_block'       => true,
                    'placeholder'       => esc_html__('Add About Title', 'themewar'),
                ]
        );
        $this->add_control(
                'about_desc', [
                    'label'             => esc_html__('About Description', 'themewar'),
                    'type'              => Controls_Manager::TEXTAREA,
                    'default'           => esc_html__('', 'themewar'),
                    'condition'         => ['ab_style' => '1'],
                    'placeholder'       => esc_html__('Add Desc', 'themewar'),
                ]
        );
        $this->add_control(
                'singnature',
                [
                        'label'         => esc_html__( 'About Signature Image', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'condition'     => ['ab_style' => '1'],
                        'description'   => esc_html__('Image size should be 155x100px.', 'themewar'),
                ]
        );
        $this->add_control(
               'ab_btn_label', [
                    'label'             => esc_html__('About BTN Label Icon', 'themewar'),
                    'type'              => Controls_Manager::ICON,
                    'label_block'       => TRUE,
                    'condition'         => ['ab_style' => '1'],
                    'default'           => esc_html__('', 'themewar'),
                    'placeholder'       => esc_html__('Inser BTN Label Icon', 'themewar'),
                ]
        );
        $this->add_control(
                'ab_btn_url', [
                    'label'             => esc_html__( 'URL', 'themewar' ),
                    'type'              => Controls_Manager::URL,
                    'input_type'        => 'url',
                    'condition'         => ['ab_style' => '1'],
                    'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                    'show_external'     => true,
                    'default'           => [
                            'url'            => '',
                            'is_external'    => true,
                            'nofollow'       => true,
                    ],
                ]
        );
        $this->add_responsive_control(
                'content_align', [
                        'label'                     =>esc_html__( 'Content Alignment', 'themewar' ),
                        'type'                      => Controls_Manager::CHOOSE,
                        'condition'                 => ['ab_style' => '1'],
                        'options'                   => [
                                'left'		 => [
                                        'title'	 =>esc_html__( 'Left', 'themewar' ),
                                        'icon'	 => 'fa fa-align-left',
                                ],
                                'center'	 => [
                                        'title'	 =>esc_html__( 'Center', 'themewar' ),
                                        'icon'	 => 'fa fa-align-center',
                                ],
                                'right'		 => [
                                        'title'	 =>esc_html__( 'Right', 'themewar' ),
                                        'icon'	 => 'fa fa-align-right',
                                ]
                        ],
                        'default'                   => 'left',
                        'prefix_class'              => 'about_align elementor%s-align-',
                ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_tab_2',
            [
                'label'     => esc_html__('About Area Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
                'condition'         => ['ab_style' => '1'],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'background',
                        'label' => esc_html__( 'About BG', 'themewar' ),
                        'types' => [ 'classic', 'gradient', 'video' ],
                        'selector' => '{{WRAPPER}} .aboutCompanys',
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'border',
                        'label' => esc_html__( 'About Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .aboutCompanys',
                ]
        );
        $this->add_control(
                'are_paddings',
                [
                        'label' => esc_html__( 'Area Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .aboutCompanys' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'are_inner_paddings',
                [
                        'label' => esc_html__( 'Area Inner Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .abc_left' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .abc_right' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'are_margings',
                [
                        'label' => esc_html__( 'Area Margind', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .aboutCompanys' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_4',
            [
                'label'     => esc_html__('About Sub Title Style', 'themewar'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition'         => ['ab_style' => '1'],
            ]
        );
        $this->add_control(
                'about_sub_title_color',
                [
                        'label' => esc_html__( 'Sub Title Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .aboutCompanys h5' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'sub_title_typography',
                        'label' => esc_html__( 'Sub Title Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .aboutCompanys h5',
                ]
        );
        $this->add_control(
                'sub_title_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .aboutCompanys h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_tab_5',
            [
                'label'     => esc_html__('About Title Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
                'condition'         => ['ab_style' => '1'],
            ]
        );
        $this->add_control(
                'about_title_color',
                [
                        'label' => esc_html__( 'Title Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .aboutCompanys h2' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'title_typography',
                        'label' => esc_html__( 'Title Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .aboutCompanys h2',
                ]
        );
        $this->add_control(
                'title_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .aboutCompanys h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_tab_6',
            [
                'label'     => esc_html__('About Description Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
                'condition'         => ['ab_style' => '1'],
            ]
        );
        $this->add_control(
                'about_desc_color',
                [
                        'label' => esc_html__( 'Desc Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .aboutCompanys p' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'desc_typography',
                        'label' => esc_html__( 'Desc Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .aboutCompanys p',
                ]
        );
        $this->add_control(
                'desc_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .aboutCompanys p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_7',
            [
                'label'     => esc_html__('About Button Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
                'condition'         => ['ab_style' => '1'],
            ]
        );
            $this->start_controls_tabs( 'style_tabs_1' );
                $this->start_controls_tab(
                        'button_style_normal',
                        [
                                'label' => __( 'Normal', 'themewar' ),
                        ]
                );
                $this->add_control(
                        'btn_label_color',
                        [
                                'label' => esc_html__( 'Label Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .ab_btn' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_control(
                        'button_bg',
                        [
                                'label' => esc_html__( 'BG Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .ab_btn' => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'button_style_hover',
                        [
                                'label' => __( 'Hover', 'themewar' ),
                        ]
                );
                $this->add_control(
                        'btn_label_hover_color',
                        [
                                'label' => esc_html__( 'Label Hover Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .ab_btn:hover' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_control(
                        'button_bg_hover',
                        [
                                'label' => esc_html__( 'BG Hover Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .ab_btn:hover' => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_control(
                    'width',
                    [
                            'label' => __( 'Width', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 1000,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .ab_btn' => 'width: {{SIZE}}{{UNIT}};'
                            ],
                    ]
            );
            $this->add_control(
                    'height',
                    [
                            'label' => __( 'Height', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 200,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .ab_btn' => 'height: {{SIZE}}{{UNIT}};'
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                            'name' => 'button_typography',
                            'label' => esc_html__( 'Button Typography', 'themewar' ),
                            'selector' => '{{WRAPPER}} .ab_btn',
                    ]
            );
            $this->add_control(
                    'btn_padding',
                    [
                            'label' => esc_html__( 'Padding', 'themewar' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                    '{{WRAPPER}} .ab_btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_control(
                    'btn_margin',
                    [
                            'label' => esc_html__( 'Margins', 'themewar' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                    '{{WRAPPER}} .ab_btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_8',
            [
                'label'     => esc_html__('About Experience Area', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
                'condition'         => ['ab_style' => '2'],
            ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name' => 'ex_background',
                        'label' => __( 'Background', 'themewar' ),
                        'types' => [ 'classic', 'gradient', 'video' ],
                        'selector' => '{{WRAPPER}} .yearsofexp',
                ]
        );
        $this->add_control(
                'ex_width',
                [
                        'label' => __( 'Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .yearsofexp' => 'width: {{SIZE}}{{UNIT}};'
                        ],
                ]
        );
        $this->add_control(
                'ex_height',
                [
                        'label' => __( 'Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .yearsofexp' => 'height: {{SIZE}}{{UNIT}};'
                        ],
                ]
        );
        $this->add_control(
                'ex_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .yearsofexp' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'ex_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .yearsofexp' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_9',
            [
                'label'     => esc_html__('Experience Number Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
                'condition'         => ['ab_style' => '2'],
            ]
        );
        $this->add_control(
                'ex_color',
                [
                        'label' => esc_html__( 'Experience Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .yearsofexp h2' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'ex_typography',
                        'label' => esc_html__( 'Experience Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .yearsofexp h2',
                ]
        );
        $this->add_control(
                'ex_n_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .yearsofexp h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_10',
            [
                'label'     => esc_html__('Experience Title Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
                'condition'         => ['ab_style' => '2'],
            ]
        );
        $this->add_control(
                'ex_t_color',
                [
                        'label' => esc_html__( 'Title Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .yearsofexp > span' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'ex_t_typography',
                        'label' => esc_html__( 'Experience Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .yearsofexp > span',
                ]
        );
        $this->add_control(
                'ex_t_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .yearsofexp > span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
    }
    
    protected function render() {
        $settings       = $this->get_settings();
        $ab_style       = (isset($settings['ab_style']) && $settings['ab_style'] > 0) ? $settings['ab_style'] : 0;
        $singnature     = (isset($settings['singnature']['url']) && $settings['singnature']['url'] != '') ? $settings['singnature']['url'] : 'https://via.placeholder.com/113x100.png';
        $ab_btn_label   = (isset($settings['ab_btn_label']) && $settings['ab_btn_label'] != '') ? $settings['ab_btn_label'] : '';
        $target         = $settings['ab_btn_url']['is_external'] ? ' target="_blank"' : '' ;
        $nofollow       = $settings['ab_btn_url']['nofollow'] ? ' rel="nofollow"' : '' ;
        $ab_btn_url     = (isset($settings['ab_btn_url']['url']) && $settings['ab_btn_url']['url'] != '') ? $settings['ab_btn_url']['url'] : '#';
        $about_title    = (isset($settings['about_title'])) ? $settings['about_title'] : '';
        $sub_title      = (isset($settings['about_sub_title'])) ? $settings['about_sub_title'] : '';
        $about_desc     = (isset($settings['about_desc'])) ? $settings['about_desc'] : '';
        
        $ab_img_1       = (isset($settings['ab_img_1']['url']) && $settings['ab_img_1']['url'] != '') ? $settings['ab_img_1']['url'] : 'https://via.placeholder.com/494x492.jpg';
        $ab_img_2       = (isset($settings['ab_img_2']['url']) && $settings['ab_img_2']['url'] != '') ? $settings['ab_img_2']['url'] : 'https://via.placeholder.com/309x289.jpg';
        $ex_title       = (isset($settings['ex_title'])) ? $settings['ex_title'] : '';
        $counter        = (isset($settings['counter'])) ? $settings['counter'] : '';
        $prefix         = (isset($settings['prefix'])) ? $settings['prefix'] : '';
        
        switch ($ab_style) {
            case 1:
                ?>
                <div class="aboutCompanys">
                    <div class="row">
                        <div class="col-xl-6 col-lg-6">
                            <div class="abc_left">
                                <?php if($sub_title != ''): ?>
                                    <h5><?php echo esc_html($sub_title); ?></h5>
                                <?php endif; ?>
                                <?php if($about_title != ''): ?>
                                    <h2><?php echo esc_html($about_title); ?></h2>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-6">
                            <div class="abc_right">
                                <?php if($about_desc != ''): ?>
                                    <p><?php echo esc_html($about_desc); ?></p>
                                <?php endif; ?>
                                <?php if($singnature != ''): ?>
                                    <img class="ab_sign" src="<?php echo esc_url($singnature); ?>" alt="">
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php if($ab_btn_label != ''): ?>
                        <a href="<?php echo esc_url($ab_btn_url); ?>" class="ab_btn"><i class="<?php echo esc_attr($ab_btn_label); ?>"></i></a>
                    <?php endif; ?>
                </div>
                <?php
                break;
            case 2:
                ?>
                <div class="aboutImg clearfix">
                    <?php if($ab_img_1 != ''): ?>
                    <div class="i1 pull-right">
                        <img src="<?php echo esc_url($ab_img_1); ?>" alt="">
                    </div>
                    <?php endif; ?>
                    <?php if($ab_img_2 != ''): ?>
                    <div class="i2 pull-left">
                        <img src="<?php echo esc_url($ab_img_2); ?>" class="si" alt="">
                    </div>
                    <?php endif; ?>
                    <div class="yearsofexp">
                        <?php if($counter != ''): ?>
                            <h2><span data-counter="<?php echo esc_attr($counter); ?>" class="timer"><?php echo esc_html($counter); ?></span><?php echo esc_html($prefix); ?></h2>
                        <?php endif; ?>
                        <?php if($ex_title != ''): ?>
                            <span><?php echo esc_html($ex_title); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
                <?php
                break;
            default:
                ?>
                    <div class="alert alert-warning" role="alert">
                        <?php echo esc_html__('Please select Feature style first.', 'themewar'); ?>
                    </div>
                <?php
                break;
        }
    }
    
    
}