<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Google_Map_Widget extends Widget_Base {

    public function get_name() {
        return 'tw-google-map';
    }

    public function get_title() {
        return esc_html__( 'Google Map', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-google-maps';
    }

    public function get_categories() {
        return [ 'industing-elements' ];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'section_tab', [
                'label' => esc_html__( 'Google Map', 'themewar' ),
            ]
        );
        $this->add_control(
                'map_mode',
                [
                        'label'             => esc_html__( 'Map Mode', 'themewar' ),
                        'type'              => Controls_Manager::SELECT,
                        'default'           => 0,
                        'label_block'       => true,
                        'options' => [
                                0       => esc_html__( 'Select Style', 'themewar' ),
                                1       => esc_html__( 'Ifram', 'themewar' ),
                                2       => esc_html__( 'Custom', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'map_ifram',
                [
                        'label'             => esc_html__( 'Ifram SRC', 'themewar' ),
                        'type'              => Controls_Manager::TEXTAREA,
                        'label_block'       => true,
                        'default'           => esc_html__( '', 'themewar' ),
                        'placeholder'       => esc_html__( 'Insert your google map ifram SRC only', 'themewar' ),
                        'condition'         => ['map_mode' => '1'],
                ]
        );
        $this->add_control(
                'lati',
                [
                        'label'             => esc_html__( 'Location Latitude', 'themewar' ),
                        'type'              => Controls_Manager::TEXT,
                        'label_block'       => true,
                        'default'           => esc_html__( '', 'themewar' ),
                        'placeholder'       => esc_html__( 'Insert your location latitude', 'themewar' ),
                        'condition'         => ['map_mode' => '2']
                ]
        );
        $this->add_control(
                'long',
                [
                        'label'             => esc_html__( 'Location Longitude', 'themewar' ),
                        'type'              => Controls_Manager::TEXT,
                        'label_block'       => true,
                        'default'           => esc_html__( '', 'themewar' ),
                        'placeholder'       => esc_html__( 'Insert your location longitude', 'themewar' ),
                        'condition'         => ['map_mode' => '2']
                ]
        );
        $this->add_control(
                'marker',
                [
                        'label'         => esc_html__( 'Map Marker', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('Upload your map marker. Map marker shold be smallar image.', 'themewar'),
                        'condition'     => ['map_mode' => '2'],
                ]
        );
        $this->add_control(
                'map_height',
                [
                        'label'         => esc_html__( 'Map Height', 'themewar' ),
                        'type'          => Controls_Manager::SLIDER,
                        'size_units'    => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 2000,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'description'   => esc_html__('Insert your map height. Default height is 610px.', 'themewar'),
                        'default'       => ['610'],
                        'selectors'     => [
                                '{{WRAPPER}} .gmap' => 'height: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .gmap iframe' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
            );
        $this->end_controls_section();
    }
    
    protected function render() {
        $settings   = $this->get_settings();
        $map_mode   = (isset($settings['map_mode']) && $settings['map_mode'] > 0) ? $settings['map_mode'] : 0;
        $map_ifram  = (isset($settings['map_ifram']) && $settings['map_ifram'] != '') ? $settings['map_ifram'] : '';
        $lati       = (isset($settings['lati']) && $settings['lati'] != '') ? $settings['lati'] : '';
        $long       = (isset($settings['long']) && $settings['long'] != '') ? $settings['long'] : '';
        $map_height = (isset($settings['map_height']) && $settings['map_height'] != '') ? $settings['map_height'] : '610';
        $marker     = (isset($settings['marker']['url']) && $settings['marker']['url'] != '') ? $settings['marker']['url'] : '';
        
        switch ($map_mode) {
            case 1:
                if($map_ifram != ''):
                    ?><div class="gmap"><iframe src="<?php echo esc_url($map_ifram); ?>"></iframe></div><?php   
                endif;
                break;
            case 2:
                if($lati != '' || $long != ''):
                    ?>
                        <div data-map-style="<?php echo esc_attr($map_style); ?>" data-marker="<?php echo esc_url($marker); ?>" data-lat="<?php echo esc_attr($lati); ?>" data-lon="<?php echo esc_attr($long); ?>" class="gmap" id="gmap"></div>
                    <?php
                endif;
                break;
            default:
                ?>
                    <div class="alert alert-warning" role="alert">
                        <?php echo esc_html__('Please Select Map Style first.', 'themewar'); ?>
                    </div>
                <?php
             break;
        }
    }
    
    protected function _content_template() {
        
    }
}