<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Mailchimp_Form_Widget extends Widget_Base {

    public function get_name() {
        return 'tw-mailchimp-form';
    }

    public function get_title() {
        return esc_html__( 'Subscribe From', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-mailchimp';
    }

    public function get_categories() {
        return [ 'meipaly-elements' ];
    }

    protected function _register_controls() {
        global $wpdb;
        $table = $wpdb->prefix.'posts';
        $result = $wpdb->get_results( 'SELECT * FROM '.$table.' WHERE post_type="mc4wp-form" AND post_status="publish"', OBJECT );
        $shortcodes = array('0' => esc_html__('None', 'bespoke'));
        if(is_array($result) && !empty($result)){
            foreach($result as $r){
                $shortcodes[$r->ID] = $r->post_title;
            }
        }
        $this->start_controls_section(
            'section_tab', [
                'label'     => esc_html__( 'Subscribe Form', 'themewar' ),
            ]
        );
        $this->add_control(
                'mail_form',
                [
                        'label' => esc_html__( 'Select Form', 'themewar' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => '',
                        'options' => $shortcodes,
                ]
        );
        $this->add_responsive_control(
                'form_align', [
                        'label'                     =>esc_html__( 'Alignment', 'themewar' ),
                        'type'                      => Controls_Manager::CHOOSE,
                        'options'                   => [
                                'left'		 => [
                                        'title'	 =>esc_html__( 'Left', 'themewar' ),
                                        'icon'	 => 'fa fa-align-left',
                                ],
                                'center'	 => [
                                        'title'	 =>esc_html__( 'Center', 'themewar' ),
                                        'icon'	 => 'fa fa-align-center',
                                ],
                                'right'		 => [
                                        'title'	 =>esc_html__( 'Right', 'themewar' ),
                                        'icon'	 => 'fa fa-align-right',
                                ]
                        ],
                        'default'                   => 'right',
                        'prefix_class'              => 'mailchimp_align elementor%s-align-',
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_1', [
                'label'	 =>esc_html__( 'Input From Style', 'themewar' ),
                'tab'	 => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
                'input_color',
                [
                        'label' => esc_html__( 'Label Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .subscribefrom input[type="email"]' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .subscribefrom input[type="email"]::-moz-placeholder' => 'color: {{VALUE}} !important',
                                '{{WRAPPER}} .subscribefrom input[type="email"]::-webkit-input-placeholder' => 'color: {{VALUE}} !important',
                                '{{WRAPPER}} .subscribefrom input[type="email"]::-ms-input-placeholder' => 'color: {{VALUE}} !important',
                        ],
                ]
        );
        $this->add_control(
                    'input_height',
                    [
                            'label' => __( 'Input Form Height', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 200,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .subscribefrom input[type="email"]' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                    ]
		);
            $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                            'name' => 'input_typography',
                            'label' => esc_html__( 'Input From Typography', 'themewar' ),
                            'selector' => '{{WRAPPER}} .subscribefrom input[type="email"]',
                    ]
            );
            $this->add_control(
                'input_paddings',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .subscribefrom input[type="email"]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_tab_2', [
                'label'     => esc_html__( 'Button Style', 'themewar' ),
                'tab'	 => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs( 'style_tabs_1' );
                $this->start_controls_tab(
                        'button_style_normal',
                        [
                                'label' => __( 'Normal', 'themewar' ),
                        ]
                );
                $this->add_control(
                        'btn_label_color',
                        [
                                'label' => esc_html__( 'Label Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .subscribefrom input[type="submit"]' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_control(
                        'button_bg',
                        [
                                'label' => esc_html__( 'BG Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .subscribefrom input[type="submit"]' => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'button_style_hover',
                        [
                                'label' => __( 'Hover', 'themewar' ),
                        ]
                );
                $this->add_control(
                        'btn_label_hover_color',
                        [
                                'label' => esc_html__( 'Label Hover Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .subscribefrom input[type="submit"]:hover' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_control(
                        'button_bg_hover',
                        [
                                'label' => esc_html__( 'BG Hover Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .subscribefrom input[type="submit"]:hover' => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_control(
			'height',
			[
				'label' => __( 'Height', 'themewar' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [],
				'selectors' => [
					'{{WRAPPER}} .subscribefrom input[type="submit"]' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
            $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                            'name' => 'button_typography',
                            'label' => esc_html__( 'Button Typography', 'themewar' ),
                            'selector' => '{{WRAPPER}} .subscribefrom input[type="submit"]',
                    ]
            );
            $this->add_control(
                'paddings',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .subscribefrom input[type="submit"]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_control(
                'margins',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .subscribefrom input[type="submit"]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
        $this->end_controls_section();
    }
    
    protected function render() {
        $settings       = $this->get_settings();
        $mail_form      = (isset($settings['mail_form']) && $settings['mail_form'] != '') ? $settings['mail_form'] : '';
        echo '<div class="subscribefrom">';
            if($mail_form > 0):
                echo do_shortcode('[mc4wp_form id="'.$mail_form.'"]');
            endif;
        echo '</div>';
    }

    protected function _content_template() {

    }    
}