<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Post_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-post';
    }
    
    public function get_title() {
        return esc_html__( 'Blog Post', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-post-list';
    }

    public function get_categories() {
        return [ 'industing-elements' ];
    }
    
    protected function _register_controls() {
        $this->start_controls_section(
            'section_tab', [
                'label' =>esc_html__( 'Blog Post', 'themewar' ),
            ]
        );
        $this->add_control(
                'post_style',
                [
                        'label'         => esc_html__( 'Post Style', 'themewar' ),
                        'type'          => Controls_Manager::SELECT,
                        'default'       => 0,
                        'label_block'   => TRUE,
                        'options'       => [
                                0       => esc_html__( 'Select Style', 'themewar' ),
                                1       => esc_html__( '2 Column Mixed', 'themewar' ),
                                2       => esc_html__( '2 Column Grid', 'themewar' ),
                                3       => esc_html__( '2 Column Grid Slide', 'themewar' ),
                                4       => esc_html__( '3 Column Mixed', 'themewar' ),
                                5       => esc_html__( '3 Column Grid', 'themewar' ),
                                6       => esc_html__( '3 Column Grid Slide', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'post_item',
                [
                        'label'     => esc_html__( 'Number Of Item', 'themewar' ),
                        'type'      => Controls_Manager::NUMBER,
                        'min'       => 1,
                        'max'       => 5,
                        'step'      => 1,
                        'default'   => 5,
                ]
        );
        $this->add_control(
                'order_by',
                [
                        'label' => esc_html__( 'Order By', 'themewar' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'date',
                        'options' => [
                                'date'                  => esc_html__( 'Date', 'themewar' ),
                                'title'                 => esc_html__( 'Title', 'themewar' ),
                                'rand'                  => esc_html__( 'Random', 'themewar' ),
                                'comment_count'         => esc_html__( 'Comment', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'order',
                [
                        'label' => esc_html__( 'Order', 'themewar' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'desc',
                        'options' => [
                                'asc'        => esc_html__( 'Ascending', 'themewar' ),
                                'desc'       => esc_html__( 'Descending', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'title_lenght',
                [
                        'label'     => esc_html__( 'Post Title Lenght', 'themewar' ),
                        'type'      => Controls_Manager::NUMBER,
                        'min'       => 0,
                        'max'       => 100,
                        'step'      => 5,
                        'default'   => 55,
                ]
        );
        $this->add_control(
                'desc_lenght',
                [
                        'label'     => esc_html__( 'Content Lenght', 'themewar' ),
                        'type'      => Controls_Manager::NUMBER,
                        'min'       => 0,
                        'max'       => 500,
                        'step'      => 5,
                        'default'   => 420,
                ]
        );
        $this->add_control(
                'read_label',
                [
                        'label'     => esc_html__( 'Read More Label', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'label_block'   => TRUE,
                        'placeholder'   => esc_html__('', 'themewar'),
                        'description'   => esc_html__('Insert your Icon BOx Title.', 'themewar'),
                ]
        );
        
        $this->end_controls_section();
    }
    
    protected function render() {
        $settings   = $this->get_settings();
        $post_style = (isset($settings['post_style']) && $settings['post_style'] > 0) ? $settings['post_style'] : 0;
        $post_item  = (isset($settings['post_item']) && $settings['post_item'] > 0) ? $settings['post_item'] : 5;
        $order_by   = (isset($settings['order_by']) && $settings['order_by'] != '') ? $settings['order_by'] : 'date';
        $order      = (isset($settings['order']) && $settings['order'] != '') ? $settings['order'] : 'desc';
        $title_lenght  = (isset($settings['title_lenght']) && $settings['title_lenght'] != '') ? $settings['title_lenght'] : 55;
        $desc_lenght   = (isset($settings['desc_lenght']) && $settings['desc_lenght'] != '') ? $settings['desc_lenght'] : 420;
        $read_label  = (isset($settings['read_label']) && $settings['read_label'] != '') ? $settings['read_label'] : '';
        
        switch ($post_style){
            case 1:
                require_once dirname(__FILE__).'/style/post/style1.php';
                break;
            case 2:
                require_once dirname(__FILE__).'/style/post/style2.php';
                break;
            case 3:
                require_once dirname(__FILE__).'/style/post/style3.php';
                break;
            case 4:
                require_once dirname(__FILE__).'/style/post/style4.php';
                break;
            case 5:
                require_once dirname(__FILE__).'/style/post/style5.php';
                break;
            case 6:
                require_once dirname(__FILE__).'/style/post/style6.php';
                break;
            default:
                ?>
                    <div class="alert alert-warning" role="alert">
                        <?php echo esc_html__('Please select Post style first.', 'themewar'); ?>
                    </div>
                <?php
                break;
        }
    }
    
    protected function _content_template() {
        
    }
}