<?php
/**
 * Creates widget with recent post Icon
 */

class Tw_Downloadbrochures_Widgets extends WP_Widget
{
    function __construct() 
    {
        $widget_opt = array(
            'classname'     => 'downloadbrochures_widget',
            'description'   => 'Industing Service Brochures Downloader'
        );
        
        parent::__construct('downloadbrochures-post', esc_html__('Industing Brochures Downloader', 'themewar'), $widget_opt);
    }
    
    function widget( $args, $instance ){
        $title = (isset($instance['title'])) ? $instance['title'] : '';
        $brochures = (isset($instance['brochures'])) ? $instance['brochures'] : array();

        echo wp_kses_post($args['before_widget']);
        if ( !empty( $instance[ 'title' ] ) ) {
            echo wp_kses_post($args[ 'before_title' ]) . apply_filters( 'widget_title', $instance[ 'title' ] ) . $args[ 'after_title' ];
        }
        ?>
        <div class="allBrouchers">
            <?php 
                for($i = 0; $i < 5; $i++):
                    $fn = $brochures['fn'][$i];
                    $fs = $brochures['fs'][$i];
                    $fu = $brochures['fu'][$i];
                    if($fn != '' && $fu != ''):
                        ?>
                        <div class="singleBrou">
                            <i class="twi-file-pdf2"></i>
                            <h3><a href="<?php echo esc_url($fu) ?>" target="_blank"><?php echo esc_html($fn); ?> <?php if($fs != ''): ?><span>(<?php echo esc_html($fs); ?>)</span><?php endif; ?></a></h3>
                            <a href="<?php echo esc_url($fu) ?>" target="_blank"><?php echo esc_html__('Download', 'themewar') ?></a>
                        </div>
                        <?php
                    endif;
                endfor;
            ?>
        </div>
        <?php
        echo wp_kses_post($args['after_widget']);
    }
    
    function update ( $new_instance, $old_instance ) 
    {
        return $new_instance;
    }
    
    function form($instance)
    {
        $title = (isset($instance['title']) && $instance['title'] != '') ? $instance['title'] : esc_html__( 'Our Brochures', 'themewar' );
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php _e( 'Title:', 'themewar' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
	</p>
        <div class="tw_brochures_area">
            <label><?php echo esc_html__('Brochures', 'themewar'); ?></label>
            <div class="all_brochures">
                <?php for($i = 0; $i < 5; $i++): ?>
                    <?php
                        $fn = (isset($instance['brochures']['fn'][$i]) ? $instance['brochures']['fn'][$i] : '');
                        $fs = (isset($instance['brochures']['fs'][$i]) ? $instance['brochures']['fs'][$i] : '');
                        $fu = (isset($instance['brochures']['fu'][$i]) ? $instance['brochures']['fu'][$i] : '');
                    ?>
                    <div class="s_f">
                        <input class="widefat sup_names" type="text" name="<?php echo esc_attr($this->get_field_name( 'brochures' )); ?>[fn][<?php echo $i; ?>]" placeholder="<?php echo esc_html__('File Name', 'themewar') ?>" value="<?php echo wp_kses($fn, array()) ?>">
                        <input class="widefat" type="text" name="<?php echo esc_attr($this->get_field_name( 'brochures' )); ?>[fs][<?php echo $i; ?>]" placeholder="<?php echo esc_html__('File Size', 'themewar') ?>" value="<?php echo wp_kses($fs, array()) ?>">
                        <input readonly="" class="widefat sup_urls" type="text" name="<?php echo esc_attr($this->get_field_name( 'brochures' )); ?>[fu][<?php echo $i; ?>]" placeholder="<?php echo esc_html__('File URL', 'themewar') ?>" value="<?php echo wp_kses($fu, array()) ?>">
                        <a class="button sup_files" href="#"><?php echo esc_html__('Upload', 'themewar'); ?></a>
                    </div>
                <?php endfor; ?>
            </div>
        </div>
        <?php
    }
    
}