<?php
/**
 * Creates widget with recent post Icon
 */

class Tw_Service_Widgets extends WP_Widget
{
    function __construct() 
    {
        $widget_opt = array(
            'classname'     => 'service_widget',
            'description'   => 'Industing Service Post With Icon'
        );
        
        parent::__construct('service-post', esc_html__('Industing Service Post', 'themewar'), $widget_opt);
    }
    
    function widget( $args, $instance )
    {
        $title = (isset($instance['title']) && $instance['title'] != '') ? $instance['title'] : esc_html__( 'Our Services', 'themewar' );
        $number_of_posts1 = (isset($instance['number_of_posts1']) && $instance['number_of_posts1'] != '') ? $instance['number_of_posts1'] : 3;
        $ord_by = (isset($instance['ord_by']) && $instance['ord_by'] != '') ? $instance['ord_by'] : 'date';
        $ord = (isset($instance['ord']) && $instance['ord'] != '') ? $instance['ord'] : 'DESC';
        
        
        $title = apply_filters( 'widget_title', $title );
        echo wp_kses_post($args['before_widget']);
        if ( ! empty( $title ) )
        {
            echo wp_kses_post($args['before_title']) . esc_html($title) . $args['after_title'];
        }
        
        
        $stickies = get_option( 'sticky_posts' );
        $querys = array(
            'post_type'         => array('tw-service'),
            'post_status'       => array('publish'),
            'orderby'           => $ord_by,
            'order'             => $ord,
            'posts_per_page'    => $number_of_posts1,
            'post__not_in'      => $stickies
        );
        $tw_query = new WP_Query($querys);
        echo '<ul>';
        if($tw_query->have_posts())
        {
            while($tw_query->have_posts()): $tw_query->the_post();
            $_service_meta = 'twi-campground2';
            if(defined('FW')){
                $_service_meta1 = fw_get_db_post_option(get_the_ID(), 'demo_icon_v2', array());
                if(isset($_service_meta1['icon-class']) && $_service_meta1['icon-class'] != ''):
                    $_service_meta = $_service_meta1['icon-class'];
                endif;
            }
            ?>
            <li><a href="<?php echo get_the_permalink(); ?>"><i class="<?php echo esc_attr($_service_meta); ?>"></i><?php echo substr(wp_kses(get_the_title(), array()), 0, 30); ?></a></li>
            <?php
            endwhile;
        }
        else
        {
            echo '<ul>';
            echo '<li><a href="#">No post found to display.</a></li>';
            echo '</ul>';
            echo '<div class="clearfix"></div>';
        }
        echo '</ul>';
        wp_reset_postdata();
        
        echo wp_kses_post($args['after_widget']);
    }
    
    
    function update ( $new_instance, $old_instance ) 
    {
        return $new_instance;
    }
    
    function form($instance)
    {
        $title = (isset($instance['title']) && $instance['title'] != '') ? $instance['title'] : esc_html__( 'Our Services', 'themewar' );
        $number_of_posts1 = (isset($instance['number_of_posts1']) && $instance['number_of_posts1'] != '') ? $instance['number_of_posts1'] : 3;
        $ord_by = (isset($instance['ord_by']) && $instance['ord_by'] != '') ? $instance['ord_by'] : 'date';
        $ord = (isset($instance['ord']) && $instance['ord'] != '') ? $instance['ord'] : 'DESC';
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php _e( 'Title:', 'themewar' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'number_of_posts1' )); ?>"><?php _e( 'Number Of Posts:' , 'themewar' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'number_of_posts1' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'number_of_posts1' )); ?>" type="number" value="<?php echo esc_attr( $number_of_posts1 ); ?>" />
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'ord_by' )); ?>"><?php _e( 'Order By:' , 'themewar' ); ?></label>
            <select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'ord_by' )); ?>" name="<?php echo esc_attr($this->get_field_id( 'ord_by' )); ?>">
                <option value="date" <?php if($ord_by == 'date'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Date', 'themewar'); ?></option>
                <option value="ID" <?php if($ord_by == 'ID'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('ID', 'themewar'); ?></option>
                <option value="title" <?php if($ord_by == 'title'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Title', 'themewar'); ?></option>
                <option value="rand" <?php if($ord_by == 'rand'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Random', 'themewar'); ?></option>
                <option value="comment_count" <?php if($ord_by == 'comment_count'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Comment Count', 'themewar'); ?></option>
            </select>
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'ord' )); ?>"><?php _e( 'Order:' , 'themewar' ); ?></label>
            <select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'ord' )); ?>" name="<?php echo esc_attr($this->get_field_id( 'ord' )); ?>">
                <option value="ASC" <?php if($ord == 'ASC'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('ASC', 'themewar'); ?></option>
                <option value="DESC" <?php if($ord == 'DESC'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('DESC', 'themewar'); ?></option>
            </select>
	</p>
        
        <?php
    }
}