<?php
/* 
 * ThemeWar Helpar File
 */

/* * ---------------------------------------------------------------
* Sidebar Loop
* -------------------------------------------------------------* */

if (!function_exists('industing_register_sidebars')) {
    function industing_register_sidebars($areas, $defaultParams = array())
    {
        if (empty($defaultParams)) {
            $defaultParams = array(
                'before_widget' => '<div id="%1$s" class="box widget-container %2$s"><div class="box-wrapper">',
                'after_widget' => "</div></div>",
                'before_title' => '<h2 class="widget-title">',
                'after_title' => '</h2>',
            );
        }

        foreach ($areas as $id => $area) {
            $params = array_merge($defaultParams, $area, array('id' => $id));
            register_sidebar($params);
        }
    }
}

/* * ---------------------------------------------------------------
* Google Fonts
* -------------------------------------------------------------* */

if (!function_exists('industing_google_fonts_url')) {
    function industing_google_fonts_url()
    {
        $fonts_url = '';
        $font_families = array();

        $Barlow = _x('on', 'Barlow Condensed font: on or off', 'industing');
        $Rubik = _x('on', 'Rubik font: on or off', 'industing');

        if ('off' !== $Barlow) {
            $font_families[] = 'Barlow Condensed:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i';
        }

        if ('off' !== $Rubik) {
            $font_families[] = 'Rubik:300,300i,400,400i,500,500i,700,700i,900,900i';
        }

        if ($font_families) {
            $query_args = array(
                'family' => urlencode(implode('|', $font_families)),
                'subset' => urlencode('latin,latin-ext'),
            );

            $fonts_url = add_query_arg($query_args, 'https://fonts.googleapis.com/css');
        }

        return esc_url_raw($fonts_url);
    }
}

/* * ---------------------------------------------------------------
* Comment Listing
* -------------------------------------------------------------* */

if (!function_exists('industing_comment_listing')) {
    function industing_comment_listing($comment, $args, $depth)
    {
        $GLOBALS['comment'] = $comment;
        $avater = get_avatar_url($comment->comment_author_email);
        if ($comment->user_id != '' && $comment->user_id != 0) {
            $userId = $comment->user_id;
            $avID = get_the_author_meta('user_av_ID', $userId);
            if ($avID != '') {
                $thumb = wp_get_attachment_image_src($avID, 'industing-sq-xs');
                $userAvater = $thumb[0];
            } else {
                $userAvater = $avater;
            }
        } else {
            $userAvater = $avater;
        }
        $dateformate = get_option('date_format');
        $upvote = (get_comment_meta($comment->comment_ID, 'upvotes', true) != '') ? get_comment_meta($comment->comment_ID, 'upvotes', true) : 0;
        ?>
        <li id="comment-<?php echo esc_attr($comment->comment_ID); ?>">
            <div class="ndComment clearfix <?php if ($comment->comment_type == 'pingback' || $comment->comment_type == 'trackback'){ ?> pingbackcomments <?php } ?>">
                <?php if ($comment->comment_type != 'pingback' && $comment->comment_type != 'trackback'): ?>
                    <img src="<?php echo esc_url($userAvater); ?>" alt="<?php echo esc_attr($comment->comment_author); ?>">
                <?php endif; ?>
                <div class="ndcHead">
                    <h5><a href="#"><?php echo esc_html($comment->comment_author); ?></a></h5>
                    <span><?php echo get_comment_time('jS F Y'); ?></span>
                    <?php comment_reply_link(array_merge($args, array('reply_text' => esc_html__('reply', 'industing'), 'depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
                </div>
                <div class="ndcContent">
                    <?php comment_text(); ?>
                </div>
            </div>
        <?php
    }
}


 /**
 * Post View Count
 * @since  1.0.0
 */

function industing_post_view_count($id){
    
    $view = get_post_meta($id, '_post_view_count', true);
    $view = ( empty($view) ) ? 0 : $view;
    $view += 1;
    
    update_post_meta($id, '_post_view_count', $view);
    
}

 /**
 * check plugin active
 * @since  1.0.0
 */

if (!function_exists('industing_plugin_active')) {
    function industing_plugin_active($plugin)
    {
        return in_array($plugin . '/' . $plugin . '.php', apply_filters('active_plugins', get_option('active_plugins')));
    }
}

if (!function_exists('industing_return')) {
    function industing_return($s)
    {
        return $s;
    }
}

/**
 * Get option value
 * @since  1.0.0
 */

if (!function_exists('industing_option')) {
    function industing_option($option)
    {
        return get_theme_mod($option, industing_defaults($option));
    }
}

/**
 *Default option value
 * @since  1.0.0
 */

if (!function_exists('industing_defaults')) {
    function industing_defaults($options){
        $default = array(
            'body_font' => array(),
            'heading_font' => array(),
            'header_layout' => '1',
            'show_login' => '',
            'show_header_cta' => '',
        );

        if (!empty($default[$options])) {
            return $default[$options];
        }
    }
}


/* * ---------------------------------------------------------------
* Get Author Avater URL
* -------------------------------------------------------------* */
function industing_get_author_avater_url($userid){
    $user_av_ID = get_user_meta($userid, 'user_av_ID', TRUE);
    $email = get_the_author_meta($userid);
    if($user_av_ID > 0){
        $img = wp_get_attachment_image_src($user_av_ID, 'industing-team-2');
        return $img[0];
    }else{
        return get_avatar_url($email, array('size' => 170));
    }
}

/*==============================================================================
/ Site Preloader
/=============================================================================*/
if (!function_exists('industing_preloader_creator')) {
    function industing_preloader_creator()
    {
        $show_preloader = get_theme_mod('show_preloader', 2);
        $proloader = get_theme_mod('proloader', 8);

        $preHTML = '';
        if ($show_preloader == 1) {
            $preHTML .= '<div class="preloader text-center">';
            switch ($proloader) {
                case 1:
                    $preHTML .= '<div class="la-ball-circus la-2x">
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                </div>';
                    break;
                case 2:
                    $preHTML .= '<div class="la-ball-climbing-dot la-2x">
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                </div>';
                    break;
                case 3:
                    $preHTML .= '<div class="la-ball-clip-rotate la-2x">
                                    <div></div>
                                </div>';
                    break;
                case 4:
                    $preHTML .= '<div class="la-ball-clip-rotate-multiple la-2x">
                                    <div></div>
                                    <div></div>
                                </div>';
                    break;
                case 5:
                    $preHTML .= '<div class="la-ball-clip-rotate-pulse la-2x">
                                    <div></div>
                                    <div></div>
                                </div>';
                    break;
                case 6:
                    $preHTML .= '<div class="la-ball-newton-cradle la-2x">
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                </div>';
                    break;
                case 7:
                    $preHTML .= '<div class="la-ball-rotate la-2x">
                                    <div></div>
                                </div>';
                    break;
                case 8:
                    $preHTML .= '<div class="la-ball-scale-multiple la-2x">
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                </div>';
                    break;
                case 9:
                    $preHTML .= '<div class="la-ball-scale-ripple-multiple la-2x">
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                </div>';
                    break;
                case 10:
                    $preHTML .= '<div class="la-ball-zig-zag la-2x">
                                    <div></div>
                                    <div></div>
                                </div>';
                    break;
                case 11:
                    $preHTML .= '<div class="la-fire la-2x">
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                </div>';
                    break;
                case 12:
                    $preHTML .= '<div class="la-line-scale la-2x">
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                </div>';
                    break;
                case 13:
                    $preHTML .= '<div class="la-line-scale-party la-2x">
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                </div>';
                    break;
                case 14:
                    $preHTML .= '<div class="la-line-scale-pulse-out la-2x">
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                </div>';
                    break;
                case 15:
                    $preHTML .= '<div class="la-line-spin-clockwise-fade-rotating la-2x">
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                </div>';
                    break;
                case 16:
                    $preHTML .= '<div class="la-square-jelly-box la-2x">
                                    <div></div>
                                    <div></div>
                                </div>';
                    break;
                case 17:
                    $preHTML .= '<div class="la-square-spin la-2x">
                                    <div></div>
                                </div>';
                    break;
                case 18:
                    $preHTML .= '<div class="loader-inner sk-folding-cube">
                                    <div class="sk-cube1 sk-cube"></div>
                                    <div class="sk-cube2 sk-cube"></div>
                                    <div class="sk-cube4 sk-cube"></div>
                                    <div class="sk-cube3 sk-cube"></div>
                                </div>';
                    break;
                case 19:
                    $preHTML .= '<div class="la-pacman la-2x">
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                    <div></div>
                                </div>';
                    break;
                case 20:
                    $preHTML .= '<div class="la-timer la-2x">
                                    <div></div>
                                </div>';
                    break;

            }
            $preHTML .= '</div>';
        }

        echo wp_kses($preHTML, industing_allowed_html());
    }
}


/*=======================================
/ Product Flash Function
//======================================*/
function industin_product_flash_notice_label($pos = ''){
    global $product;
    
    $shop_is_sale_flash = get_theme_mod('shop_is_sale_flash', 1);
    $shop_bs_limit = get_theme_mod('shop_bs_limit', 50);
    $shop_is_bs_flash = get_theme_mod('shop_is_bs_flash', 1);
    $shop_bs_label = get_theme_mod('shop_bs_label', esc_html__( 'Best Seller', 'industing' ));
    $shop_is_ls_flash = get_theme_mod('shop_is_ls_flash', 1);
    $shop_ls_flash_label = get_theme_mod('shop_ls_flash_label', esc_html__( 'Limited Stock', 'industing' ));
    $shop_is_ji_flash = get_theme_mod('shop_is_ji_flash', 1);
    $shop_ji_limit = get_theme_mod('shop_ji_limit', 7);
    $shop_ji_flash_label = get_theme_mod('shop_ji_flash_label', esc_html__( 'Just In', 'industing' ));
    
    $total_sales = get_post_meta($product->get_id(), 'total_sales', TRUE);
    $_stock = get_post_meta($product->get_id(), '_stock', TRUE);
    $_low_stock_amount = get_post_meta($product->get_id(), '_low_stock_amount', TRUE);
    
    
    $html = '<div class="lavel '.$pos.'">';
        $_sale_price = get_post_meta($product->get_id(), '_sale_price', TRUE);
        $_regular_price = get_post_meta($product->get_id(), '_regular_price', TRUE);
        if($product->is_on_sale() && $shop_is_sale_flash == 1 && !$product->is_type( 'variable' ) && ($_sale_price > 0 && $_regular_price > 0)):
            $off = (100 - round(($_sale_price / $_regular_price ) * 100));
            $html .= '<p class="offer">'.$off.'% '.esc_html__('off', 'industing').'</p>';
        endif;
        if($total_sales >= $shop_bs_limit && $shop_is_bs_flash == 1):
            $html .= '<p class="seller">'.esc_html($shop_bs_label).'</p>';
        endif;
        if($_stock != '' && $_low_stock_amount != '' && $_stock <= $_low_stock_amount && $shop_is_ls_flash == 1):
            $html .= '<p class="limitedStok">'.$shop_ls_flash_label.'</p>';
        endif;
        if($shop_is_ji_flash == 1):
            $datetime1 = new DateTime(get_the_time('Y-m-d'));
            $datetime2 = new DateTime(date('Y-m-d'));
            $difference = $datetime1->diff($datetime2);
            if($difference->d <= $shop_ji_limit):
                $html .= '<p class="justIn">'.$shop_ji_flash_label.'</p>';
            endif;
        endif;
        
    $html .= '</div>';
    
    return $html;
}



//=======================================
// Theme Menu Walker
//=======================================

if (!function_exists('Industing_Popup_Menu_Walker::start_el')) {


    class Industing_Popup_Menu_Walker extends Walker_Nav_Menu {

        function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {

            global $wp_query;

            $indent = ( $depth ) ? str_repeat("\t", $depth) : '';

            $class_names = $value = '';

            $classes = empty($item->classes) ? array() : (array) $item->classes;
            $classes[] = 'menu-item-' . $item->ID;

            // add submenu class if current item is a top menu item
            $menu_link_class = '"';
            $bIsTopMenuItem = false;
            if (in_array("menu-item-has-children", $classes)) {
                $menu_link_class = ' "';
                $bIsTopMenuItem = true;
            }

            if ((in_array("current-menu-item", $classes)) || (in_array("current_page_item", $classes))) {

                $classes[] = 'active';
            }

            $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item, $args));


            $id = apply_filters('nav_menu_item_id', 'menu-item-' . $item->ID, $item, $args);
            $id = $id ? ' id="' . esc_attr($id) . '"' : '';

            $atts = array();
            $atts['title'] = !empty($item->attr_title) ? $item->attr_title : '';
            $atts['target'] = !empty($item->target) ? $item->target : '';
            $atts['rel'] = !empty($item->xfn) ? $item->xfn : '';

            $atts = apply_filters('nav_menu_link_attributes', $atts, $item, $args);

            $attributes = '';
            foreach ($atts as $attr => $value) {
                if (!empty($value)) {
                    $attributes .= ' ' . $attr . '="' . $value . '"';
                }
            }

            if ($item->object == 'page') {
                $page_post = get_post($item->object_id);
                $section_page = (get_post_meta($item->object_id, "section_status", true) == 'yes');
                $disable_menu = (get_post_meta($item->object_id, "menu_status", true) == 'yes');
                $main_page_id = get_option('page_on_front');

                if (!$disable_menu || ( $page_post->ID == $main_page_id )) {

                    
                        if (!$section_page)
                            $attributes .=!empty($item->url) ? ' href="' . esc_attr($item->url) . '"' : '';
                        else {
                            if (is_front_page())
                                $attributes .= ' href="#' . $item->object_id . '"';
                            else
                                $attributes .= ' href="' . home_url() . '#' . $item->object_id . '"';
                        }
                    

                    $item_output = $args->before;
                    
                        if ($section_page && is_front_page())
                            $item_output .= '<a class="collapse_menu1' . $menu_link_class . ' ' . $attributes . '>';
                        else
                            $item_output .= '<a class="external' . $menu_link_class . ' ' . $attributes . '>';
                    
                    

                    $item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . $args->link_after;
                    $item_output .= '</a>';
                    $item_output .= $args->after;

                    if ($section_page || ($page_post->ID == $main_page_id)) {
                        if(is_front_page()):
                            if(($page_post->ID != $main_page_id)):
                                $class_names = $class_names ? ' scroll '.esc_attr($class_names) : '';
                            else:
                                $class_names = $class_names ? esc_attr($class_names) : ''; 
                            endif;
                        endif;
                    } else {
                        $class_names = $class_names ? esc_attr($class_names) : '';
                    }

                    $output .= $indent . '<li' . $id . $value . ' class="'.esc_attr($class_names).'">';
                    $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
                }
            } else {
                $class_names = $class_names ? ' class="' . esc_attr($class_names) . '"' : '';
                
                $attributes .=!empty($item->url) ? ' href="' . esc_attr($item->url) . '"' : '';

                $item_output = $args->before;
                $item_output .= '<a class="externala' . $menu_link_class . ' ' . $attributes . '>';

                $item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . $args->link_after;
                $item_output .= '</a>';
                $item_output .= $args->after;

                $output .= $indent . '<li' . $id . $value . $class_names . '>';
                $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
            }
        }

        function start_lvl(&$output, $depth = 0, $args = array()) {
            $indent = str_repeat("\t", $depth);
            $output .= "\n$indent<ul class=\"sub-menu dl-submenu\">\n";
        }
        
        
        function end_el(&$output, $item, $depth=0, $args=array()) {
            if ($item->object == 'page')
            {
                $disable_menu = (get_post_meta($item->object_id, "menu_status", true) == 'yes');
                if(!$disable_menu)
                {
                    $output .= "</li>\n";
                }
            }
            else
            {
                $output .= "</li>\n";
            }
        }

    }

}


function industing_get_date_format(){
    $date_format = get_option('date_format');
    if($date_format != ''):
        return $date_format;
    else:
        return 'd M';
    endif;
}


//=======================================
// HTML Kses
//=======================================
function industing_allowed_html() {
	$allowed_tags = array(
		'a'								 => array(
			'class'	 => array(),
			'href'	 => array(),
			'rel'	 => array(),
			'title'	 => array(),
		),
		'abbr'							 => array(
			'title' => array(),
		),
		'b'								 => array(),
		'blockquote'					 => array(
			'cite' => array(),
		),
		'cite'							 => array(
			'title' => array(),
		),
		'code'							 => array(),
		'del'							 => array(
			'datetime'	 => array(),
			'title'		 => array(),
		),
		'dd'							 => array(),
		'div'							 => array(
			'class'	 => array(),
			'title'	 => array(),
			'style'	 => array(),
		),
		'dl'							 => array(),
		'dt'							 => array(),
		'em'							 => array(),
		'h1'							 => array(),
		'h2'							 => array(),
		'h3'							 => array(),
		'h4'							 => array(),
		'h5'							 => array(),
		'h6'							 => array(),
		'i'								 => array(
			'class' => array(),
		),
		'img'							 => array(
			'alt'	 => array(),
			'class'	 => array(),
			'height' => array(),
			'src'	 => array(),
			'width'	 => array(),
			'id'	 => array(),
		),
		'li'							 => array(
			'class' => array(),
		),
		'ol'							 => array(
			'class' => array(),
		),
		'p'								 => array(
			'class' => array(),
		),
		'q'								 => array(
			'cite'	 => array(),
			'title'	 => array(),
		),
		'span'							 => array(
			'class'	 => array(),
			'title'	 => array(),
			'style'	 => array(),
		),
		'iframe'						 => array(
			'width'			 => array(),
			'height'		 => array(),
			'scrolling'		 => array(),
			'frameborder'	 => array(),
			'allow'			 => array(),
			'src'			 => array(),
		),
		'strike'						 => array(),
		'br'							 => array(),
		'strong'						 => array(),
		'data-wow-duration'				 => array(),
		'data-wow-delay'				 => array(),
		'data-wallpaper-options'		 => array(),
		'data-stellar-background-ratio'	 => array(),
		'ul'							 => array(
			'class' => array(),
		),
	);

	return $allowed_tags;
}