<?php
/**
 * Template Name: Member Page
 */

get_header();
get_template_part('template-parts/header/member', 'header');

$mem_list_style = get_theme_mod('mem_list_style', 1);
$mem_list_num_of_item = get_theme_mod('mem_list_num_of_item', 6);
$mem_pagi_align = get_theme_mod('mem_pagi_align', 'center');
?>
<section class="commonSection teamSection">
    <div class="container">
        <div class="row">
            <?php
                global $wp_query;
                $page = (get_query_var('paged') != '') ? get_query_var('paged') : 1;
                $fargs = array(
                        'post_type'         => 'member',
                        'post_status'       => 'publish',
                        'posts_per_page'    => $mem_list_num_of_item,
                        'orderby'           => 'date',
                        'order'             => 'desc',
                        'paged'             => $page
                );

                $wp_query = new WP_Query($fargs);
                if($wp_query->have_posts()):
                    while($wp_query->have_posts()):
                        $wp_query->the_post();
                
                        $mem_designation = '';
                        $mem_socials = array();
                        if(defined('FW')){
                            $mem_designation = fw_get_db_post_option(get_the_ID(), 'mem_designation', '');
                            $mem_socials = fw_get_db_post_option(get_the_ID(), 'mem_socials', array());
                        }
                        
                        if($mem_list_style == 2): ?>
                            <div class="col-xl-4 col-md-6 col-lg-4">
                                <div class="singleTeam02">
                                    <div class="st2_inner">
                                        <?php if(has_post_thumbnail()): ?>
                                            <?php echo get_the_post_thumbnail(get_the_ID(), 'industing-team-2'); ?>
                                        <?php else: ?>
                                            <img src="http://via.placeholder.com/342x342" alt="<?php echo get_the_title(); ?>">
                                        <?php endif; ?>
                                        <h2><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h2>
                                        <?php if($mem_designation != ''): ?>
                                            <span><?php echo esc_html($mem_designation); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="col-xl-4 col-md-6 col-lg-4 mb60">
                                <div class="singleTeam text-center">
                                    <?php if(has_post_thumbnail()): ?>
                                        <?php echo get_the_post_thumbnail(get_the_ID(), 'industing-team-1'); ?>
                                    <?php else: ?>
                                        <img src="http://via.placeholder.com/370x421" alt="<?php echo get_the_title(); ?>">
                                    <?php endif; ?>
                                    <div class="team_details">
                                        <?php if($mem_designation != ''): ?>
                                        <span><?php echo esc_html($mem_designation) ?></span>
                                        <?php endif; ?>
                                        <h3><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h3>
                                        <p>
                                            <?php echo substr(wp_strip_all_tags(get_the_content()), 0, 148); ?>
                                        </p>
                                        <div class="teamsocials">
                                            <?php
                                                if(is_array($mem_socials) && !empty($mem_socials)):
                                                    foreach($mem_socials as $ms):
                                                        $mem_social_icon = (isset($ms['mem_social_icon']) && $ms['mem_social_icon'] != '') ? $ms['mem_social_icon'] : '';
                                                        if(isset($mem_social_icon['type']) && $mem_social_icon['type'] == 'icon-font' && isset($mem_social_icon['icon-class']) && $mem_social_icon['icon-class'] != ''){
                                                            $icon = $mem_social_icon['icon-class'];
                                                        }else{
                                                            $icon = '';
                                                        }
                                                        $mem_social_url  = (isset($ms['mem_social_url']) && $ms['mem_social_url'] != '') ? $ms['mem_social_url'] : '#';
                                                        if($icon != ''):
                                                            echo '<a href="'.esc_url($mem_social_url).'"><i class="'.esc_attr($icon).'"></i></a>';
                                                        endif;
                                                    endforeach;
                                                endif;
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif;
                    endwhile;
                endif;
            ?>
        </div>
        <div class="row">
            <div class="col-lg-12 col-sm-12">
                <div class="ind_pagination text-<?php echo esc_attr($mem_pagi_align); ?>">
                    <?php 
                        the_posts_pagination( array(
                            'prev_text' => '<i class="twi-arrow-left2"></i>',
                            'next_text' =>  '<i class="twi-arrow-right2"></i>',
                            'before_page_number' => '0'
                        ));
                    ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php
    $mem_list_bloks = get_theme_mod('mem_list_bloks', '');
    $blocks_id = array();
    if(!empty($mem_list_bloks)){
        foreach($mem_list_bloks as $sb):
            if($sb['block_ids'] != '' && $sb['block_ids'] != 'none'):
                $blocks_id[] = $sb['block_ids'];
            endif;
        endforeach;
        $bloks = array(
            'post_type'     => 'blocks',
            'post_status'   => 'publish',
            'post__in'      => $blocks_id
        );
        $blok = new WP_Query($bloks);
        if($blok->have_posts()):
            while($blok->have_posts()):
            $blok->the_post();
            the_content();
            endwhile;
        endif;
    }
get_footer();