<?php
/**
 * The template for displaying all pages
 */

get_header(); 
get_template_part( 'template-parts/header/page', 'header' );

$page_sidebar = 2;
if(defined('FW')){
    $page_sidebar = fw_get_db_post_option(get_the_ID(), 'page_sidebar', 2);
}

if($page_sidebar == 2 || !is_active_sidebar('sidebar-2')){
    $class = 'col-md-10 col-sm-12 offset-md-1';
}else{
    $class = 'col-sm-8';
}

?>
<section class="commonSection blogDetails">
    <div class="container">
        <div class="row">
            <?php 
                if($page_sidebar == 1 && is_active_sidebar('sidebar-2')):
                    echo '<div class="col-xl-4 col-md-12 col-lg-4">';
                        echo '<div class="sidebar_2 inLeft">';
                            dynamic_sidebar('sidebar-2');
                        echo '</div>';
                    echo '</div>';
                endif;
            ?>
            <div class="<?php echo esc_attr($class); ?>">
                <?php 
                    while(have_posts()): the_post();
                        $cls = '';
                        if(!has_post_thumbnail()){
                            $cls = 'nopostthumbs';
                        }
                        $thumbnail = 'industing-blog-4';
                        if($page_sidebar == 2 || !is_active_sidebar('sidebar-2')){
                            $thumbnail = 'industing-folio-4';
                        }
                        ?>
                        <div <?php post_class(array('newsDetailsArea', $cls)); ?>>
                            <?php if(has_post_thumbnail()): ?>
                            <div class="newsThumb">
                                <div class="ntItem">
                                    <?php echo get_the_post_thumbnail(get_the_ID(), $thumbnail); ?>
                                </div>
                            </div>
                            <?php endif; ?>
                            <div class="newsDetails">
                                <div class="nd_content clearfix">
                                    <?php if(has_excerpt()): ?>
                                        <div class="excerptArea">
                                            <?php echo get_the_excerpt(); ?>
                                        </div>
                                    <?php endif; ?>
                                    <?php the_content(); ?>
                                    <div class="clearfix"></div>
                                    <?php
                                        wp_link_pages(
                                                array(
                                                        'before' => '<div class="industing_page_links"><strong>' . esc_html__( 'Pages:', 'industing' ).'</strong>',
                                                        'after'  => '</div>',
                                                        'link_before'      => '<span>',
                                                        'link_after'       => '</span>',
                                                )
                                        );
                                    ?>
                                    <div class="clearfix"></div>
                                </div>
                                <?php if ( comments_open() || get_comments_number() ): ?>
                                    <?php comments_template(); ?>
                                    <div class="clearfix"></div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php
                    endwhile; 
                ?>
            </div>
            <?php 
                if($page_sidebar == 3 && is_active_sidebar('sidebar-2')):
                    echo '<div class="col-xl-4 col-md-12 col-lg-4">';
                        echo '<div class="sidebar_2">';
                            dynamic_sidebar('sidebar-2');
                        echo '</div>';
                    echo '</div>';
                endif;
            ?>
        </div>
    </div>
</section>
<?php get_footer();
