<?php
/**
 * The template for displaying all single posts
 */

get_header();
get_template_part( 'template-parts/header/blog-single', 'header' );

if(function_exists('industing_post_view_count')){
    industing_post_view_count(get_the_ID());
}

$post_sidebar = get_theme_mod('post_sidebar', 3);
$post_social = get_theme_mod('post_social', 1);
$post_meta = get_theme_mod('post_meta', 1);
$post_title = get_theme_mod('post_title', 1);
$post_tag = get_theme_mod('post_tag', 1);
$taq_title = get_theme_mod('taq_title', '');
$social_title = get_theme_mod('social_title', '');
$post_navigation = get_theme_mod('post_navigation', 1);
$post_author = get_theme_mod('post_author', 2);

if(!is_active_sidebar('sidebar-1')):
    $post_sidebar = 1;
endif;

if($post_sidebar == 1){
    $class = 'col-xl-10 offset-xl-1 col-md-12 offset-md-0';
}else{
    $class = 'col-xl-8 col-md-12 col-lg-8';
}

?>
<section class="commonSection newsDetailsSection">
    <div class="container">
        <div class="row">
            <?php 
                if($post_sidebar == 2):
                    get_sidebar();
                endif;
            ?>
            <div class="<?php echo esc_attr($class); ?>">
                <?php while(have_posts()): the_post(); ?>
                    <?php
                        $audio_src = '';
                        $video_src = '';
                        $gallery_images = array();
                        if(defined('FW')){
                            $audio_src = fw_get_db_post_option(get_the_ID(), 'audio_src', '');
                            $video_src = fw_get_db_post_option(get_the_ID(), 'video_src', '');
                            $gallery_images = fw_get_db_post_option(get_the_ID(), 'gallery_images', array());
                        }
                        
                        $cls = '';
                        if(!empty($gallery_images) && $audio_src == '' && $video_src == '' && !has_post_thumbnail()){
                            $cls = 'nopostthumbs';
                        }
                        $thumbnail_size = 'industing-blog-4';
                        if($post_sidebar == 1 || !is_active_sidebar( 'sidebar-1' )){
                            $thumbnail_size = 'industing-folio-4';
                        }
                    ?>
                    <div class="newsDetailsArea <?php echo esc_attr($cls); ?>">
                        <?php if(get_post_format() == 'gallery' && is_array($gallery_images) && !empty($gallery_images)): ?>
                            <div class="carousel slide postCarousel" id="pc_<?php echo get_the_ID(); ?>" data-ride="carousel">
                                <div class="carousel-inner">
                                    <?php 
                                        $i = 1; 
                                        foreach($gallery_images as $gal):
                                            $img = wp_get_attachment_image_src($gal['attachment_id'], $thumbnail_size);
                                            ?>
                                            <div class="carousel-item <?php if($i == 1){ echo 'active'; } ?>">
                                                <img src="<?php echo esc_url($img[0]) ?>" alt="<?php the_title_attribute(); ?>">
                                            </div>
                                            <?php
                                            $i++;
                                        endforeach;
                                    ?>
                                </div>
                                <a class="left carousel-control" href="#pc_<?php echo get_the_ID(); ?>" role="button" data-slide="prev">
                                    <i class="twi-arrow-left2"></i>
                                </a>
                                <a class="right carousel-control" href="#pc_<?php echo get_the_ID(); ?>" role="button" data-slide="next">
                                    <i class="twi-arrow-right2"></i>
                                </a>
                            </div>
                        <?php else: ?>
                            <?php if(has_post_thumbnail()): ?>

                            <?php endif; ?>
                        <?php endif; ?>
                        <div class="newsDetails">
                            <?php if($post_meta == 1): ?>
                            
                            <?php endif; ?>
                            <?php if($post_title == 1): ?>
                            <?php endif; ?>
                            <div class="nd_content">
                                <?php if(has_excerpt()): ?>
                                    <div class="excerptArea">
                                        <?php echo get_the_excerpt(); ?>
                                    </div>
                                <?php endif; ?>
                                <?php the_content(); ?>
                                <div class="clearfix"></div>
                                <?php
                                    wp_link_pages(
                                            array(
                                                    'before' => '<div class="industing_page_links"><strong>' . esc_html__( 'Pages:', 'industing' ).'</strong>',
                                                    'after'  => '</div>',
                                                    'link_before'      => '<span>',
                                                    'link_after'       => '</span>',
                                            )
                                    );
                                ?>
                                <div class="clearfix"></div>
                            </div>
                            <div class="row mb50">
                                <?php if($post_tag == 1): ?>
                                    <div class="col-xl-6 col-md-6">

                                    </div>
                                <?php endif; ?>
                                <?php if($post_social == 1): ?>
                                
                                <?php endif; ?>
                            </div>
                            <div class="clearfix mh1"></div>
                            <?php if($post_navigation == 1): ?>
                                <?php
                                    $prevpost = get_previous_post();
                                    $nextpost = get_next_post();
                                ?>

                            <?php endif; ?>
                           
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
            <?php 
                if($post_sidebar == 3):
                    get_sidebar();
                endif;
            ?>
        </div>
    </div>
</section>
<?php
    $sing_blog_bloks = get_theme_mod('sing_blog_bloks', '');
    $blocks_id = array();
    if(!empty($sing_blog_bloks)){
        foreach($sing_blog_bloks as $sb):
            if($sb['block_ids'] != '' && $sb['block_ids'] != 'none'):
                $blocks_id[] = $sb['block_ids'];
            endif;
        endforeach;
        $bloks = array(
            'post_type'     => 'blocks',
            'post_status'   => 'publish',
            'post__in'      => $blocks_id
        );
        $blok = new WP_Query($bloks);
        if($blok->have_posts()):
            while($blok->have_posts()):
            $blok->the_post();
            the_content();
            endwhile;
        endif;
    }
get_footer();
