<?php
$blog_style = get_theme_mod('blog_style', 1);
$blog_sidebar = get_theme_mod('blog_sidebar', 3);

if(!is_active_sidebar('sidebar-1')){
    $blog_sidebar = 1;
}

if($blog_sidebar == 1){
    $class = 'col-md-12 col-sm-12';
}else{
    $class = 'col-lg-12 col-sm-12';
}

$category = '';
$terms = get_the_terms(get_the_ID(), 'category');
if (is_array($terms) && !empty($terms)):
    $p = 1;
    $c = count($terms);
    foreach ($terms as $term):
        if($p == $c):
            $category .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>';
        else:
            $category .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>, ';
        endif;
        $p++;
    endforeach;
endif;

?>
<div class="<?php echo esc_attr($class); ?>">
    <div class="singleBlog post1Col <?php if(is_sticky()){ echo 'featured_post'; } ?> <?php if(!has_post_thumbnail()){ echo 'noPostThumbs'; } ?>">
        <?php if(has_post_thumbnail()): ?>
            <div class="sbThumb">
                <?php echo get_the_post_thumbnail(get_the_ID(), 'industing-folio-4'); ?>
            </div>
        <?php endif; ?>
        <div class="sbDetails">
            <?php if($category != ''): ?>
                <p class="sb_cats">
                    <?php echo wp_kses($category, industing_allowed_html()); ?>
                </p>
            <?php endif; ?>
            <h4>
                <a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a>
            </h4>
            <div class="big_post_desc">
                <?php 
                    if(strlen(wp_strip_all_tags(get_the_content(), TRUE)) > 250)
                    {
                        $contents = wp_strip_all_tags(get_the_content(), TRUE);
                        echo substr($contents, 0, strpos($contents, ' ', 250)).'...';
                    }
                    else
                    {
                        echo wp_strip_all_tags(get_the_content(), TRUE);
                    }
                ?>
            </div>
        </div>
        <div class="sb_footer">
            <span><i class="twi-comments2"></i><a href="<?php echo get_the_permalink(); ?>"><?php echo comments_number( '0 '.esc_html__('Comments', 'industing'), '01 '.esc_html__('Comment', 'industing'), '% '.esc_html__('Comments', 'industing') ) ?></a></span>
            <span><i class="twi-user2"></i><?php echo esc_html__('By', 'industing') ?> <a href="<?php echo get_author_posts_url(get_the_author_meta('ID')) ?>"><?php echo get_the_author(); ?></a></span>
        </div>
    </div>
</div>