<?php
/**
 * Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.5.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<section class="commonSection shopSections checkoutPage">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <?php do_action( 'woocommerce_before_checkout_form', $checkout ); ?>
            </div>
        </div>
        <?php if ( ! $checkout->is_registration_enabled() && $checkout->is_registration_required() && ! is_user_logged_in() ): ?>
        <div class="row">
            <div class="col-lg-12">
                <?php
                    echo esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', esc_html__( 'You must be logged in to checkout.', 'industing' ) ) );
                ?>
            </div>
        </div>
        <?php
                echo '</div>';
            echo '</section>';
            return;
        endif; 
        ?>
        <div class="row">
            <div class="col-lg-12">
                <form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">
                    <div class="row">
                        <?php if ( $checkout->get_checkout_fields() ) : ?>
                        <div class="col-lg-6">
                            <?php do_action( 'woocommerce_checkout_before_customer_details' ); ?>
                            <div id="customer_details">
                                <div class="ind-form-billing">
                                    <?php do_action( 'woocommerce_checkout_billing' ); ?>
                                </div>
                                <div class="ind-form-shipping">
                                    <?php do_action( 'woocommerce_checkout_shipping' ); ?>
                                </div>
                            </div>
                            <?php do_action( 'woocommerce_checkout_after_customer_details' ); ?>
                        </div>
                        <div class="col-lg-6">
                        <?php else: ?>
                            <div class="col-lg-6">
                        <?php endif; ?>
                            <?php do_action( 'woocommerce_checkout_before_order_review_heading' ); ?>
                            <h3  class="comonTitle" id="order_review_heading"><?php esc_html_e( 'Your order', 'industing' ); ?></h3>
                            <?php do_action( 'woocommerce_checkout_before_order_review' ); ?>
                            <div id="order_review" class="woocommerce-checkout-review-order">
                                <?php do_action( 'woocommerce_checkout_order_review' ); ?>
                            </div>
                            <?php do_action( 'woocommerce_checkout_after_order_review' ); ?>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <?php do_action( 'woocommerce_after_checkout_form', $checkout ); ?>
            </div>
        </div>
    </div>
</section>