<?php
defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>
<div class="single_list_product">
    <div class="row">
        <div class="col-lg-5">
            <div class="slp_img">
                <?php if(has_post_thumbnail()): ?>
                    <?php echo get_the_post_thumbnail(get_the_ID(), 'industing-pro-1'); ?>
                <?php else: ?>
                    <img src="http://via.placeholder.com/390x312" alt="<?php echo get_the_title(); ?>">
                <?php endif; ?>
            </div>
            <?php echo industin_product_flash_notice_label(); ?>
        </div>
        <div class="col-lg-7">
            <div class="slp_desc">
                <h2 class="slp_title"><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h2>
                <div class="slp_price clearfix">
                    <?php if(function_exists('woocommerce_template_loop_price')){ echo woocommerce_template_loop_price(); } ?>
                    <?php if(function_exists('woocommerce_template_loop_rating')){ echo woocommerce_template_loop_rating(); } ?>
                </div>
                <div class="clearfix"></div>
                <div class="slp_content">
                    <p>
                        <?php
                            $shop_sidebar = get_theme_mod('shop_sidebar', 1);
                            $content = wp_strip_all_tags($product->get_short_description());
                            if($shop_sidebar != 1):
                                if(strlen($content) > 90):
                                    echo substr($contents, 0, 90).'...';
                                else:
                                    echo wp_kses($content, industing_allowed_html());
                                endif;
                            else:
                                if(strlen($content) > 205):
                                    echo substr($contents, 0, 205).'...';
                                else:
                                    echo wp_kses($content, industing_allowed_html());
                                endif;
                            endif;
                        ?>
                    </p>
                </div>
                <div class="slp_btn">
                    <a class="popUp" href="<?php echo get_the_permalink(); ?>"><i class="twi-search1"></i><?php esc_html_e('View Details', 'industing') ?></a>
                    <?php if(function_exists('woocommerce_template_loop_add_to_cart')){ echo woocommerce_template_loop_add_to_cart();} ?>
                </div>
            </div>
         </div>
    </div>
</div>