<?php
/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
 
get_header( 'shop' ); 
get_template_part( 'template-parts/header/shop-single', 'header' );
if(function_exists('industing_post_view_count')){
    industing_post_view_count(get_the_ID());
}

?>
<section class="commonSection shopDetails">
	<div class="container">
		<?php while ( have_posts() ) : the_post(); ?>
			<?php wc_get_template_part( 'content', 'single-product' ); ?>
		<?php endwhile; // end of the loop. ?>
	</div>
</section>

<?php 
$product_bloks = get_theme_mod('product_bloks', '');
$blocks_id = array();
if(!empty($product_bloks)){
    foreach($product_bloks as $sb):
        if($sb['block_ids'] != '' && $sb['block_ids'] != 'none'):
            $blocks_id[] = $sb['block_ids'];
        endif;
    endforeach;
    $bloks = array(
        'post_type'     => 'blocks',
        'post_status'   => 'publish',
        'post__in'      => $blocks_id
    );
    $blok = new WP_Query($bloks);
    if($blok->have_posts()):
        while($blok->have_posts()):
        $blok->the_post();
        the_content();
        endwhile;
    endif;
}

get_footer( 'shop' );

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
