<?php
$query = array(
    'post_type'         => 'post',
    'post_status'       => 'publish',
    'posts_per_page'    => $post_item,
    'orderby'           => $order_by,
    'order'             => $order
);

$post = new WP_Query($query);
if($post->have_posts()):
    ?>
    <div class="row">
        <?php if($post_style == 6): ?>
        <?php echo '<div class="blog_slide_2 owl-carousel">'; ?>
            <?php 
                $i = 1;
                while($post->have_posts()):
                $post->the_post();
                $audio_src = '';
                $video_src = '';
                $gallery_images = array();
                if(defined('FW')){
                    $audio_src = fw_get_db_post_option(get_the_ID(), 'audio_src', '');
                    $video_src = fw_get_db_post_option(get_the_ID(), 'video_src', '');
                    $gallery_images = fw_get_db_post_option(get_the_ID(), 'gallery_images', array());
                }
                ?>
                <div class="blogItem3 <?php if(!has_post_thumbnail()){ echo 'npt';} ?>">
                    <?php if(get_post_format() == 'gallery' && (is_array($gallery_images) && !empty($gallery_images))): ?>
                        <div class="carousel slide postCarousel" id="pc_<?php echo get_the_ID(); ?>" data-ride="carousel">
                            <div class="carousel-inner">
                                <?php 
                                    $i = 1; 
                                    foreach($gallery_images as $gal):
                                        $img = wp_get_attachment_image_src($gal['attachment_id'], 'industing-blog-3');
                                        ?>
                                        <div class="carousel-item <?php if($i == 1){ echo 'active'; } ?>">
                                            <div class="bi3_thumb">
                                                <img src="<?php echo esc_url($img[0]) ?>" alt="">
                                            </div>
                                        </div>
                                        <?php
                                        $i++;
                                    endforeach;
                                ?>
                            </div>
                            <a class="left carousel-control" href="#pc_<?php echo get_the_ID(); ?>" role="button" data-slide="prev">
                                <i class="twi-arrow-left2"></i>
                            </a>
                            <a class="right carousel-control" href="#pc_<?php echo get_the_ID(); ?>" role="button" data-slide="next">
                                <i class="twi-arrow-right2"></i>
                            </a>
                        </div>
                    <?php else: ?>
                        <?php if(has_post_thumbnail()): ?>
                            <div class="bi3_thumb">
                                <?php echo get_the_post_thumbnail(get_the_ID(), 'industing-blog-3'); ?>
                                <?php if(get_post_format() == 'audio' && $audio_src != ''): ?>
                                    <a href="<?php echo esc_url($audio_src); ?>" class="newsMedia"><i class="twi-volume2"></i></a>
                                <?php elseif(get_post_format() == 'video' && $video_src != ''): ?>
                                    <a href="<?php echo esc_url($video_src); ?>" class="newsMedia"><i class="twi-play1"></i></a>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                    <p class="bmeta">
                        <a href="<?php echo get_the_permalink(); ?>"><i class="twi-calendar-alt2"></i><?php echo get_the_time('jS, M, Y'); ?></a>
                        <a href="<?php echo get_the_permalink(); ?>"><i class="twi-comments2"></i><?php echo comments_number('0 '.esc_html__('Comment', 'themewar'), '1 '.  esc_html__('Comment', 'themewar'), '% '.  esc_html__('Comments', 'themewar')); ?></a>
                    </p>
                    <h3>
                        <a href="<?php echo get_the_permalink(); ?>">
                            <?php 

                                $title = wp_kses(get_the_title(), array());
                                if(strlen($title) > $title_lenght):
                                            echo substr($title, 0, $title_lenght);  
                                else:
                                    echo $title;
                                endif;
                            ?>
                        </a>
                    </h3>
                    <div class="bdesc">
                        <?php 
                            $content = wp_kses(get_the_content(), array());
                            if(strlen($content) > $desc_lenght):
                                        echo substr($content, 0, $desc_lenght);  
                            else:
                                echo $content;
                            endif;
                        ?>
                    </div>
                    <div class="bauthor">
                        <img src="<?php echo esc_url(industing_get_author_avater_url(get_the_author_meta('ID'))); ?>" alt="<?php echo get_the_author(); ?>">
                        <a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"><?php echo get_the_author(); ?></a>
                    </div>
                </div>
                <?php
            endwhile;
            $i++;
            ?>
    <?php echo '</div>'; ?>
    <?php endif; ?>
    </div>
    <?php
endif;
wp_reset_postdata();
?>   