<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Carousel_Image_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-image-carousel';
    }
    
    public function get_title() {
        return esc_html__( 'Image Carousel', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-featured-image';
    }

    public function get_categories() {
        return [ 'industing-elements' ];
    }
    
    protected function _register_controls() {
        $this->start_controls_section(
                'section_tab_1',
                [
                    'label'     => esc_html__('Image', 'themewar')
                ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
                'slide_img',
                [
                        'label'         => esc_html__( 'Images', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('Image size should be 952x1033px.', 'themewar'),
                ]
        );
        $this->add_control(
            'list',
            [
                    'label'         => esc_html__( 'Image', 'themewar' ),
                    'type'          => Controls_Manager::REPEATER,
                    'fields'        => $repeater->get_controls(),
                    'default'       => [
                            [
                                    'slide_img'        => esc_html__( 'Item', 'themewar' ),

                            ],
                    ],
                    'title_field' => "{{{ slide_img }}}",
            ]
        );
        $this->add_control(
                'img_stetch',
                [
                        'label'         => esc_html__( 'Image Strech Full', 'themewar' ),
                        'type'          => Controls_Manager::SELECT,
                        'description'   => esc_html__('Do You Want stretch This Column?', 'themewar'),
                        'default'       => 2,
                        'options'       => [
                                1       => esc_html__( 'Yes', 'themewar' ),
                                2       => esc_html__( 'No', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'img_full_height',
                [
                        'label'         => esc_html__( 'Is Full Height', 'themewar' ),
                        'type'          => Controls_Manager::SELECT,
                        'description'   => esc_html__('Do You Want resize this this image as full height?', 'themewar'),
                        'default'       => 2,
                        'options'       => [
                                1       => esc_html__( 'Yes', 'themewar' ),
                                2       => esc_html__( 'No', 'themewar' ),
                        ],
                ]
        );
        $this->end_controls_section();
    }
    protected function render() {
        $settings       = $this->get_settings();
        $img_stetch     = (isset($settings['img_stetch']) && $settings['img_stetch'] > 0) ? $settings['img_stetch'] : 2;
        $img_full_height= (isset($settings['img_full_height']) && $settings['img_full_height'] > 0) ? $settings['img_full_height'] : 2;
        
        $list           = (isset($settings['list']) && !empty($settings['list'])) ? $settings['list'] : array();
        
        if(!empty($list)): ?>
            <?php if($img_stetch == 1){ echo '<div class="tw-stretch-element-inside-column">'; } ?>
                <div id="imgslider_<?php echo get_the_ID(); ?>" class="imgCarousel carousel slide <?php if($img_full_height == 1){ echo 'fullHeightCaro';} ?>" data-ride="carousel">
                    <div class="carousel-inner">
                        <?php
                        $i = 1; 
                        foreach ($list as $item):
                            $slide_img  = (isset($item['slide_img']['url'])) ? $item['slide_img']['url'] : 'https://via.placeholder.com/952x1033.jpg';
                            ?>
                                <div class="carousel-item <?php if($i == 1){ echo 'active'; } ?>">
                                    <img src="<?php echo esc_url($slide_img); ?>" alt=""/>
                                </div>
                            <?php
                            $i++;
                        endforeach;
                        ?>
                    </div>
                    <ol class="carousel-indicators">
                        <?php
                        $i = 1; 
                        $z = 0; 
                        foreach ($list as $item):
                            $slide_img  = (isset($item['slide_img']['url'])) ? $item['slide_img']['url'] : 'https://via.placeholder.com/952x1033.jpg';
                            ?>
                                <li data-target="#imgslider_<?php echo get_the_ID(); ?>" data-slide-to="<?php echo $z++; ?>" class="<?php if($i == 1){ echo 'active'; } ?>"></li>
                            <?php
                            $i++;
                        endforeach;
                        ?>
                    </ol>
                </div>
            <?php if($img_stetch == 1){ echo '</div">'; } ?>   
        <?php endif;
        
        
    }
    
    protected function _content_template() {
        
    }
}