<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Portfolio_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-work';
    }
    
    public function get_title() {
        return esc_html__( 'Portfolio', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-post-list';
    }

    public function get_categories() {
        return [ 'industing-elements' ];
    }
    
    protected function _register_controls() {
        $this->start_controls_section(
            'section_tab', [
                'label' =>esc_html__( 'Portfolio', 'themewar' ),
            ]
        );
        $this->add_control(
                'folio_style',
                [
                        'label'     => esc_html__( 'Portfolio Style', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 0,
                        'options'   => [
                                0       => esc_html__( 'Select Style', 'themewar' ),
                                1       => esc_html__( 'Portfolio Mixing', 'themewar' ),
                                2       => esc_html__( 'Portfolio Slide', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'is_filter',
                [
                        'label' => esc_html__( 'Is Filter?', 'industing' ),
                        'type' => Controls_Manager::SWITCHER,
                        'label_on' => esc_html__( 'Show', 'industing' ),
                        'label_off' => esc_html__( 'Hide', 'industing' ),
                        'condition' => ['folio_style' => '1'],
                        'return_value' => 'yes',
                        'default' => '',
                ]
        );
        $this->add_control(
                'portfolio_item',
                [
                        'label'     => esc_html__( 'Number Of Item', 'themewar' ),
                        'type'      => Controls_Manager::NUMBER,
                        'min'       => 3,
                        'max'       => 100,
                        'step'      => 1,
                        'default'   => 6,
                ]
        );
        $this->add_control(
                'order_by',
                [
                        'label' => esc_html__( 'Order By', 'themewar' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'date',
                        'options' => [
                                'date'       => esc_html__( 'Date', 'themewar' ),
                                'title'      => esc_html__( 'Title', 'themewar' ),
                                'rand'       => esc_html__( 'Random', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'order',
                [
                        'label' => esc_html__( 'Order', 'themewar' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'desc',
                        'options' => [
                                'asc'       => esc_html__( 'Ascending', 'themewar' ),
                                'desc'      => esc_html__( 'Descending', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'arrow_align',
                [
                        'label'     => esc_html__( 'Navigation Alignment', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 1,
                        'condition' => ['folio_style' => '2'],
                        'options'   => [
                                1       => esc_html__( 'Default', 'themewar' ),
                                2       => esc_html__( 'Left Right', 'themewar' ),
                                3       => esc_html__( 'Center Bottom', 'themewar' ),
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_2', [
                'label'     =>esc_html__( 'Arrow Style', 'themewar' ),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => ['folio_style' => '2'],
            ]
        );
        $this->add_control(
            'arrow_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'selectors'     => [
                            '{{WRAPPER}} .worksSlider .owl-nav' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
    }
    
    protected function render() {
        $settings           = $this->get_settings();
        $folio_style        = (isset($settings['folio_style']) && $settings['folio_style'] > 0) ? $settings['folio_style'] : 0;
        $is_filter          = (isset($settings['is_filter'])) ? $settings['is_filter'] : '';
        $portfolio_item     = (isset($settings['portfolio_item']) && $settings['portfolio_item'] > 0) ? $settings['portfolio_item'] : 6;
        $order_by           = (isset($settings['order_by']) && $settings['order_by'] != '') ? $settings['order_by'] : 'date';
        $order              = (isset($settings['order']) && $settings['order'] != '') ? $settings['order'] : 'desc';
        $arrow_align        = (isset($settings['arrow_align']) && $settings['arrow_align'] > 0) ? $settings['arrow_align'] : 1;
        
        switch ($folio_style){
            case 1:
                require_once dirname(__FILE__).'/style/portfolio/style1.php';
                break;
            case 2:
                require_once dirname(__FILE__).'/style/portfolio/style2.php';
                break;
            default:
                ?>
                    <div class="alert alert-warning" role="alert">
                        <?php echo esc_html__('Please select Portfolio style first.', 'themewar'); ?>
                    </div>
                <?php
                break;
        }
    }
    
    protected function _content_template() {
        
    }
}