<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Service_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-service';
    }
    
    public function get_title() {
        return esc_html__( 'Services Post', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-post-list';
    }

    public function get_categories() {
        return [ 'industing-elements' ];
    }
    
    protected function _register_controls() {
        $this->start_controls_section(
            'section_tab', [
                'label' =>esc_html__( 'Services Post', 'themewar' ),
            ]
        );
        $this->add_control(
                'service_style',
                [
                        'label'     => esc_html__( 'Services Style', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 0,
                        'options'   => [
                                0                  => esc_html__( 'Select Style', 'themewar' ),
                                1                  => esc_html__( 'Icon Style', 'themewar' ),
                                2                  => esc_html__( 'Image Style', 'themewar' )
                        ],
                ]
        );
        $this->add_control(
                'service_mode',
                [
                        'label'     => esc_html__( 'View Mode', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 1,
                        'options'   => [
                                1       => esc_html__( 'Static', 'themewar' ),
                                2       => esc_html__( 'Slide', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'service_item',
                [
                        'label'     => esc_html__( 'Number Of Item', 'themewar' ),
                        'type'      => Controls_Manager::NUMBER,
                        'min'       => 3,
                        'max'       => 200,
                        'step'      => 1,
                        'default'   => 3,
                ]
        );
        $this->add_control(
                'order_by',
                [
                        'label'     => esc_html__( 'Order By', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 'date',
                        'options'   => [
                                'date'                  => esc_html__( 'Date', 'themewar' ),
                                'title'                 => esc_html__( 'Title', 'themewar' ),
                                'rand'                  => esc_html__( 'Random', 'themewar' ),
                                'comment_count'         => esc_html__( 'Comment', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'order',
                [
                        'label'     => esc_html__( 'Order', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 'desc',
                        'options'   => [
                                'asc'        => esc_html__( 'Ascending', 'themewar' ),
                                'desc'       => esc_html__( 'Descending', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'service_detail',
                [
                        'label'         => esc_html__( 'Service Details Label', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'label_block'   => TRUE,
                        'placeholder'   => esc_html__('', 'themewar'),
                        'condition'     => ['service_style' => '2']
                ]
        );
        $this->add_control(
                'arrow_align',
                [
                        'label'     => esc_html__( 'Navigation Alignment', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 1,
                        'condition' => ['service_mode' => '2'],
                        'options'   => [
                                1       => esc_html__( 'Default', 'themewar' ),
                                2       => esc_html__( 'Left Right', 'themewar' ),
                                3       => esc_html__( 'Center Bottom', 'themewar' ),
                        ],
                ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_tab_2', [
                'label'     =>esc_html__( 'Navigation Style', 'themewar' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'arrow_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'selectors'     => [
                            '{{WRAPPER}} .serviceSlider .owl-nav' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
    }
    
    protected function render() {
        $settings       = $this->get_settings();
        $service_mode   = (isset($settings['service_mode']) && $settings['service_mode'] > 0) ? $settings['service_mode'] : 0;
        $arrow_align    = (isset($settings['arrow_align']) && $settings['arrow_align'] > 0) ? $settings['arrow_align'] : 1;
        $service_style  = (isset($settings['service_style']) && $settings['service_style'] > 0) ? $settings['service_style'] : 0;
        $service_item   = (isset($settings['service_item']) && $settings['service_item'] > 0) ? $settings['service_item'] : 3;
        $order_by       = (isset($settings['order_by']) && $settings['order_by'] != '') ? $settings['order_by'] : 'date';
        $order          = (isset($settings['order']) && $settings['order'] != '') ? $settings['order'] : 'desc';
        
        $service_detail = (isset($settings['service_detail']) && $settings['service_detail'] != '') ? $settings['service_detail'] : '';
        
        switch ($service_style){
            case 1:
                require dirname(__FILE__).'/style/services/style1.php';
                break;
            case 2:
                require dirname(__FILE__).'/style/services/style2.php';
                break;
            default:
                ?>
                    <div class="alert alert-warning" role="alert">
                        <?php echo esc_html__('Please select Service style first.', 'themewar'); ?>
                    </div>
                <?php
                break;
        }
    }
    
    protected function _content_template() {
        
    }
}