<?php

/**
 * The template for displaying 404 pages (not found)
 */
get_header();
$fof_image = get_theme_mod('fof_image', INDUSTING_ASSETS_IMAGES_URL.'/404.png');
$fof_heading = get_theme_mod('fof_heading', esc_html__('404', 'industing'));
$fof_title = get_theme_mod('fof_title', esc_html__('Sorry, We could not find that page.', 'industing'));
$fof_hbtn_label = get_theme_mod('fof_hbtn_label', esc_html__('Go Home', 'industing'));
?>
<section class="fof_section">
    <div class="valignMiddle">
        <div class="container">
            <div class="row">
                <div class="col-xl-7 col-md-7">
                    <?php if($fof_image != ''): ?>
                    <div class="fof_img tw-stretch-element-inside-column text-right">
                        <img src="<?php echo esc_url($fof_image); ?>" alt="<?php echo get_bloginfo('name'); ?>">
                    </div>
                    <?php endif; ?>
                </div>
                <div class="col-xl-5 col-md-5">
                    <div class="fof_contents">
                        <?php if($fof_heading != ''): ?>
                            <h1><?php echo esc_html($fof_heading); ?></h1>
                        <?php endif; ?>
                        <?php if($fof_title != ''): ?>
                            <h2><?php echo esc_html($fof_title); ?></h2>
                        <?php endif; ?>
                        <?php if($fof_hbtn_label != ''): ?>
                            <a href="<?php echo esc_url(home_url('/')) ?>" class="ind_btn id_gray"><span><?php echo esc_html($fof_hbtn_label) ?></span></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php
get_footer();