<?php
$bloks = array(
    'post_type'     => 'blocks',
    'post_status'   => 'publish',
    'posts_per_page'  => -1,
    'orderby'        => 'title',
    'order'          => 'ASC'
);
$all_bloks = array(
    'none' => esc_html__('None', 'industing')
);
$blok = new WP_Query($bloks);
if($blok->have_posts()):
    while($blok->have_posts()):
    $blok->the_post();
    $all_bloks[get_the_ID()] = get_the_title();
    endwhile;
endif;
wp_reset_postdata();
    
$fields[] = array(
        'type'        => 'image',
	'settings'    => 'folio_banner_bg',
	'label'       => esc_html__( 'Upload Banner BG', 'industing' ),
	'section'     => 'folio_settings',
	'default'     => '',
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'folio_banner_overlay',
	'label'       => esc_html__( 'Banner Overlay Color', 'industing' ),
	'section'     => 'folio_settings',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.page_banner:after',
                        'property' => 'background'
		],
	],
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'folio_is_breadcrumb',
	'label'       => esc_html__( 'Is Breadcrumb', 'industing' ),
	'section'     => 'folio_settings',
	'default'     => '1',
	'choices'     => [
		'on'  => esc_html__( 'Show', 'industing' ),
		'off' => esc_html__( 'Hide', 'industing' ),
	],
);
$fields[] = array(
        'type'          => 'text',
	'settings'      => 'folio_banner_title',
	'label'         => esc_html__( 'Banner Title', 'industing' ),
	'section'       => 'folio_settings',
	'default'       => esc_html__('Portfolios', 'industing'),
        'transport'     => 'postMessage',
        'js_vars'       => array(
            array(
                'element'  => '.page_banner h2',
                'function' => 'html'
            ),
        ),
);
$fields[] = array(
        'type'          => 'text',
	'settings'      => 'folio_bread_title',
	'label'         => esc_html__( 'Breadcrumb Title', 'industing' ),
	'section'       => 'folio_settings',
	'default'       => esc_html__('Portfolio', 'industing'),
        'transport'     => 'postMessage',
        'js_vars'       => array(
            array(
                'element'  => '.breadcrumbs span',
                'function' => 'html'
            ),
        ),
);

$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'folio_custom',
	'label'       => FALSE,
	'section'     => 'folio_settings',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);

$fields[] = array(
        'type'        => 'select',
        'settings'    => 'folio_filter_style',
        'label'       => esc_html__( 'Filter Nav', 'industing' ),
        'section'     => 'folio_settings',
        'default'     => '1',
        'choices'     => array(
                '1'     => esc_html__( 'Style 1', 'industing' ),
                '2'     => esc_html__( 'Style 2', 'industing' ),
                '3'     => esc_html__( 'No Filter', 'industing' ),
        ),
);
$fields[] = array(
        'type'        => 'select',
        'settings'    => 'folio_width',
        'label'       => esc_html__( 'Container Width', 'industing' ),
        'section'     => 'folio_settings',
        'default'     => '1',
        'choices'     => array(
                '1'     => esc_html__( 'Default Container', 'industing' ),
                '2'     => esc_html__( 'Semi Full Width', 'industing' ),
                '3'     => esc_html__( 'Full Width', 'industing' ),
        ),
);
$fields[] = array(
        'type'        => 'select',
        'settings'    => 'folio_mode',
        'label'       => esc_html__( 'Folio Mode', 'industing' ),
        'section'     => 'folio_settings',
        'default'     => '1',
        'choices'     => array(
                '1'     => esc_html__( 'Normal', 'industing' ),
                '2'     => esc_html__( 'Masonry', 'industing' )
        ),
);
$fields[] = array(
        'type'        => 'select',
        'settings'    => 'folio_style',
        'label'       => esc_html__( 'Folio Style', 'industing' ),
        'section'     => 'folio_settings',
        'default'     => '1',
        'choices'     => array(
                '1'     => esc_html__( 'Style 1', 'industing' ),
                '2'     => esc_html__( 'Style 2', 'industing' ),
                '3'     => esc_html__( 'Style 3', 'industing' ),
                '4'     => esc_html__( 'Style 4', 'industing' ),
        ),
);

/* If Style 3 or 4 */
$fields[] = array(
        'type'        => 'slider',
	'settings'    => 'folio_string_limit',
	'label'       => esc_html__( 'String Limit', 'industing' ),
	'section'     => 'folio_settings',
	'default'     => 63,
	'choices'     => [
		'min'  => 0,
		'max'  => 500,
		'step' => 1,
	],
        'required'      => array( 
            array( 
                'setting'   => 'folio_style',
                'operator'  => 'contains',
                'value'     => array('3', '4') 
            ),
        ),
);
$fields[] = array(
        'type'          => 'text',
	'settings'      => 'folio_btn_label',
	'label'         => esc_html__( 'Button Label', 'industing' ),
	'section'       => 'folio_settings',
	'default'       => esc_html__('Know More', 'industing'),
        'required'      => array( 
            array( 
                'setting'   => 'folio_style',
                'operator'  => '==',
                'value'     => '4'
            ),
        ),
);
/* If Style 3 or 4 */

$fields[] = array(
        'type'        => 'select',
        'settings'    => 'folio_column',
        'label'       => esc_html__( 'Folio Column', 'industing' ),
        'section'     => 'folio_settings',
        'default'     => '1',
        'choices'     => array(
                '1'     => esc_html__( '3 Column', 'industing' ),
                '2'     => esc_html__( '4 Column', 'industing' ),
        ),
);
$fields[] = array(
        'type'        => 'select',
        'settings'    => 'folio_gaping',
        'label'       => esc_html__( 'Column Gaping', 'industing' ),
        'section'     => 'folio_settings',
        'default'     => '1',
        'choices'     => array(
                '1'     => esc_html__( 'Default Gap 30px', 'industing' ),
                '2'     => esc_html__( 'No Gap', 'industing' ),
        )
);

$fields[] = array(
        'type'        => 'slider',
	'settings'    => 'num_of_item',
	'label'       => esc_html__( 'Number Of Items', 'industing' ),
	'section'     => 'folio_settings',
	'default'     => 9,
	'choices'     => [
		'min'  => 0,
		'max'  => 100,
		'step' => 1,
	],
);
$fields[] = array(
        'type'        => 'select',
        'settings'    => 'folio_pagi_align',
        'label'       => esc_html__( 'Pagination Alignment', 'industing' ),
        'section'     => 'folio_settings',
        'default'     => 'center',
        'choices'     => array(
                'left'      => esc_html__('Left','industing'),
                'center'      => esc_html__('Center','industing'),
                'right'      => esc_html__('Right','industing'),
        ),
);
$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'folio_custom_2',
	'label'       => FALSE,
	'section'     => 'folio_settings',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);
$fields[] = array(
    'type'              => 'repeater',
	'label'         => esc_html__( 'Add Blocks', 'industing' ),
	'section'       => 'folio_settings',
	'settings'      => 'folio_bloks',
	'row_label' => [
		'type'  => 'text',
		'value' => esc_html__('Block', 'industing' ),
	],
	'button_label' => esc_html__('Add New Block', 'industing' ),
	'default'      => [],
	'fields' => [
		'block_ids' => [
			'type'        => 'select',
                        'label'       => esc_html__( 'Block', 'industing' ),
                        'default'     => 'none',
                        'choices'     => $all_bloks
		]
	]
);
