<?php
$bloks = array(
        'post_type'     => 'blocks',
        'post_status'   => 'publish',
        'posts_per_page'  => -1,
        'orderby'        => 'title',
        'order'          => 'ASC'
    );
    $all_bloks = array(
        'none' => esc_html__('None', 'industing')
    );
    $blok = new WP_Query($bloks);
    if($blok->have_posts()):
        while($blok->have_posts()):
        $blok->the_post();
        $all_bloks[get_the_ID()] = get_the_title();
        endwhile;
    endif;
    wp_reset_postdata();
    
$fields[] = array(
        'type'        => 'image',
	'settings'    => 'folio_single_banner_bg',
	'label'       => esc_html__( 'Upload Banner BG', 'industing' ),
	'section'     => 'folio_single_settings',
	'default'     => '',
);

$fields[]= array(
        'type'        => 'color',
	'settings'    => 'f_banner_overlay',
	'label'       => esc_html__( 'Banner Overlay Color', 'industing' ),
	'section'     => 'folio_single_settings',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.page_banner:after',
                        'property' => 'background'
		],
	],
);

$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'folio_single_is_breadcrumb',
	'label'       => esc_html__( 'Is Breadcrumb', 'industing' ),
	'section'     => 'folio_single_settings',
	'default'     => '1',
	'choices'     => [
		'on'  => esc_html__( 'Show', 'industing' ),
		'off' => esc_html__( 'Hide', 'industing' ),
	],
);

$fields[] = array(
        'type'          => 'text',
	'settings'      => 'folio_single_banner_title',
	'label'         => esc_html__( 'Banner Title', 'industing' ),
	'section'       => 'folio_single_settings',
	'default'       => esc_html__('Portfolio Detail', 'industing'),
        'transport'     => 'postMessage',
        'js_vars'       => array(
            array(
                'element'  => '.page_banner h2',
                'function' => 'html'
            ),
        ),
);

$fields[] = array(
        'type'          => 'text',
	'settings'      => 'folio_single_bread_title',
	'label'         => esc_html__( 'Breadcrumb Title', 'industing' ),
	'section'       => 'folio_single_settings',
	'default'       => esc_html__('Portfolio', 'industing'),
        'transport'     => 'postMessage',
        'js_vars'       => array(
            array(
                'element'  => '.breadcrumbs span',
                'function' => 'html'
            ),
        ),
);

$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'folio_single_custom',
	'label'       => FALSE,
	'section'     => 'folio_single_settings',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);


$fields[] = array(
        'type'        => 'select',
        'settings'    => 'folio_single_style',
        'label'       => esc_html__( 'Style', 'industing' ),
        'section'     => 'folio_single_settings',
        'default'     => '3',
        'choices'     => array(
                '1'      => esc_html__('Left Sidebar','industing'),
                '2'      => esc_html__('Full Width','industing'),
                '3'      => esc_html__('Right Sidebar','industing'),
        ),
);

$fields[] = array(
        'type'        => 'select',
        'settings'    => 'folio_single_gallery',
        'label'       => esc_html__( 'Gallery Style', 'industing' ),
        'section'     => 'folio_single_settings',
        'default'     => '2',
        'choices'     => array(
                '1'      => esc_html__('Slider View','industing'),
                '2'      => esc_html__('Masonry View','industing'),
                '3'      => esc_html__('Static View','industing'),
        ),
);

$fields[]= array(
        'type'        => 'switch',
        'settings'    => 'folio_single_pagination',
        'label'       => esc_html__( 'Is Pagination?', 'industing' ),
        'section'     => 'folio_single_settings',
        'default'     => '1',
        'choices'     => array(
            'on'  => esc_attr__( 'Enable', 'industing' ),
            'off' => esc_attr__( 'Disable', 'industing' ),
        ),
);

$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'folio_single_custom2',
	'label'       => FALSE,
	'section'     => 'folio_single_settings',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);

$fields[]= array(
        'type'        => 'switch',
        'settings'    => 'folio_single_related',
        'label'       => esc_html__( 'Is Related Items?', 'industing' ),
        'section'     => 'folio_single_settings',
        'default'     => '1',
        'choices'     => array(
            'on'  => esc_attr__( 'Enable', 'industing' ),
            'off' => esc_attr__( 'Disable', 'industing' ),
        ),
);

$fields[]= array(
        'type'        => 'color',
	'settings'    => 'related_section_bg',
	'label'       => esc_html__( 'Related Section BG Color', 'industing' ),
	'section'     => 'folio_single_settings',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.relatedworfsection',
                        'property' => 'background'
		],
            ],
            'required'      => array( 
                array( 
                    'setting'   => 'folio_single_related',
                    'operator'  => '==',
                    'value'     => '1'
                )
            ),
);

$fields[] = array(
        'type'          => 'text',
	'settings'      => 'folio_single_rt',
	'label'         => esc_html__( 'Related Btn Title', 'industing' ),
	'section'       => 'folio_single_settings',
	'default'       => '',
        'transport'     => 'postMessage',
        'js_vars'       => array(
            array(
                'element'  => '.rel_btns span',
                'function' => 'html'
            ),
        ),
        'required'      => array( 
            array( 
                'setting'   => 'folio_single_related',
                'operator'  => '==',
                'value'     => '1'
            )
        ),
);

$fields[]= array(
        'type'        => 'switch',
        'settings'    => 'folio_arrow_related',
        'label'       => esc_html__( 'Is Related Slider Arrow?', 'industing' ),
        'section'     => 'folio_single_settings',
        'default'     => '1',
        'choices'     => array(
            'on'  => esc_attr__( 'Enable', 'industing' ),
            'off' => esc_attr__( 'Disable', 'industing' ),
        ),
        'required'      => array( 
            array( 
                'setting'   => 'folio_single_related',
                'operator'  => '==',
                'value'     => '1'
            )
        ),
);

$fields[] = array(
        'type'        => 'slider',
	'settings'    => 'folio_single_noi',
	'label'       => esc_html__( 'Number Of Items', 'industing' ),
	'section'     => 'folio_single_settings',
	'default'     => 5,
	'choices'     => [
		'min'  => 0,
		'max'  => 100,
		'step' => 1,
	],
        'required'      => array( 
            array( 
                'setting'   => 'folio_single_related',
                'operator'  => '==',
                'value'     => '1'
            )
        ),
);
$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'sin_folio_custom',
	'label'       => FALSE,
	'section'     => 'folio_single_settings',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);
$fields[] = array(
    'type'              => 'repeater',
	'label'         => esc_html__( 'Add Blocks', 'industing' ),
	'section'       => 'folio_single_settings',
	'settings'      => 'sing_folio_bloks',
	'row_label' => [
		'type'  => 'text',
		'value' => esc_html__('Block', 'industing' ),
	],
	'button_label' => esc_html__('Add New Block', 'industing' ),
	'default'      => [],
	'fields' => [
		'block_ids' => [
			'type'        => 'select',
                        'label'       => esc_html__( 'Block', 'industing' ),
                        'default'     => 'none',
                        'choices'     => $all_bloks
		]
	]
);