<?php
$fields[] = array(
        'type'        => 'select',
        'settings'    => 'header_style',
        'label'       => esc_html__( 'Header Style', 'industing' ),
        'section'     => 'header_settings',
        'default'     => '1',
        'choices'     => array(
                '1'     => esc_html__( 'Default Style', 'industing' ),
                '2'     => esc_html__( 'Style 2', 'industing' ),
        ),
);
$fields[] = array(
	'type'        => 'switch',
	'settings'    => 'is_sticky',
	'label'       => esc_html__( 'Is Sticky?', 'industing' ),
	'section'     => 'header_settings',
	'default'     => '2',
	'choices'     => [
		'on'  => esc_html__( 'Sticky', 'industing' ),
		'off' => esc_html__( 'Scroll', 'industing' ),
	],
);
$fields[] = array(
	'type'        => 'image',
	'settings'    => 'industing_logo',
	'label'       => esc_html__( 'Logo', 'industing' ),
	'description' => esc_html__( 'Upload your site logo. Logo size should be 180x51px.', 'industing' ),
	'section'     => 'header_settings',
	'default'     => '',
);
$fields[] = array(
	'type'        => 'dimension',
	'settings'    => 'logo_wh',
	'label'       => esc_html__( 'Logo Height', 'industing' ),
	'section'     => 'header_settings',
	'default'     => '',
        'transport'     => 'auto',
        'output'      => [
		[
			'element' => '.logo img',
                        'property' => 'height',
		],
	],
);
$fields[] = array(
	'type'        => 'dimensions',
	'settings'    => 'nr_logo_padding',
	'label'       => esc_html__( 'Logo Padding', 'industing' ),
	'section'     => 'header_settings',
	'default'     => [
		'padding-top'    => '',
		'padding-bottom' => '',
	],
        'transport'     => 'auto',
        'output'        => [
                [
                        'element'  => '.logo'
                ],
        ],
);
$fields[] = array(
	'type'        => 'text',
	'settings'    => 'head_quote_label',
	'label'       => esc_html__( 'Quote Btn Label', 'industing' ),
	'section'     => 'header_settings',
	'default'     => esc_html__('GET A QUOTE', 'industing'),
        'required'      => array( 
            array( 
                'setting'   => 'header_style',
                'operator'  => '==',
                'value'     => '2' 
            )
        ),
);
$fields[] = array(
	'type'        => 'text',
	'settings'    => 'head_quote_url',
	'label'       => esc_html__( 'Quote Btn URL', 'industing' ),
	'section'     => 'header_settings',
	'default'     => '',
        'required'      => array( 
            array( 
                'setting'   => 'header_style',
                'operator'  => '==',
                'value'     => '2' 
            )
        ),
);
$fields[] = array(
    'type'        => 'repeater',
	'label'       => esc_html__( 'Header Info', 'industing' ),
	'section'     => 'header_settings',
	'settings'     => 'header_infos',
	'row_label' => [
		'type'  => 'text',
		'value' => esc_html__('Header Infos', 'industing' ),
	],
	'button_label' => esc_html__('Add New Info', 'industing' ),
	'default'      => [],
	'fields' => [
		'inf_type' => [
			'type'        => 'select',
                        'label'       => esc_html__( 'Header Style', 'industing' ),
                        'default'     => '1',
                        'choices'     => array(
                                '1'     => esc_html__( 'Email', 'industing' ),
                                '2'     => esc_html__( 'Phone', 'industing' )
                        ),
		],
		'inf_label' => [
			'type'        => 'text',
                        'label'       => esc_html__( 'Info Label', 'industing' ),
                        'default'     => '',
		],
		'inf_val'  => [
			'type'        => 'text',
			'label'       => esc_html__( 'Info', 'industing' ),
			'default'     => '',
		],
	],
);
$fields[] = array(
	'type'        => 'switch',
	'settings'    => 'is_search',
	'label'       => esc_html__( 'Is Search on Header?', 'industing' ),
	'description' => esc_html__( 'Do you want to show search form on Header.', 'industing' ),
	'section'     => 'header_settings',
	'default'     => '1',
	'choices'     => [
		'on'  => esc_html__( 'Hide', 'industing' ),
		'off' => esc_html__( 'Show', 'industing' ),
	]
);
$fields[] = array(
	'type'        => 'switch',
	'settings'    => 'is_popup',
	'label'       => esc_html__( 'Is Popup', 'industing' ),
	'section'     => 'header_settings',
	'default'     => '2',
	'choices'     => [
		'on'  => esc_html__( 'Hide', 'industing' ),
		'off' => esc_html__( 'Show', 'industing' ),
	],
);
$fields[] = array(
	'type'        => 'image',
	'settings'    => 'popup_logo',
	'label'       => esc_html__( 'Popup Logo', 'industing' ),
	'description' => esc_html__( 'Upload a logo for popup. Logo dimenssion should be 165x51px.', 'industing' ),
	'section'     => 'header_settings',
	'default'     => '',
        'required'      => array( 
            array( 
                'setting'   => 'is_popup',
                'operator'  => '==',
                'value'     => '1' 
            )
        ),
);
$fields[] = array(
	'type'        => 'switch',
	'settings'    => 'is_social_pop',
	'label'       => esc_html__( 'Is Social on Popup?', 'industing' ),
	'description' => esc_html__( 'Do you want to show social links in pupup menu? Turn it to Show and setup social links under "Social Settings".', 'industing' ),
	'section'     => 'header_settings',
	'default'     => '2',
	'choices'     => [
		'on'  => esc_html__( 'Hide', 'industing' ),
		'off' => esc_html__( 'Show', 'industing' ),
	],
        'required'      => array( 
            array( 
                'setting'   => 'is_popup',
                'operator'  => '==',
                'value'     => '1' 
            )
        ),
);
$fields[] = array(
    'type'        => 'repeater',
	'label'       => esc_html__( 'PopUp Info', 'industing' ),
	'section'     => 'header_settings',
	'settings'     => 'popup_infos',
	'row_label' => [
		'type'  => 'text',
		'value' => esc_html__('PopUp Infos', 'industing' ),
	],
	'button_label' => esc_html__('Add New Info', 'industing' ),
	'default'      => [],
	'fields' => [
		'inf_label' => [
			'type'        => 'text',
                        'label'       => esc_html__( 'Info Label', 'industing' ),
                        'default'     => '',
		],
		'inf_val'  => [
			'type'        => 'textarea',
			'label'       => esc_html__( 'Info', 'industing' ),
			'default'     => '',
		],
	],
        'required'      => array( 
            array( 
                'setting'   => 'is_popup',
                'operator'  => '==',
                'value'     => '1' 
            )
        ),
);
$fields[] = array(
	'type'        => 'switch',
	'settings'    => 'is_cart',
	'label'       => esc_html__( 'Is Cart?', 'industing' ),
	'description' => esc_html__( 'Do you want to show cart btn on header?', 'industing' ),
	'section'     => 'header_settings',
	'default'     => '2',
	'choices'     => [
		'on'  => esc_html__( 'Hide', 'industing' ),
		'off' => esc_html__( 'Show', 'industing' ),
	]
);
$fields[] = array(
	'type'        => 'switch',
	'settings'    => 'is_social_header',
	'label'       => esc_html__( 'Is Social on Header?', 'industing' ),
	'description' => esc_html__( 'Do you want to show social links in header? Turn it to Show and setup social links under "Social Settings".', 'industing' ),
	'section'     => 'header_settings',
	'default'     => '2',
	'choices'     => [
		'on'  => esc_html__( 'Hide', 'industing' ),
		'off' => esc_html__( 'Show', 'industing' ),
	]
);