<?php
/* 
 * ThemeWar Hooks Class
 */

class Industing_Hooks_Class
{

    public static $_instance;

    public function __construct()
    {
        $this->industing_init();
    }

    /* * ---------------------------------------------------------------
    * Init all hooks and others
    * -------------------------------------------------------------* */

    public function industing_init()
    {
        add_action('after_setup_theme', array($this, 'industing_theme_setup'));
        add_action('widgets_init', array($this, 'industing_widgets_init'));
        add_action('wp_enqueue_scripts', array($this, 'industing_enqueue_style'));
        add_action('wp_enqueue_scripts', array($this, 'industing_enqueue_script'));
        add_action('tgmpa_register', array($this, 'industing_plugin_activation_notive'));
        add_action('admin_menu', array($this,'industing_remove_theme_settings'),999 );
        add_action('wp_ajax_nopriv_post_like', array($this, 'industing_ajax_post_like'));
        add_action('wp_ajax_post_like', array($this, 'industing_ajax_post_like'));
        
        add_filter('fw:option_type:icon-v2:packs', array($this, 'industing_icon_pack'));
        add_filter( 'comment_form_fields', array($this, 'industing_rearrange_comment_form') );
        
        add_action( 'admin_init', array($this, 'industing_hide_front_page_editor') );
        
        add_filter( 'loop_shop_per_page', array($this, 'industing_loop_shop_per_page'), 20 );
        add_filter( 'woocommerce_checkout_fields' , array($this, 'industing_custom_wc_checkout_fields') );
        add_filter('woocommerce_add_to_cart_fragments', array($this, 'industing_cart_button_item_count'));
        
        add_filter( 'gutenberg_use_widgets_block_editor', '__return_false' );
        add_filter( 'use_widgets_block_editor', '__return_false' );
    }
    
    
    public function industing_loop_shop_per_page($cols){
        $cols = get_theme_mod('shop_pro_per_page', 8);
        return $cols;
    }
    
    
    public function industing_icon_pack($default_packs){
        return array(
                'themewar_pack' => array(
                        'name'                  => 'themewar_pack',
                        'title'                 => 'Themewar Icons',
                        'css_class_prefix'      => '',
                        'css_file'              => INDUSTING_ASSETS_CSS_DIR.'/themewar-icons.css',
                        'css_file_uri'          => INDUSTING_ASSETS_CSS_URL.'/themewar-icons.css'
                )
        );
    }

    /* * -----------------------------------------------------------
    * Theme Setup
    * -------------------------------------------------------------* */

    public function industing_theme_setup(){
        load_theme_textdomain('industing', get_template_directory() . '/languages');
        $GLOBALS['content_width'] = 1170;

        add_theme_support('automatic-feed-links');
        add_theme_support('post-thumbnails');
        set_post_thumbnail_size(755, 420, true);
        add_image_size('industing-sq-xs', 100, 100, true);
        add_image_size('industing-folio-1', 370, 290, true);
        add_image_size('industing-folio-2', 750, 532, true);
        add_image_size('industing-folio-3', 421, 281, true);
        add_image_size('industing-folio-4', 1170, 532, true);
        add_image_size('industing-blog-1', 652, 480, true);
        add_image_size('industing-blog-2', 555, 480, true);
        add_image_size('industing-blog-3', 360, 280, true);
        add_image_size('industing-blog-4', 750, 400, true);
        add_image_size('industing-team-1', 370, 421, true);
        add_image_size('industing-team-2', 342, 342, true);
        add_image_size('industing-team-3', 570, 570, true);
        add_image_size('industing-service-2', 333, 220, true);
        
        add_image_size('industing-blog-grid', 370, 264, true);
        add_image_size('industing-folio-s2-1', 463, 563, true);
        add_image_size('industing-folio-s2-2', 360, 250, true);
        
        add_image_size('industing-pro-1', 390, 312, true);
        add_image_size('industing-pro-2', 652, 738, true);
        add_image_size('industing-pro-3', 100, 70, true);
        
        add_image_size('industing-wid', 100, 90, true);

        add_theme_support('title-tag');

        register_nav_menu('primary-menu', esc_html__('Primary Menu', 'industing'));
        register_nav_menu('popup-menu', esc_html__('Popup Menu', 'industing'));

        add_theme_support('html5', array('search-form', 'comment-form', 'comment-list',));
        add_theme_support( 'post-formats', array('audio', 'video', 'gallery') );

        add_theme_support('woocommerce');
    }

    /* * ---------------------------------------------------------------
    * Widget Init
    * -------------------------------------------------------------* */

    public function industing_widgets_init(){

        industing_register_sidebars(
            array(
                'sidebar-1' => array('name' => esc_html__('Blog Sidebar', 'industing'), 'description' => esc_html__('Blog sidebar, Only for blog pages.', 'industing')),

                'sidebar-2' => array('name' => esc_html__('Page Sidebar', 'industing'), 'description' => esc_html__('Page sidebar, Only for pages.', 'industing')),

                'sidebar-3' => array('name' => esc_html__('Service Sidebar', 'industing'), 'description' => esc_html__('Service Sidebar, Only For Service Related Pages.', 'industing')),
                
                'sidebar-4' => array('name' => esc_html__('Shop Sidebar', 'industing'), 'description' => esc_html__('Shop Sidebar, Only For Shop Related Pages.', 'industing')),

                'footer-1' => array('name' => esc_html__('Footer 1', 'industing'), 'description' => esc_html__('Footer sidebar 1', 'industing')),

                'footer-2' => array('name' => esc_html__('Footer 2', 'industing'), 'description' => esc_html__('Footer sidebar 2', 'industing')),

                'footer-3' => array('name' => esc_html__('Footer 3', 'industing'), 'description' => esc_html__('Footer sidebar 3', 'industing')),
                
                'footer-4' => array('name' => esc_html__('Footer 4', 'industing'), 'description' => esc_html__('Footer sidebar 4', 'industing')),
            ),

            array(
                'before_widget' => '<aside id="%1$s" class="widget %2$s">',
                'after_widget' => "</aside>",
                'before_title' => '<h3 class="widget_title">',
                'after_title' => '</h3>',
            ));

    }

    /* * ---------------------------------------------------------------
    * CSS Enqueue
    * -------------------------------------------------------------* */
    public function industing_enqueue_style(){
        wp_enqueue_style('industing-google-fonts', industing_google_fonts_url());
        
        wp_enqueue_style('bootstrap', get_parent_theme_file_uri('/assets/css/bootstrap.css'));
        wp_enqueue_style('themewar-icons', get_parent_theme_file_uri('/assets/css/themewar-icons.css'));
        wp_enqueue_style('icofont', get_parent_theme_file_uri('/assets/css/icofont.css'));
        wp_enqueue_style('owl-carousel', get_parent_theme_file_uri('/assets/css/owl.carousel.min.css'));
        wp_enqueue_style('owl-theme-default', get_parent_theme_file_uri('/assets/css/owl.theme.default.min.css'));
        wp_enqueue_style('slick', get_parent_theme_file_uri('/assets/css/slick.css'));
        wp_enqueue_style('animate', get_parent_theme_file_uri('/assets/css/animate.css'));
        wp_enqueue_style('magnific-popup', get_parent_theme_file_uri('/assets/css/magnific-popup.css'));
        wp_enqueue_style('industing-preloader', get_parent_theme_file_uri('/assets/css/preloader.css'));
        wp_enqueue_style('industing-preset', get_parent_theme_file_uri('/assets/css/preset.css'));
        wp_enqueue_style('industing-theme', get_parent_theme_file_uri('/assets/css/theme.css'));
        wp_enqueue_style('industing-responsive', get_parent_theme_file_uri('/assets/css/responsive.css'));
    }

    /* * ------------------------------------------------------------
    * JS Enqueue
    * -------------------------------------------------------------* */
    public function industing_enqueue_script(){
        $map_api_code = get_theme_mod('map_api', '');
        $apic = ($map_api_code != '') ? '?key=' . $map_api_code : '';
        
        if (is_singular() && comments_open() && get_option('thread_comments')) {
            wp_enqueue_script('comment-reply');
        }
        
        wp_enqueue_script('bootstrap', get_parent_theme_file_uri('/assets/js/bootstrap.min.js'), array('jquery'), '', TRUE);
        wp_enqueue_script('jquery-appear', get_parent_theme_file_uri('/assets/js/jquery.appear.js'), array('bootstrap'), '', TRUE);
        wp_enqueue_script('owl-carousel', get_parent_theme_file_uri('/assets/js/owl.carousel.min.js'), array('jquery-appear'), '', TRUE);
        wp_enqueue_script('slick', get_parent_theme_file_uri('/assets/js/slick.min.js'), array('owl-carousel'), '', TRUE);
        wp_enqueue_script('jquery-shuffle', get_parent_theme_file_uri('/assets/js/jquery.shuffle.min.js'), array('slick'), '', TRUE);
        wp_enqueue_script('jquery-magnific-popup', get_parent_theme_file_uri('/assets/js/jquery.magnific-popup.min.js'), array('jquery-shuffle'), '', TRUE);
        wp_enqueue_script('modernizr-custom', get_parent_theme_file_uri('/assets/js/modernizr.custom.js'), array('jquery-magnific-popup'), '', TRUE);
        wp_enqueue_script('dlmenu', get_parent_theme_file_uri('/assets/js/dlmenu.js'), array('modernizr-custom'), '', TRUE);
        wp_enqueue_script('jquery-easing', get_parent_theme_file_uri('/assets/js/jquery.easing.1.3.js'), array('dlmenu'), '', TRUE);
        
        $handlers = 'jquery-easing';
        if($map_api_code != ''):
            wp_enqueue_script('maps-google', 'https://maps.google.com/maps/api/js'.$apic, array($handlers), '', TRUE);
            wp_enqueue_script('gmaps', get_parent_theme_file_uri('/assets/js/gmaps.js'), array('maps-google'), '', TRUE);
            $handlers = 'gmaps';
        endif;
        
        wp_enqueue_script('industing-theme', get_parent_theme_file_uri('/assets/js/theme.js'), array($handlers), '', TRUE);
        
    }
    
    public function industing_remove_theme_settings() {
        remove_submenu_page( 'themes.php', 'fw-settings' );
    }

    /* * ---------------------------------------------------------------
    * TGMPA Activator
    * -------------------------------------------------------------* */

    public function industing_plugin_activation_notive(){
        $plugins = array(
            array(
                'name'		 => esc_html__( 'Unyson', 'industing' ),
                'slug'		 => 'unyson',
                'required'	 => true,
            ),
            array(
                'name'		 => esc_html__( 'Elementor', 'industing' ),
                'slug'		 => 'elementor',
                'required'	 => true,
            ),
            array(
                'name'		 => esc_html__( 'Kirki', 'industing' ),
                'slug'		 => 'kirki',
                'required'	 => true,
            ),
            array(
                'name' => esc_html__('Industing Assistance', 'industing'),
                'slug'		 => 'industing-assistance',
                'required'	 => true,
                'source'	 => 'http://themewar.com/plugins/industing-assistance.zip' ,
                'version' => '',
                'force_activation' => false,
                'force_deactivation' => false,
                'external_url' => '',
            ),
            array(
                'name' => esc_html__('Revolution Slider', 'industing'),
                'slug'		 => 'revslider',
                'required'	 => true,
                'source'	 => 'http://themewar.com/plugins/revslider.zip' ,
                'version' => '',
                'force_activation' => false,
                'force_deactivation' => false,
                'external_url' => '',
            ),
            array(
                'name' => esc_html__('Contact Form 7', 'industing'),
                'slug' => 'contact-form-7',
                'required' => TRUE,
            ),
            array(
                'name' => esc_html__('Mailchimp For WP', 'industing'),
                'slug' => 'mailchimp-for-wp',
                'required' => false,
            ),
            array(
                'name' => esc_html__('WooCommerce', 'industing'),
                'slug' => 'woocommerce',
                'required' => false,
            ),


        );

        $config = array(
            'id' => 'industing',
            'default_path' => '',
            'menu' => 'tgmpa-install-plugins',
            'has_notices' => true,
            'dismissable' => true,
            'dismiss_msg' => '',
            'is_automatic' => false,
            'message' => '',
        );

        tgmpa($plugins, $config);
    }

    /* * ---------------------------------------------------------------
    * Post Like Submit
    * -------------------------------------------------------------* */

    public function industing_ajax_post_like(){
        $pid = $_POST['pid'];
        $like = get_post_meta($pid, '_industing_post_like', true);
        $like = ( empty($like) ) ? 0 : $like;
        $like++;
        update_post_meta($pid, '_industing_post_like', $like);
        echo wp_kses($like, industing_allowed_html());
        wp_die();
    }

    /* * ---------------------------------------------------------------
    * Create Instance
    * -------------------------------------------------------------* */

    public static function industing_instance()
    {

        if (!isset(self::$_instance)) {
            self::$_instance = new Industing_Hooks_Class();
        }
        return self::$_instance;

    }
    
    /* * ---------------------------------------------------------------
    * Re Arange Comment Form
    * -------------------------------------------------------------* */
    function industing_rearrange_comment_form( $fields ) {
	$comment_field              = $fields[ 'comment' ];
	unset( $fields[ 'comment' ] );
        
	$fields[ 'comment' ]        = $comment_field;
	return $fields;
    }
    
    /* * ---------------------------------------------------------------
    * Hide Front Page Editor
    * -------------------------------------------------------------* */
    function industing_hide_front_page_editor() {
        $post_id = (isset($_GET['post'])) ? $_GET['post'] : '' ;
        if( $post_id < 1 ) return;

        $template_file = get_post_meta($post_id, '_wp_page_template', true);

        if($template_file == 'page-templates/front-page.php'){ 
            remove_post_type_support('page', 'editor');
        }
    }
    
    
    function industing_custom_wc_checkout_fields( $fields ) 
    {
        $fields['billing']['billing_first_name']['placeholder'] = esc_html__('First Name *', 'industing');
        $fields['billing']['billing_first_name']['label'] = '';
        $fields['billing']['billing_last_name']['placeholder'] = esc_html__('Last Name *', 'industing');
        $fields['billing']['billing_last_name']['label'] = '';
        $fields['billing']['billing_company']['placeholder'] = esc_html__('Company Name', 'industing');
        $fields['billing']['billing_company']['label'] = '';
        $fields['billing']['billing_email']['placeholder'] = esc_html__('Email Address *', 'industing');
        $fields['billing']['billing_email']['label'] = '';
        $fields['billing']['billing_phone']['placeholder'] = esc_html__('Phone Number *', 'industing');
        $fields['billing']['billing_phone']['label'] = '';
        $fields['billing']['billing_country']['placeholder'] = esc_html__('State / Country *', 'industing');
        $fields['billing']['billing_country']['label'] = '';
        $fields['billing']['billing_address_1']['placeholder'] = esc_html__('Street address', 'industing');
        $fields['billing']['billing_address_1']['label'] = '';
        $fields['billing']['billing_city']['placeholder'] = esc_html__('Town / City *', 'industing');
        $fields['billing']['billing_city']['label'] = '';
        $fields['billing']['billing_state']['placeholder'] = esc_html__('District *', 'industing');
        $fields['billing']['billing_state']['label'] = '';
        $fields['billing']['billing_postcode']['placeholder'] = esc_html__('Pincode', 'industing');
        $fields['billing']['billing_postcode']['label'] = '';
        $fields['account']['account_password']['placeholder'] = esc_html__('Password', 'industing');
        $fields['account']['account_password']['label'] = '';
        $fields['shipping']['shipping_first_name']['placeholder'] = esc_html__('First Name *', 'industing');
        $fields['shipping']['shipping_first_name']['label'] = '';
        $fields['shipping']['shipping_last_name']['placeholder'] = esc_html__('Last Name *', 'industing');
        $fields['shipping']['shipping_last_name']['label'] = '';
        $fields['shipping']['shipping_company']['placeholder'] = esc_html__('Company Name', 'industing');
        $fields['shipping']['shipping_company']['label'] = '';
        $fields['shipping']['shipping_email']['placeholder'] = esc_html__('Email Address *', 'industing');
        $fields['shipping']['shipping_email']['label'] = '';
        $fields['shipping']['shipping_phone']['placeholder'] = esc_html__('Phone Number *', 'industing');
        $fields['shipping']['shipping_phone']['label'] = '';    
        $fields['shipping']['shipping_country']['placeholder'] = esc_html__('State / Country *', 'industing');
        $fields['shipping']['shipping_country']['label'] = '';
        $fields['shipping']['shipping_address_1']['placeholder'] = esc_html__('Street address', 'industing');
        $fields['shipping']['shipping_address_1']['label'] = '';
        $fields['shipping']['shipping_city']['placeholder'] = esc_html__('Town / City *', 'industing');
        $fields['shipping']['shipping_city']['label'] = '';
        $fields['shipping']['shipping_state']['placeholder'] = esc_html__('District *', 'industing');
        $fields['shipping']['shipping_state']['label'] = '';
        $fields['shipping']['shipping_postcode']['placeholder'] = esc_html__('Pincode', 'industing');
        $fields['shipping']['shipping_postcode']['label'] = '';
        $fields['order']['order_comments']['label'] = '';
        return $fields;
    }
    
    
    function industing_cart_button_item_count( $fragments ) 
    {
        global $woocommerce;
        ob_start();
        ?>
        <a href="<?php echo wc_get_cart_url(); ?>" class="cartToggler">
                <i class="twi-shopping-cart2"></i>
                <span><?php echo sprintf(_n('%d', '%d', $woocommerce->cart->cart_contents_count, 'industing'), $woocommerce->cart->cart_contents_count);?></span>
            
        <?php
        $fragments['a.cartToggler'] = ob_get_clean();
        return $fragments;

    }

}

$industing_instance = Industing_Hooks_Class::industing_instance();