<?php
get_header();

$ser_sidebar_pos = get_theme_mod('ser_sidebar_pos', 3);
$_service_gallery = fw_get_db_post_option(get_the_ID(), '_service_gallery', array());
$ser_sub_title = fw_get_db_post_option(get_the_ID(), 'ser_sub_title', array());
$ser_single_style = get_theme_mod('ser_single_style', 2);

$class = ($ser_sidebar_pos != 2 && is_active_sidebar('sidebar-3')) ? 'col-lg-8 col-md-12' : 'col-lg-10 offset-lg-1 col-sm-12 ser_full';

get_template_part( 'template-parts/header/service-single', 'header' );
?>
<section class="commonSection service_detail">
    <div class="container">
        <div class="row">
            <?php if($ser_sidebar_pos == 1 && is_active_sidebar('sidebar-3')): ?>
            <div class="col-lg-4 col-md-6 sidebar_1">
                <?php dynamic_sidebar('sidebar-3'); ?>
            </div>
            <?php endif; ?>
            <div class="<?php echo esc_attr($class); ?>">
                <?php while(have_posts()): the_post(); ?>
                <div class="service_details_area">
                    <?php if($ser_sub_title != ''): ?>
                    <div class="sda_sub">
                        <p><?php echo esc_html($ser_sub_title); ?></p>
                    </div>
                    <?php endif; ?>
                    <h2 class="entry_title">
                        <?php echo get_the_title(); ?>
                    </h2>
                    <?php if($ser_single_style == 1): ?>
                        <div class="fsSlider owl-carousel">
                            <?php if(is_array($_service_gallery) && !empty($_service_gallery)):
                                foreach($_service_gallery as $sg):
                                    $img = wp_get_attachment_image_src($sg['attachment_id'], 'industing-blog-4');
                                    ?>
                                    <div class="sda_gl">
                                        <img src="<?php echo esc_url($img[0]) ?>" alt="<?php echo get_the_ID(); ?>">
                                    </div>
                                    <?php
                                endforeach;
                            endif;
                            ?>
                            <?php if(has_post_thumbnail()): ?>
                                <div class="sda_gl">
                                    <?php echo get_the_post_thumbnail(get_the_ID(), 'industing-blog-4'); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php else: ?>
                    <div class="sda_gall">
                        <div class="row">
                            <?php if(has_post_thumbnail()): ?>
                            <div class="col-lg-12 col-md-12">
                                <div class="sda_gl">
                                    <?php echo get_the_post_thumbnail(get_the_ID(), 'industing-blog-4'); ?>
                                </div>
                            </div>    
                            <?php endif; ?>
                            <?php if(is_array($_service_gallery) && !empty($_service_gallery)):
                                foreach($_service_gallery as $sg):
                                    $img = wp_get_attachment_image_src($sg['attachment_id'], 'industing-blog-3');
                                    ?>
                                    <div class="col-lg-6 col-md-6">
                                        <div class="sda_gl">
                                            <img src="<?php echo esc_url($img[0]) ?>" alt="<?php echo get_the_ID(); ?>">
                                        </div>
                                    </div>
                                    <?php
                                endforeach;
                            endif;
                            ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="sda_content">
                        <?php the_content(); ?>
                    </div>
                </div>
                <?php endwhile; ?>
            </div>
            <?php if($ser_sidebar_pos == 3 && is_active_sidebar('sidebar-3')): ?>
            <div class="col-lg-4 col-md-6 sidebar_1">
                <?php dynamic_sidebar('sidebar-3'); ?>
            </div>
            <?php endif; ?>
        </div>
    </div>
</section>
<?php
    $service_bloks = get_theme_mod('service_bloks', '');
    $blocks_id = array();
    if(!empty($service_bloks)){
        foreach($service_bloks as $sb):
            if($sb['block_ids'] != '' && $sb['block_ids'] != 'none'):
                $blocks_id[] = $sb['block_ids'];
            endif;
        endforeach;
        $bloks = array(
            'post_type'     => 'blocks',
            'post_status'   => 'publish',
            'post__in'      => $blocks_id
        );
        $blok = new WP_Query($bloks);
        if($blok->have_posts()):
            while($blok->have_posts()):
            $blok->the_post();
            the_content();
            endwhile;
        endif;
    }
get_footer();