<?php
$page_banner_bg = '';
$page_is_breadcrumb = 1;
$page_bread_title = get_the_title();
$page_page_title = get_the_title();
if(defined('FW')){
    $page_banner_bg = fw_get_db_post_option(get_the_ID(), 'page_banner_bg', array());
    $page_is_breadcrumb = fw_get_db_post_option(get_the_ID(), 'page_is_breadcrumb', 1);
    $page_bread_title = fw_get_db_post_option(get_the_ID(), 'page_bread_title', get_the_title());
    $page_page_title = fw_get_db_post_option(get_the_ID(), 'page_page_title', get_the_title());
}

$bgStyle = '';
if(isset($page_banner_bg['url']) && $page_banner_bg['url'] != ''){
    $bgStyle = 'background-image: url('.$page_banner_bg['url'].'); background-repeat: no-repeat; background-position: center center; background-size: cover;';
}


$title = '';
$bread_title = '';
if($page_page_title != ''):
    $title = $page_page_title;
else:
    $title = get_the_title();
endif;
if($page_bread_title != ''):
    $bread_title = $page_bread_title;
else: 
    $bread_title = get_the_title();
endif;
?>
<section class="page_banner" style="<?php echo esc_attr($bgStyle) ?>">
    <div class="container">
        <div class="row">
            <div class="col-xl-12 text-center">
                <h2><?php echo wp_kses($title, industing_allowed_html()) ?></h2>
                <div class="breadcrumbs">
                    <?php if ($page_is_breadcrumb == 1): ?>
                        <a href="<?php echo esc_url(home_url('/')) ?>"><?php echo esc_html__('Home', 'industing') ?></a><i>|</i><span><?php echo esc_html($bread_title); ?></span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>