<?php
    $serv_banner_bg = get_theme_mod('serv_banner_bg', '');
    $serv_is_breadcrumb = get_theme_mod('serv_is_breadcrumb', 1);
    $serv_bread_title = get_theme_mod('serv_bread_title', esc_html__('Services', 'industing'));
    $serv_banner_title = get_theme_mod('serv_banner_title', esc_html__('Our Services', 'industing'));
    
    $bgStyle = '';
    if($serv_banner_bg != ''){
        $bgStyle = 'background-image: url('.$serv_banner_bg.'); background-repeat: no-repeat; background-position: center center; background-size: cover;';
    }
    
    if(defined('FW')){
        $page_is_breadcrumb = fw_get_db_post_option(get_the_ID(), 'page_is_breadcrumb', 1);
        $page_bread_title = fw_get_db_post_option(get_the_ID(), 'page_bread_title', '');
        $page_page_title = fw_get_db_post_option(get_the_ID(), 'page_page_title', '');
        
        $page_banner_bg = fw_get_db_post_option(get_the_ID(), 'page_banner_bg', '');
        $page_banner_bg = (isset($page_banner_bg['url']) && $page_banner_bg['url'] != '') ? $page_banner_bg['url'] : '';

        $serv_banner_title = ($page_page_title != '') ? $page_page_title : $serv_banner_title;
        $serv_bread_title = ($page_bread_title != '') ? $page_bread_title : $serv_bread_title;
        $serv_is_breadcrumb = ($page_is_breadcrumb != '') ? $page_is_breadcrumb : $serv_is_breadcrumb;
        if($page_banner_bg != ''){
            $bgStyle = 'background-image: url('.$page_banner_bg.'); background-repeat: no-repeat; background-attachment: scroll; background-position: center center; background-size: cover; ';
        }
    }
?>
<section class="page_banner" style="<?php echo esc_attr($bgStyle) ?>">
    <div class="container">
        <div class="row">
            <div class="col-xl-12 text-center">
                <h2><?php echo esc_html($serv_banner_title); ?></h2>
                <?php if ($serv_is_breadcrumb == 1): ?>
                    <div class="breadcrumbs">
                        <a href="<?php echo esc_url(home_url('/')) ?>"><?php echo esc_html__('Home', 'industing') ?></a><i>|</i><span><?php echo esc_html($serv_bread_title); ?></span>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>