<?php
    $pro_banner_bg = get_theme_mod('pro_banner_bg', '');
    $pro_is_breadcrumb = get_theme_mod('pro_is_breadcrumb', 1);
    $pro_banner_title = get_theme_mod('pro_banner_title', esc_html__('Product Details', 'industing'));
    $pro_shop_page_ID = get_option( 'woocommerce_shop_page_id' ); 
    
    $bgStyle = '';
    if($pro_banner_bg != ''){
        $bgStyle = 'background-image: url('.$pro_banner_bg.'); background-repeat: no-repeat; background-position: center center; background-size: cover;';
    }
    
    if(defined('FW')){
        $pro_single_is_bread = fw_get_db_post_option(get_the_ID(), 'pro_single_is_bread', 1);
        $pro_single_banner_title = fw_get_db_post_option(get_the_ID(), 'pro_single_banner_title', '');
        
        $pro_single_banner_image = fw_get_db_post_option(get_the_ID(), 'pro_single_banner_image', '');
        $pro_single_banner_image = (isset($pro_single_banner_image['url']) && $pro_single_banner_image['url'] != '') ? $pro_single_banner_image['url'] : '';

        $pro_banner_title = ($pro_single_banner_title != '') ? $pro_single_banner_title : $pro_banner_title;
        $pro_is_breadcrumb = ($pro_single_is_bread != '') ? $pro_single_is_bread : $pro_is_breadcrumb;
        if($pro_single_banner_image != ''){
            $bgStyle = 'background-image: url('.$pro_single_banner_image.'); background-repeat: no-repeat; background-attachment: scroll; background-position: center center; background-size: cover; ';
        }
    }
?>
<section class="page_banner" style="<?php echo esc_attr($bgStyle) ?>">
    <div class="container">
        <div class="row">
            <div class="col-xl-12 text-center">
                <h2><?php echo esc_html($pro_banner_title); ?></h2>
                <?php if ($pro_is_breadcrumb == 1): ?>
                    <div class="breadcrumbs">
                        <a href="<?php echo esc_url(home_url('/')) ?>"><?php echo esc_html__('Home', 'industing') ?></a><i>|</i><a href="<?php echo get_the_permalink($pro_shop_page_ID); ?>"><?php echo get_the_title($pro_shop_page_ID); ?></a><i>|</i><span><?php echo substr(get_the_title(get_the_ID()), 0, 25).'...' ?></span>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>