<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>
<div class="single_product offerProduct">
    <div class="productImg">
        <?php if(has_post_thumbnail()): ?>
            <?php echo get_the_post_thumbnail(get_the_ID(), 'industing-pro-1'); ?>
        <?php else: ?>
            <img src="http://via.placeholder.com/390x312" alt="<?php echo get_the_title(); ?>">
        <?php endif; ?>
    </div>
    <?php echo industin_product_flash_notice_label(); ?>
    <div class="product_dec">
        <div class="product_decIn">
            <h2 class="productTitle"><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h2>
            <div class="product_price">
                <?php if(function_exists('woocommerce_template_loop_price')){ echo woocommerce_template_loop_price(); } ?>
                <?php if(function_exists('woocommerce_template_loop_rating')){ echo woocommerce_template_loop_rating(); } ?>
            </div>
            <div class="product_btn">
                <a class="popUp" href="<?php echo get_the_permalink(); ?>"><i class="twi-search1"></i><?php esc_html_e('View Details', 'industing') ?></a>
                <?php if(function_exists('woocommerce_template_loop_add_to_cart')){ echo woocommerce_template_loop_add_to_cart();} ?>
            </div>
        </div>
    </div>
</div>