<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_CTA_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-call-to-action';
    }
    
    public function get_title() {
        return esc_html__( 'Call To Action', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-call-to-action';
    }

    public function get_categories() {
        return [ 'industing-elements' ];
    }
    
    protected function _register_controls() {
        $this->start_controls_section(
            'section_tab', [
                'label' =>esc_html__( 'Call To Action', 'themewar' ),
            ]
        );
        $this->add_control(
                'action_style',
                [
                        'label'         => esc_html__( 'Action Style', 'themewar' ),
                        'type'          => Controls_Manager::SELECT,
                        'default'       => 0,
                        'label_block'   => TRUE,
                        'options'       => [
                                0       => esc_html__( 'Select Action Style', 'themewar' ),
                                1       => esc_html__( 'With Icon', 'themewar' ),
                                2       => esc_html__( 'With Out Icon', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'icons',
                [
                        'label'         => esc_html__( 'Action Icon', 'themewar' ),
                        'type'          => Controls_Manager::ICON,
                        'condition'     => ['action_style' => '1'],
                        'label_block'   => TRUE,
                ]
        );
        $this->add_control(
                'sub_title',
                [
                        'label'         => esc_html__( 'Action Sub Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'label_block'   => true,
                        'placeholder'   => esc_html__('Insert Sub Title', 'themewar')
                ]
        );
        $this->add_control(
               'title', [
                    'label'             => esc_html__('Action Title', 'themewar'),
                    'type'              => Controls_Manager::TEXT,
                    'label_block'       => true,
                    'default'           => esc_html__('', 'themewar'),
                    'placeholder'       => esc_html__('Inser Title', 'themewar'),
                ]
        );
        $this->add_responsive_control(
                'action_align', [
                        'label'                     =>esc_html__( 'Alignment', 'themewar' ),
                        'type'                      => Controls_Manager::CHOOSE,
                        'options'                   => [
                                'left'		 => [
                                        'title'	 =>esc_html__( 'Left', 'themewar' ),
                                        'icon'	 => 'fa fa-align-left',
                                ],
                                'center'	 => [
                                        'title'	 =>esc_html__( 'Center', 'themewar' ),
                                        'icon'	 => 'fa fa-align-center',
                                ],
                                'right'		 => [
                                        'title'	 =>esc_html__( 'Right', 'themewar' ),
                                        'icon'	 => 'fa fa-align-right',
                                ]
                        ],
                        'default'                   => 'left',
                        'prefix_class'              => 'callToaction elementor%s-align-',
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_1', [
                    'label'         => esc_html__('Icon Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE
                ]
        );
        $this->add_control(
                'icon_color',
                [
                        'label'     => esc_html__( 'Icon Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .cta_left_02 i' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .cta_left_02 i'
                ]
        );
        $this->add_control(
            'icon_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_03 i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_2', [
                'label' =>esc_html__( 'Action Sub Title Style', 'themewar' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_control(
            'sub_title_color', [
                'label'		 =>esc_html__( 'Sub Title color', 'themewar' ),
                'type'		 => Controls_Manager::COLOR,
                'selectors'	 => [
                    '{{WRAPPER}} .cta_left_02 h6' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .cta_left h6' => 'color: {{VALUE}};'
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'label' => esc_html__( 'Sub Title Typography', 'themewar' ),
                'selector' => '{{WRAPPER}} .cta_left_02 h6', '{{WRAPPER}} .cta_left h6',
            ]
        );
        $this->add_control(
            'sub_margins',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'selectors'     => [
                            '{{WRAPPER}} .cta_left_02 h6' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .cta_left h6' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_3', [
                'label' =>esc_html__( 'Action Title Style', 'themewar' ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_control(
            'title_color', [
                'label'		 =>esc_html__( 'Title color', 'themewar' ),
                'type'		 => Controls_Manager::COLOR,
                'selectors'	 => [
                    '{{WRAPPER}} .cta_left_02 h2' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .cta_left h2' => 'color: {{VALUE}};'
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__( 'Title Typography', 'themewar' ),
                'selector' => '{{WRAPPER}} .cta_left_02 h2', '{{WRAPPER}} .cta_left h2',
            ]
        );
        $this->add_control(
            'title_margins',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'selectors'     => [
                            '{{WRAPPER}} .cta_left_02 h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .cta_left h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
            ]
        );
        $this->end_controls_section();
        
    }
    
    protected function render() {
        $settings           = $this->get_settings();
        $action_style       = (isset($settings['action_style']) && $settings['action_style'] > 0) ? $settings['action_style'] : 0;
        $icons              = (isset($settings['icons']) && $settings['icons'] != '') ? $settings['icons'] : '';
        $sub_title          = (isset($settings['sub_title']) && $settings['sub_title'] != '') ? $settings['sub_title'] : '';
        $title              = (isset($settings['title']) && $settings['title'] != '') ? $settings['title'] : '';
        
        switch ($action_style) {
            case 1:
                ?>
                <div class="cta_left_02">
                    <?php if($icons != ''): ?>
                        <i class="<?php echo esc_attr($icons);?>"></i>
                    <?php endif; ?>
                    <?php if($sub_title != ''): ?>
                        <h6><?php echo esc_html($sub_title); ?></h6>
                    <?php endif; ?>
                    <?php if($title != ''): ?>
                        <h2><?php echo esc_html($title); ?></h2>
                    <?php endif; ?>
                </div>
                <?php
                break;
            case 2:
                ?>
                <div class="cta_left">
                    <?php if($sub_title != ''): ?>
                        <h6><?php echo esc_html($sub_title); ?></h6>
                    <?php endif; ?>
                    <?php if($title != ''): ?>
                        <h2><?php echo esc_html($title); ?></h2>
                    <?php endif; ?>
                </div>
                <?php
                break;
            default:
                ?>
                    <div class="alert alert-warning" role="alert">
                        <?php echo esc_html__('Please select Action style first.', 'themewar'); ?>
                    </div>
                <?php
                break;
        }
        
    }
    
    protected function _content_template() {
        
    }
}