<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Icon_Box_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-icon-box';
    }
    
    public function get_title() {
        return esc_html__( 'Icon Box', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-icon-box';
    }

    public function get_categories() {
        return [ 'industing-elements' ];
    }
    
    protected function _register_controls() {
        $this->start_controls_section(
            'section_tab', [
                'label' =>esc_html__( 'Icon Box', 'themewar' ),
            ]
        );
        $this->add_control(
                'box_style',
                [
                        'label'         => esc_html__( 'Box Style', 'themewar' ),
                        'type'          => Controls_Manager::SELECT,
                        'default'       => 0,
                        'label_block'   => TRUE,
                        'options'       => [
                                0       => esc_html__( 'Select Box Style', 'themewar' ),
                                1       => esc_html__( 'Icon Box 1', 'themewar' ),
                                2       => esc_html__( 'Icon Box 2 With Counter', 'themewar' ),
                                3       => esc_html__( 'Icon Box 3', 'themewar' ),
                                4       => esc_html__( 'Icon Box 4', 'themewar' ),
                                5       => esc_html__( 'Icon Box 5', 'themewar' ),
                                6       => esc_html__( 'Icon Box 6', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'icons',
                [
                        'label'         => esc_html__( 'Icon', 'themewar' ),
                        'type'          => Controls_Manager::ICON,
                        'label_block'   => TRUE,
                ]
        );
        $this->add_control(
                'bg_icon',
                [
                        'label'         => esc_html__( 'Background Icon', 'themewar' ),
                        'type'          => Controls_Manager::ICON,
                        'label_block'   => TRUE,
                        'condition'     => ['box_style' => '1']
                ]
        );
        $this->add_control(
                'show_bar',
                [
                        'label'         => esc_html__( 'Show Bar', 'themewar' ),
                        'type'          => Controls_Manager::SWITCHER,
                        'label_on'      => esc_html__( 'Show', 'themewar' ),
                        'label_off'     => esc_html__( 'Hide', 'themewar' ),
                        'return_value'  => 'yes',
                        'default'       => 'yes',
                        'condition'     => ['box_style' => '1']
                ]
        );
        $this->add_control(
                'title',
                [
                        'label'         => esc_html__( 'Icon Box Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'label_block'   => TRUE,
                        'placeholder'   => esc_html__('', 'themewar'),
                        'description'   => esc_html__('Insert your Icon BOx Title.', 'themewar'),
                ]
        );
        $this->add_control(
                'title_url',
                [
                        'label'             => esc_html__( 'Title Url', 'themewar' ),
                        'type'              => Controls_Manager::URL,
                        'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                        'condition'         => ['box_style' => '1'],
                        'show_external'     => true,
                        'default'           => [
                                'url' => '',
                                'is_external' => true,
                                'nofollow' => true,
                        ],
                ]
        );
        $this->add_control(
                'title_url_3',
                [
                        'label'             => esc_html__( 'Title Url', 'themewar' ),
                        'type'              => Controls_Manager::URL,
                        'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                        'condition'         => ['box_style' => '3'],
                        'show_external'     => true,
                        'default'           => [
                                'url' => '',
                                'is_external' => true,
                                'nofollow' => true,
                        ],
                ]
        );
        $this->add_control(
                'title_url_6',
                [
                        'label'             => esc_html__( 'Title Url', 'themewar' ),
                        'type'              => Controls_Manager::URL,
                        'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                        'condition'         => ['box_style' => '6'],
                        'show_external'     => true,
                        'default'           => [
                                'url' => '',
                                'is_external' => true,
                                'nofollow' => true,
                        ],
                ]
        );
        $this->add_control(
                'counter',
                [
                        'label'         => esc_html__( 'Counter Number Title', 'themewar' ),
                        'type'          => Controls_Manager::NUMBER,
                        'default'       => '',
                        'condition'     => ['box_style' => '2'],
                        'label_block'   => TRUE,
                        'placeholder'   => esc_html__('', 'themewar'),
                        'description'   => esc_html__('Insert your Counter Number Title.', 'themewar'),
                ]
        );
        $this->add_control(
                'suffix',
                [
                        'label'         => esc_html__( 'Counter Suffix Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'condition'     => ['box_style' => '2'],
                        'label_block'   => TRUE,
                        'placeholder'   => esc_html__('', 'themewar'),
                        'description'   => esc_html__('Insert your Counter Number Suffix.', 'themewar'),
                ]
        );
        $this->add_control(
                'desc',
                [
                        'label'         => esc_html__( 'Description', 'themewar' ),
                        'type'          => Controls_Manager::TEXTAREA,
                        'conditions'    => [
                            'terms' => [
                                    [
                                            'name'      => 'box_style',
                                            'operator'  => '!in',
                                            'value'     => ['6'],
                                    ]
                            ],
                         ],
                        'placeholder'   => esc_html__('', 'themewar'),
                        'description'   => esc_html__('Insert your Icon Box Description.', 'themewar'),
                        
                ]
        );
        $this->add_control(
                'read_more',
                [
                        'label'         => esc_html__( 'Read More Label', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'condition'     => ['box_style' => '4'],
                        'label_block'   => TRUE,
                        'placeholder'   => esc_html__('', 'themewar'),
                        'description'   => esc_html__('Insert your Read More Label.', 'themewar'),
                ]
        );
        $this->add_control(
                'read_url',
                [
                        'label'             => esc_html__( 'Read More Url', 'themewar' ),
                        'type'              => Controls_Manager::URL,
                        'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                        'condition'         => ['box_style' => '4'],
                        'show_external'     => true,
                        'default'           => [
                                'url' => '',
                                'is_external' => true,
                                'nofollow' => true,
                        ],
                ]
        );
        $this->add_control(
                'read_more_2',
                [
                        'label'         => esc_html__( 'Box Read More Label', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'condition'     => ['box_style' => '5'],
                        'label_block'   => TRUE,
                        'placeholder'   => esc_html__('', 'themewar'),
                        'description'   => esc_html__('Insert your Read More Label.', 'themewar'),
                ]
        );
        $this->add_control(
                'read_url_2',
                [
                        'label'             => esc_html__( 'Read More Url', 'themewar' ),
                        'type'              => Controls_Manager::URL,
                        'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                        'condition'         => ['box_style' => '5'],
                        'show_external'     => true,
                        'default'           => [
                                'url' => '',
                                'is_external' => true,
                                'nofollow' => true,
                        ],
                ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
                'list_item', [
                        'label'         => esc_html__( 'Insert List Item', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => esc_html__( '' , 'themewar' ),
                        'label_block'   => true
                ]
        );
        $this->add_control(
            'list',
            [
                    'label'         => esc_html__( '', 'themewar' ),
                    'type'          => Controls_Manager::REPEATER,
                    'fields'        => $repeater->get_controls(),
                    'condition'     => ['box_style' => '3'],
                    'default'       => [
                            [
                                    'list_item'        => esc_html__( '', 'themewar' )

                            ],
                    ],
                    'title_field' => "{{{ list_item }}}",
            ]
        );
        $this->add_responsive_control(
                'box_align', [
                        'label'                  => esc_html__( 'Alignment', 'themewar' ),
                        'type'                   => Controls_Manager::CHOOSE,
                        'options'                => [
                                'left'		 => [
                                        'title'	 => esc_html__( 'Left', 'themewar' ),
                                        'icon'	 => 'fa fa-align-left',
                                ],
                                'center'	 => [
                                        'title'	 => esc_html__( 'Center', 'themewar' ),
                                        'icon'	 => 'fa fa-align-center',
                                ],
                                'right'		 => [
                                        'title'	 => esc_html__( 'Right', 'themewar' ),
                                        'icon'	 => 'fa fa-align-right',
                                ]
                        ],
                        'default'                => 'center',
                        'prefix_class'           => 'box_align elementor%s-align-',
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_1', [
                    'label'         => esc_html__('Box Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '1']
                ]
        );
        $this->start_controls_tabs( 'style_tabs_1' );
            $this->start_controls_tab(
                    'style_1_normal_tab',
                    [
                            'label'         => esc_html__( 'Normal', 'themewar' ),
                            'condition'     => ['box_style' => '1'],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name'      => 'Background',
                            'label'     => esc_html__( 'BG Color', 'themewar' ),
                            'types'     => [ 'classic', 'gradient', 'video' ],
                            'selector'  => '{{WRAPPER}} .icon_box_01',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name'      => 'box_shadow',
                            'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .icon_box_01',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'style_1_hover_tab',
                    [
                            'label'     => esc_html__( 'Hover', 'themewar' ),
                            'condition'     => ['box_style' => '1'],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name'      => 'hover_Background',
                            'label'     => esc_html__( 'BG Hover Color', 'themewar' ),
                            'types'     => [ 'classic', 'gradient', 'video' ],
                            'selector'  => '{{WRAPPER}} .icon_box_01:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name'      => 'hover_box_shadow',
                            'label'     => esc_html__( 'Hover Box Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .icon_box_01:hover',
                    ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
            'box_1_padding',
            [
                    'label'         => esc_html__( 'Paddings', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '1'],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_01' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->add_control(
            'box_1_margin',
            [
                    'label'         => esc_html__( 'Paddings', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '1'],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_01' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_2', [
                    'label'         => esc_html__('Icon Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '1']
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'condition' => ['box_style' => '1'],
                        'selector'  => '{{WRAPPER}} .icon_box_01 i.smaller',
                ]
        );
        $this->start_controls_tabs( 'style_tabs_2' );
            $this->start_controls_tab(
                    'style_2_normal_tab',
                    [
                            'label'         => esc_html__( 'Normal', 'themewar' ),
                            'condition'     => ['box_style' => '1'],
                    ]
            );
            $this->add_control(
                    'box_1_icon_color',
                    [
                            'label'     => esc_html__( 'Icon Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .icon_box_01 i.smaller' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'style_2_hover_tab',
                    [
                            'label'     => esc_html__( 'Hover', 'themewar' ),
                            'condition' => ['box_style' => '1'],
                    ]
            );
            $this->add_control(
                    'box_1_icon_hover_color',
                    [
                            'label'     => esc_html__( 'Icon Hover Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .icon_box_01:hover i.smaller' => 'color: {{VALUE}}',
                            ],
                    ]
            );
        $this->end_controls_tabs();
        $this->add_control(
            'box_1_icon_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '1'],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_01 i.smaller' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_3', [
                    'label'         => esc_html__('BG Icon Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '1']
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'bg_icon_typography',
                        'label'     => esc_html__( 'BG Icon Typography', 'themewar' ),
                        'condition' => ['box_style' => '1'],
                        'selector'  => '{{WRAPPER}} .icon_box_01 i.bigger',
                ]
        );
        $this->start_controls_tabs( 'style_tabs_3' );
            $this->start_controls_tab(
                    'style_3_normal_tab',
                    [
                            'label'         => esc_html__( 'Normal', 'themewar' ),
                            'condition'     => ['box_style' => '1'],
                    ]
            );
            $this->add_control(
                    'box_1_bg_icon_color',
                    [
                            'label'     => esc_html__( 'Icon Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .icon_box_01 i.bigger' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'style_3_hover_tab',
                    [
                            'label'     => esc_html__( 'Hover', 'themewar' ),
                            'condition' => ['box_style' => '1'],
                    ]
            );
            $this->add_control(
                    'box_1_bg_icon_hover_color',
                    [
                            'label'     => esc_html__( 'Icon Hover Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .icon_box_01:hover i.bigger' => 'color: {{VALUE}}',
                            ],
                    ]
            );
        $this->end_controls_tabs();
        $this->add_control(
            'box_1_bg_icon_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '1'],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_01 i.bigger' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_4', [
                    'label'         => esc_html__('Bar Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '1']
                ]
        );
        $this->start_controls_tabs( 'style_tabs_4' );
            $this->start_controls_tab(
                    'style_10_normal_tab',
                    [
                            'label'         => esc_html__( 'Normal', 'themewar' ),
                            'condition'     => ['box_style' => '1'],
                    ]
            );
            $this->add_control(
                    'bar_bg_color',
                    [
                            'label'     => esc_html__( 'Bar BG Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .icon_box_01 span' => 'background: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_control(
                    'bar_width',
                    [
                            'label' => __( 'Bar Width', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 500,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .icon_box_01 span' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'style_4_hover_tab',
                    [
                            'label'         => esc_html__( 'Hover', 'themewar' ),
                            'condition'     => ['box_style' => '1'],
                    ]
            );
            $this->add_control(
                    'bar_bg_hover_color',
                    [
                            'label'     => esc_html__( 'Bar BG Hover Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .icon_box_01:hover span' => 'background: {{VALUE}}',
                            ],
                    ]
            );
            $this->add_control(
                    'bar_hover_width',
                    [
                            'label' => __( 'Bar Hover Width', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 500,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .icon_box_01:hover span' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
                'bar_height',
                [
                        'label' => __( 'Bar Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .icon_box_01 span' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_5', [
                    'label'         => esc_html__('Title Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '1']
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'title_1_typography',
                        'label'     => esc_html__( 'Title Typography', 'themewar' ),
                        'condition' => ['box_style' => '1'],
                        'selector'  => '{{WRAPPER}} .icon_box_01 h3',
                ]
        );
        $this->start_controls_tabs( 'style_tabs_7' );
            $this->start_controls_tab(
                    'style_5_normal_tab',
                    [
                            'label'         => esc_html__( 'Normal', 'themewar' ),
                            'condition'     => ['box_style' => '1'],
                    ]
            );
            $this->add_control(
                    'box_1_title_color',
                    [
                            'label'     => esc_html__( 'Title Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .icon_box_01 h3' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'style_5_hover_tab',
                    [
                            'label'     => esc_html__( 'Hover', 'themewar' ),
                            'condition' => ['box_style' => '1'],
                    ]
            );
            $this->add_control(
                    'box_1_title_hover_color',
                    [
                            'label'     => esc_html__( 'Title Hover Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .icon_box_01:hover h3' => 'color: {{VALUE}}',
                            ],
                    ]
            );
        $this->end_controls_tabs();
        $this->add_control(
            'box_1_title_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '1'],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_01 h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_6', [
                    'label'         => esc_html__('Description Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '1']
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'desc_1_typography',
                        'label'     => esc_html__( 'Description Typography', 'themewar' ),
                        'condition' => ['box_style' => '1'],
                        'selector'  => '{{WRAPPER}} .icon_box_01 p',
                ]
        );
        $this->start_controls_tabs( 'style_tabs_6' );
            $this->start_controls_tab(
                    'style_6_normal_tab',
                    [
                            'label'         => esc_html__( 'Normal', 'themewar' ),
                            'condition'     => ['box_style' => '1'],
                    ]
            );
            $this->add_control(
                    'box_1_desc_color',
                    [
                            'label'     => esc_html__( 'Description Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .icon_box_01 p' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'style_6_hover_tab',
                    [
                            'label'     => esc_html__( 'Hover', 'themewar' ),
                            'condition' => ['box_style' => '1'],
                    ]
            );
            $this->add_control(
                    'box_1_desc_hover_color',
                    [
                            'label'     => esc_html__( 'Description Hover Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .icon_box_01:hover p' => 'color: {{VALUE}}',
                            ],
                    ]
            );
        $this->end_controls_tabs();
        $this->add_control(
            'box_1_desc_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '1'],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_01 p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_7', [
                    'label'         => esc_html__('Box Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '2']
                ]
        );
        $this->add_control(
            'box_2_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '2'],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_02' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->add_control(
            'box_2_padding',
            [
                    'label'         => esc_html__( 'Paddings', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '2'],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_02' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_8', [
                    'label'         => esc_html__('Icon Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '2']
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'box_2_icon_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'condition' => ['box_style' => '2'],
                        'selector'  => '{{WRAPPER}} .icon_box_02 i',
                ]
        );
        $this->add_control(
                'box_2_icon_color',
                [
                        'label'     => esc_html__( 'Icon Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'condition' => ['box_style' => '2'],
                        'selectors' => [
                                '{{WRAPPER}} .icon_box_02 i' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_control(
            'box_2_icon_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '2'],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_02 i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_9', [
                    'label'         => esc_html__('Title Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '2']
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'box_2_title_typography',
                        'label'     => esc_html__( 'Title Typography', 'themewar' ),
                        'condition' => ['box_style' => '2'],
                        'selector'  => '{{WRAPPER}} .icon_box_02 h3',
                ]
        );
        $this->add_control(
                'box_2_title_color',
                [
                        'label'     => esc_html__( 'Title Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'condition' => ['box_style' => '2'],
                        'selectors' => [
                                '{{WRAPPER}} .icon_box_02 h3' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'title_counter_typography',
                        'label'     => esc_html__( 'Counter Suffix Typography', 'themewar' ),
                        'condition' => ['box_style' => '2'],
                        'selector'  => '{{WRAPPER}} .icon_box_02 h3 span',
                ]
        );
        $this->add_control(
                'box_2_title_counter_color',
                [
                        'label'     => esc_html__( 'Counter Suffix Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'condition' => ['box_style' => '2'],
                        'selectors' => [
                                '{{WRAPPER}} .icon_box_02 h3 span' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_control(
            'box_2_title_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '2'],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_02 h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
                'section_tab_10', [
                    'label'         => esc_html__('Description Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '2']
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'box_2_desc_typography',
                        'label'     => esc_html__( 'Description Typography', 'themewar' ),
                        'condition' => ['box_style' => '2'],
                        'selector'  => '{{WRAPPER}} .icon_box_02 p',
                ]
        );
        $this->add_control(
                'box_2_desc_color',
                [
                        'label'     => esc_html__( 'Description Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'condition' => ['box_style' => '2'],
                        'selectors' => [
                                '{{WRAPPER}} .icon_box_02 p' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_control(
            'box_2_desc_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '2'],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_02 p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_11', [
                    'label'         => esc_html__('Box Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '3']
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'border',
                        'label' => esc_html__( 'Box Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .icon_box_03',
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name'      => 'box_3_background',
                        'label'     => esc_html__( 'Box BG', 'themewar' ),
                        'types'     => [ 'classic', 'gradient', 'video' ],
                        'selector'  => '{{WRAPPER}} .icon_box_03',
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name'      => 'box_3_shadow',
                        'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .icon_box_03',
                ]
        );
        $this->add_control(
            'box_3_padding',
            [
                    'label'         => esc_html__( 'Paddings', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '3'],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_03' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->add_control(
            'box_3_margin',
            [
                    'label'         => esc_html__( 'Paddings', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '3'],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_03' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_12', [
                    'label'         => esc_html__('Icon Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '3']
                ]
        );
        $this->add_control(
                'box_3_icon_color',
                [
                        'label'     => esc_html__( 'Icon Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .icon_box_03 i' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'box_3_icon_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'condition' => ['box_style' => '3'],
                        'selector'  => '{{WRAPPER}} .icon_box_03 i',
                ]
        );
        $this->add_control(
            'box_3_icon_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '3'],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_03 i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_13', [
                    'label'         => esc_html__('Title Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '3']
                ]
        );
        $this->start_controls_tabs( 'style_tabs_5' );
            $this->start_controls_tab(
                    'style_4_normal_tab',
                    [
                            'label'         => esc_html__( 'Normal', 'themewar' ),
                            'condition'     => ['box_style' => '3'],
                    ]
            );
            $this->add_control(
                    'box_3_title_color',
                    [
                            'label'     => esc_html__( 'Title Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .icon_box_03 h3 a' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'style_10_hover_tab',
                    [
                            'label'     => esc_html__( 'Hover', 'themewar' ),
                            'condition' => ['box_style' => '3'],
                    ]
            );
            $this->add_control(
                    'box_3_title_hover_color',
                    [
                            'label'     => esc_html__( 'Title Hover Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .icon_box_03 h3 a:hover' => 'color: {{VALUE}}',
                            ],
                    ]
            );
        $this->end_controls_tabs();
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'box_3_title_typography',
                        'label'     => esc_html__( 'Title Typography', 'themewar' ),
                        'condition' => ['box_style' => '3'],
                        'selector'  => '{{WRAPPER}} .icon_box_03 h3',
                ]
        );
        $this->add_control(
            'box_3_title_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '3'],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_03 h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_14', [
                    'label'         => esc_html__('Description Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '3']
                ]
        );
        $this->add_control(
                'box_3_desc_color',
                [
                        'label'     => esc_html__( 'Desc Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .icon_box_03 p' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'box_3_desc_typography',
                        'label'     => esc_html__( 'Desc Typography', 'themewar' ),
                        'condition' => ['box_style' => '3'],
                        'selector'  => '{{WRAPPER}} .icon_box_03 p',
                ]
        );
        $this->add_control(
            'box_3_desc_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '3'],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_03 p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_15', [
                    'label'         => esc_html__('List Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '3']
                ]
        );
        $this->add_control(
                'box_3_list_icon_color',
                [
                        'label'     => esc_html__( 'List Icon Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .icon_box_03 ul li:before' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_control(
                'box_3_list_color',
                [
                        'label'     => esc_html__( 'List Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .icon_box_03 ul li' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'box_3_list_typography',
                        'label'     => esc_html__( 'List Typography', 'themewar' ),
                        'condition' => ['box_style' => '3'],
                        'selector'  => '{{WRAPPER}} .icon_box_03 ul li',
                ]
        );
        $this->add_control(
            'box_3_list_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '3'],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_03 ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_16', [
                    'label'         => esc_html__('Box Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '4']
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'box_4_border',
                        'label' => esc_html__( 'Box Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .ib5_inner',
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name'      => 'box_4_background',
                        'label'     => esc_html__( 'Box BG', 'themewar' ),
                        'types'     => [ 'classic', 'gradient', 'video' ],
                        'selector'  => '{{WRAPPER}} .ib5_inner',
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name'      => 'box_4_shadow',
                        'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .icon_box_05',
                ]
        );
        $this->add_control(
            'box_4_padding',
            [
                    'label'         => esc_html__( 'Paddings', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'selectors'     => [
                            '{{WRAPPER}} .ib5_inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->add_control(
            'box_4_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_05' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_17', [
                    'label'         => esc_html__('Icon Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '4']
                ]
        );
        $this->add_control(
                'box_4_icon_color',
                [
                        'label'     => esc_html__( 'Icon Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .icon_box_05 i' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name'      => 'box_icon_background',
                        'label'     => esc_html__( 'Box BG', 'themewar' ),
                        'types'     => [ 'classic', 'gradient', 'video' ],
                        'selector'  => '{{WRAPPER}} .icon_box_05 i',
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'box_4_icon_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'condition' => ['box_style' => '4'],
                        'selector'  => '{{WRAPPER}} .icon_box_05 i',
                ]
        );
        $this->add_control(
            'icon_width',
            [
                    'label' => __( 'Width', 'themewar' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                            'px' => [
                                    'min' => 0,
                                    'max' => 500,
                                    'step' => 1,
                            ],
                            '%' => [
                                    'min' => 0,
                                    'max' => 100,
                            ],
                    ],
                    'default' => [],
                    'selectors' => [
                            '{{WRAPPER}} .icon_box_05 i' => 'width: {{SIZE}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_control(
                'icon_height',
                [
                        'label' => __( 'Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .icon_box_05 i' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'icon_border',
                        'label' => esc_html__( 'Icon Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .icon_box_05 i',
                ]
        );
        $this->add_control(
            'box_4_icon_padding',
            [
                    'label'         => esc_html__( 'Paddings', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '4'],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_05 i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->add_control(
            'box_4_icon_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '4'],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_05 i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_18', [
                    'label'         => esc_html__('Title Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '4']
                ]
        );
        $this->add_control(
                'box_4_title_color',
                [
                        'label'     => esc_html__( 'Title Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .ib5_inner h3' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'box_4_title_typography',
                        'label'     => esc_html__( 'Title Typography', 'themewar' ),
                        'condition' => ['box_style' => '4'],
                        'selector'  => '{{WRAPPER}} .ib5_inner h3',
                ]
        );
        $this->add_control(
            'box_4_title_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '4'],
                    'selectors'     => [
                            '{{WRAPPER}} .ib5_inner h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_19', [
                    'label'         => esc_html__('Description Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '4']
                ]
        );
        $this->add_control(
                'box_4_desc_color',
                [
                        'label'     => esc_html__( 'Desc Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .ib5_inner p' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'box_4_desc_typography',
                        'label'     => esc_html__( 'Desc Typography', 'themewar' ),
                        'condition' => ['box_style' => '4'],
                        'selector'  => '{{WRAPPER}} .ib5_inner p',
                ]
        );
        $this->add_control(
            'box_4_desc_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '4'],
                    'selectors'     => [
                            '{{WRAPPER}} .ib5_inner p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_20', [
                    'label'         => esc_html__('Read More Label Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '4']
                ]
        );
        $this->add_control(
                'box_4_read_color',
                [
                        'label'     => esc_html__( 'Label Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .ib5_inner > a' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_control(
                'box_4_read_hover_color',
                [
                        'label'     => esc_html__( 'Hover Label Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .ib5_inner > a:hover' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'box_4_read_typography',
                        'label'     => esc_html__( 'Label Typography', 'themewar' ),
                        'condition' => ['box_style' => '4'],
                        'selector'  => '{{WRAPPER}} .ib5_inner > a',
                ]
        );
        $this->add_control(
            'box_4_read_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '4'],
                    'selectors'     => [
                            '{{WRAPPER}} .ib5_inner > a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_21', [
                    'label'         => esc_html__('Box Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '5']
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'box_5_border',
                        'label' => esc_html__( 'Box Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .icon_box_05.ib5_left .ib5_inner',
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name'      => 'box_5_background',
                        'label'     => esc_html__( 'Box BG', 'themewar' ),
                        'types'     => [ 'classic', 'gradient', 'video' ],
                        'selector'  => '{{WRAPPER}} .icon_box_05.ib5_left .ib5_inner',
                ]
        );
        $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                        'name'      => 'box_5_shadow',
                        'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .icon_box_05.ib5_left',
                ]
        );
        $this->add_control(
            'box_5_padding',
            [
                    'label'         => esc_html__( 'Paddings', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_05.ib5_left' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->add_control(
            'box_5_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_05.ib5_left' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_22', [
                    'label'         => esc_html__('Icon Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '5']
                ]
        );
        $this->add_control(
                'box_5_icon_color',
                [
                        'label'     => esc_html__( 'Icon Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .icon_box_05.ib5_left i' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                        'name'      => 'box_icons_background',
                        'label'     => esc_html__( 'Box BG', 'themewar' ),
                        'types'     => [ 'classic', 'gradient', 'video' ],
                        'selector'  => '{{WRAPPER}} .icon_box_05.ib5_left i',
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'box_5_icon_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'condition' => ['box_style' => '5'],
                        'selector'  => '{{WRAPPER}} .icon_box_05.ib5_left i',
                ]
        );
        $this->add_control(
            'icon_5_width',
            [
                    'label' => __( 'Width', 'themewar' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                            'px' => [
                                    'min' => 0,
                                    'max' => 500,
                                    'step' => 1,
                            ],
                            '%' => [
                                    'min' => 0,
                                    'max' => 100,
                            ],
                    ],
                    'default' => [],
                    'selectors' => [
                            '{{WRAPPER}} .icon_box_05.ib5_left i' => 'width: {{SIZE}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_control(
                'icon_5_height',
                [
                        'label' => __( 'Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .icon_box_05.ib5_left i' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'icon_5_border',
                        'label' => esc_html__( 'Icon Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .icon_box_05.ib5_left i',
                ]
        );
        $this->add_control(
            'box_5_icon_padding',
            [
                    'label'         => esc_html__( 'Paddings', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '5'],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_05.ib5_left i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->add_control(
            'box_5_icon_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '5'],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_05.ib5_left i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_23', [
                    'label'         => esc_html__('Title Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '5']
                ]
        );
        $this->add_control(
                'box_5_title_color',
                [
                        'label'     => esc_html__( 'Title Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .ib5_inner h3' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'box_5_title_typography',
                        'label'     => esc_html__( 'Title Typography', 'themewar' ),
                        'condition' => ['box_style' => '5'],
                        'selector'  => '{{WRAPPER}} .ib5_inner h3',
                ]
        );
        $this->add_control(
            'box_5_title_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '5'],
                    'selectors'     => [
                            '{{WRAPPER}} .ib5_inner h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_24', [
                    'label'         => esc_html__('Description Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '5']
                ]
        );
        $this->add_control(
                'box_5_desc_color',
                [
                        'label'     => esc_html__( 'Desc Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .ib5_inner p' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'box_5_desc_typography',
                        'label'     => esc_html__( 'Desc Typography', 'themewar' ),
                        'condition' => ['box_style' => '5'],
                        'selector'  => '{{WRAPPER}} .ib5_inner p',
                ]
        );
        $this->add_control(
            'box_5_desc_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '5'],
                    'selectors'     => [
                            '{{WRAPPER}} .ib5_inner p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_25', [
                    'label'         => esc_html__('Read More Label Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '5']
                ]
        );
        $this->add_control(
                'box_5_read_color',
                [
                        'label'     => esc_html__( 'Label Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .ib5_inner > a' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_control(
                'box_5_read_hover_color',
                [
                        'label'     => esc_html__( 'Hover Label Color', 'themewar' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .ib5_inner > a:hover' => 'color: {{VALUE}}',
                        ],
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'box_5_read_typography',
                        'label'     => esc_html__( 'Label Typography', 'themewar' ),
                        'condition' => ['box_style' => '5'],
                        'selector'  => '{{WRAPPER}} .ib5_inner > a',
                ]
        );
        $this->add_control(
            'box_5_read_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'condition'     => ['box_style' => '5'],
                    'selectors'     => [
                            '{{WRAPPER}} .ib5_inner > a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_30', [
                    'label'         => esc_html__('Box Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '6']
                ]
        );
        $this->add_control(
            'box_6_width',
            [
                    'label' => __( 'Box Width', 'themewar' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                            'px' => [
                                    'min' => 0,
                                    'max' => 500,
                                    'step' => 1,
                            ],
                            '%' => [
                                    'min' => 0,
                                    'max' => 100,
                            ],
                    ],
                    'default' => [],
                    'selectors' => [
                            '{{WRAPPER}} .icon_box_04' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_control(
                    'box_6_height',
                    [
                            'label' => __( 'Box Height', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 500,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .icon_box_04' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_control(
                'box_6_border_radius',
                [
                        'label'      => esc_html__( 'Border Radius', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .icon_box_04' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
        $this->start_controls_tabs( 'style_tabs_20' );
            $this->start_controls_tab(
                    'style_30_normal_tab',
                    [
                            'label'         => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name'      => 'box_6_Background',
                            'label'     => esc_html__( 'BG Color', 'themewar' ),
                            'types'     => [ 'classic', 'gradient', 'video' ],
                            'selector'  => '{{WRAPPER}} .icon_box_04',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name'      => 'box_6_shadow',
                            'label'     => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .icon_box_04',
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'style_31_hover_tab',
                    [
                            'label'     => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name'      => 'hover_6_Background',
                            'label'     => esc_html__( 'BG Hover Color', 'themewar' ),
                            'types'     => [ 'classic', 'gradient', 'video' ],
                            'selector'  => '{{WRAPPER}} .icon_box_04:hover',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name'      => 'hover_box_6_shadow',
                            'label'     => esc_html__( 'Hover Box Shadow', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .icon_box_04:hover',
                    ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
            'box_6_padding',
            [
                    'label'         => esc_html__( 'Paddings', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_04' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->add_control(
            'box_6_margin',
            [
                    'label'         => esc_html__( 'Paddings', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_04' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_33', [
                    'label'         => esc_html__('Icon Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'icon_box_6_typography',
                        'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .icon_box_04 i',
                ]
        );
        $this->start_controls_tabs( 'style_tabs_22' );
            $this->start_controls_tab(
                    'style_34_normal_tab',
                    [
                            'label'         => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_control(
                    'box_6_icon_color',
                    [
                            'label'     => esc_html__( 'Icon Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .icon_box_04 i' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'style_35_hover_tab',
                    [
                            'label'     => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_control(
                    'box_6_icon_hover_color',
                    [
                            'label'     => esc_html__( 'Icon Hover Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .icon_box_04:hover i' => 'color: {{VALUE}}',
                            ],
                    ]
            );
        $this->end_controls_tabs();
        $this->add_control(
            'box_6_icon_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_04 i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_36', [
                    'label'         => esc_html__('Title Style', 'themewar'),
                    'tab'           => Controls_Manager::TAB_STYLE,
                    'condition'     => ['box_style' => '6']
                ]
        );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name'      => 'title_box_6_typography',
                        'label'     => esc_html__( 'Title Typography', 'themewar' ),
                        'selector'  => '{{WRAPPER}} .icon_box_04 h4',
                ]
        );
        $this->start_controls_tabs( 'style_tabs_26' );
            $this->start_controls_tab(
                    'style_37_normal_tab',
                    [
                            'label'         => esc_html__( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_control(
                    'box_6_title_color',
                    [
                            'label'     => esc_html__( 'Title Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .icon_box_04 h4' => 'color: {{VALUE}}',
                            ],
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'style_38_hover_tab',
                    [
                            'label'     => esc_html__( 'Hover', 'themewar' ),
                    ]
            );
            $this->add_control(
                    'box_6_title_hover_color',
                    [
                            'label'     => esc_html__( 'Title Hover Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .icon_box_04:hover h4' => 'color: {{VALUE}}',
                            ],
                    ]
            );
        $this->end_controls_tabs();
        $this->add_control(
            'box_6_title_margin',
            [
                    'label'         => esc_html__( 'Margins', 'themewar' ),
                    'type'          => Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'selectors'     => [
                            '{{WRAPPER}} .icon_box_04 h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ],
            ]
        );
        $this->end_controls_section();
        
    }
    
    protected function render() {
        $settings   = $this->get_settings();
        $box_style  = (isset($settings['box_style']) && $settings['box_style'] > 0) ? $settings['box_style'] : 0;
        $icons      = (isset($settings['icons']) && $settings['icons'] != '') ? $settings['icons'] : '';
        $bg_icon    = (isset($settings['bg_icon']) && $settings['bg_icon'] != '') ? $settings['bg_icon'] : '';
        $show_bar   = (isset($settings['show_bar'])) ? $settings['show_bar'] : '';
        $box_title  = (isset($settings['title']) && $settings['title'] != '') ? $settings['title'] : esc_html__('Box Title', 'themewar');
        $title_url  = (isset($settings['title_url']['url']) && $settings['title_url']['url'] != '') ? $settings['title_url']['url'] : '';
        $counter    = (isset($settings['counter']) && $settings['counter'] != '') ? $settings['counter'] : esc_html__('1', 'themewar');
        $suffix     = (isset($settings['suffix']) && $settings['suffix'] != '') ? $settings['suffix'] : esc_html__('M+', 'themewar');
        
        $box_desc   = (isset($settings['desc']) && $settings['desc'] != '') ? $settings['desc'] : '';
        $target     = $settings['title_url']['is_external'] ? ' target="_blank"' : '';
        $nofollow   = $settings['title_url']['nofollow'] ? ' rel="nofollow"' : '';
        
        $read_more   = (isset($settings['read_more']) && $settings['read_more'] != '') ? $settings['read_more'] : '';
        $read_url    = (isset($settings['read_url']['url']) && $settings['read_url']['url'] != '') ? $settings['read_url']['url'] : '';
        $read_more_2   = (isset($settings['read_more_2']) && $settings['read_more_2'] != '') ? $settings['read_more_2'] : '';
        $read_url_2    = (isset($settings['read_url_2']['url']) && $settings['read_url_2']['url'] != '') ? $settings['read_url_2']['url'] : '';
        $title_url_6   = (isset($settings['title_url_6']['url']) && $settings['title_url_6']['url'] != '') ? $settings['title_url_6']['url'] : '';
        
        $list_item    = (isset($settings['list_item']) && $settings['list_item'] != '') ? $settings['list_item'] : '';
        $title_url_3  = (isset($settings['title_url_3']['url']) && $settings['title_url_3']['url'] != '') ? $settings['title_url_3']['url'] : '';
        $list         = (isset($settings['list']) && !empty($settings['list'])) ? $settings['list'] : array();
        
        switch ($box_style) {
            case 1:
                require dirname(__FILE__).'/style/icon-box/style1.php';
                break;
            case 2:
                require dirname(__FILE__).'/style/icon-box/style2.php';
                break;
            case 3:
                require dirname(__FILE__).'/style/icon-box/style3.php';
                break;
            case 4:
                require dirname(__FILE__).'/style/icon-box/style4.php';
                break;
            case 5:
                require dirname(__FILE__).'/style/icon-box/style5.php';
                break;
            case 6:
                require dirname(__FILE__).'/style/icon-box/style6.php';
                break;
            default:
                ?>
                    <div class="alert alert-warning" role="alert">
                        <?php echo esc_html__('Please select Box style first.', 'themewar'); ?>
                    </div>
                <?php
                break;
        }
    }
    
    protected function _content_template() {

    }
    
    
}