<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Button_Widgets extends Widget_Base {
    public function get_name() {
        return 'tw-button';
    }

    public function get_title() {
        return esc_html__( 'Button', 'themewar' );
    }
    
    public function get_icon() {
        return 'eicon-button';
    }
    
    public function get_categories() {
        return [ 'industing-elements' ];
    }
    
    protected function _register_controls() {
        $this->start_controls_section(
                'section_tab', [
                    'label'     => esc_html__(' Button ', 'themewar')
                ]
        );
        $this->add_control(
                'button_style',
                [
                        'label'     => esc_html__( 'Button Style', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 0,
                        'options'   => [
                                0                  => esc_html__( 'Select Style', 'themewar' ),
                                1                  => esc_html__( 'Style 1', 'themewar' ),
                                2                  => esc_html__( 'Style 2', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'icons',
                [
                        'label'         => esc_html__( 'Button Icon', 'themewar' ),
                        'type'          => Controls_Manager::ICON,
                        'label_block'   => TRUE,
                        'condition'     => ['button_style' => '2']
                ]
        );
        $this->add_control(
               'btn_label', [
                    'label'             => esc_html__('Button Label', 'themewar'),
                    'type'              => Controls_Manager::TEXT,
                    'label_block'       => true,
                    'default'           => esc_html__('', 'themewar'),
                    'placeholder'       => esc_html__('Insert Button Label', 'themewar'),
                ]
        );
        $this->add_control(
                'btn_url', [
                    'label'             => esc_html__( 'URL', 'themewar' ),
                    'type'              => Controls_Manager::URL,
                    'input_type'        => 'url',
                    'placeholder'       => esc_html__( 'https://your-link.com', 'themewar' ),
                    'show_external'     => true,
                    'default'           => [
                            'url'            => '',
                            'is_external'    => true,
                            'nofollow'       => true,
                    ],
                ]
        );
        $this->add_responsive_control(
                'btn_align', [
                        'label'                     =>esc_html__( 'Button Alignment', 'themewar' ),
                        'type'                      => Controls_Manager::CHOOSE,
                        'options'                   => [
                                'left'		 => [
                                        'title'	 =>esc_html__( 'Left', 'themewar' ),
                                        'icon'	 => 'fa fa-align-left',
                                ],
                                'center'	 => [
                                        'title'	 =>esc_html__( 'Center', 'themewar' ),
                                        'icon'	 => 'fa fa-align-center',
                                ],
                                'right'		 => [
                                        'title'	 =>esc_html__( 'Right', 'themewar' ),
                                        'icon'	 => 'fa fa-align-right',
                                ]
                        ],
                        'default'                   => 'center',
                        'prefix_class'              => 'btn_align elementor%s-align-',
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_2',
            [
                'label'         => esc_html__('Button Style', 'themewar'),
                'tab'           => Controls_Manager::TAB_STYLE,
                'condition'     => ['button_style' => '1']
            ]
        );
        $this->start_controls_tabs( 'style_tabs_1' );
                $this->start_controls_tab(
                        'button_style_normal',
                        [
                                'label' => __( 'Normal', 'themewar' ),
                        ]
                );
                $this->add_control(
                        'btn_label_color',
                        [
                                'label' => esc_html__( 'Label Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .ind_btn' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_control(
                        'button_bg_1',
                        [
                                'label' => esc_html__( 'BG Color 01', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .ind_btn:before' => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_control(
                        'button_bg_2',
                        [
                                'label' => esc_html__( 'BG Color 02', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .ind_btn:after' => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'button_style_hover',
                        [
                                'label' => __( 'Hover', 'themewar' ),
                        ]
                );
                $this->add_control(
                        'btn_label_hover_color',
                        [
                                'label' => esc_html__( 'Label Hover Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .ind_btn:hover' => 'color: {{VALUE}}'
                                ],
                        ]
                );
                $this->add_control(
                        'button_bg_hover_1',
                        [
                                'label' => esc_html__( 'BG Hover Color 01', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .ind_btn:hover:before' => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_control(
                        'button_bg_hover_2',
                        [
                                'label' => esc_html__( 'BG Color 02', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .ind_btn:hover:after' => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_control(
                    'btn_1_width',
                    [
                            'label' => __( 'Width', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 1000,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .ind_btn' => 'width: {{SIZE}}{{UNIT}};'
                            ],
                    ]
            );
            $this->add_control(
                    'btn_1_height',
                    [
                            'label' => __( 'Height', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 200,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .ind_btn' => 'height: {{SIZE}}{{UNIT}};'
                            ],
                    ]
            );
            $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                            'name' => 'button_1_typography',
                            'label' => esc_html__( 'Button Typography', 'themewar' ),
                            'selector' => '{{WRAPPER}} .ind_btn',
                    ]
            );
            $this->add_control(
                'button_1_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .ind_btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ],
                ]
            );
            $this->add_control(
                'button_1_margin',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .ind_btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ],
                ]
            );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_3',
            [
                'label'     => esc_html__('Button Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
                'condition'     => ['button_style' => '2']
            ]
        );
        $this->start_controls_tabs( 'style_tabs_2' );
                $this->start_controls_tab(
                        'button_style_2_normal',
                        [
                                'label' => __( 'Normal', 'themewar' ),
                        ]
                );
                $this->add_control(
                        'btn_label_2_color',
                        [
                                'label' => esc_html__( 'Label Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .ind_btn_icon' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_control(
                        'button_2_bg',
                        [
                                'label' => esc_html__( 'BG Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .ind_btn_icon' => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'button_2_style_hover',
                        [
                                'label' => __( 'Hover', 'themewar' ),
                        ]
                );
                $this->add_control(
                        'btn_2_label_hover_color',
                        [
                                'label' => esc_html__( 'Label Hover Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .ind_btn_icon:hover' => 'color: {{VALUE}}'
                                ],
                        ]
                );
                $this->add_control(
                        'button_2_bg_hover',
                        [
                                'label' => esc_html__( 'BG Hover Color 01', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .ind_btn_icon:after' => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_control(
			'btn_2_width',
			[
				'label' => __( 'Width', 'themewar' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [],
				'selectors' => [
					'{{WRAPPER}} .ind_btn_icon' => 'width: {{SIZE}}{{UNIT}};'
				],
			]
		);
            $this->add_control(
			'btn_2_height',
			[
				'label' => __( 'Height', 'themewar' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [],
				'selectors' => [
					'{{WRAPPER}} .ind_btn_icon' => 'height: {{SIZE}}{{UNIT}};'
				],
			]
		);
            $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                            'name' => 'button_2_typography',
                            'label' => esc_html__( 'Button Typography', 'themewar' ),
                            'selector' => '{{WRAPPER}} .ind_btn_icon',
                    ]
            );
            $this->add_control(
                'button_2_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .ind_btn_icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ],
                ]
            );
            $this->add_control(
                'button_2_margin',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .ind_btn_icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                        ],
                ]
            );
        $this->end_controls_section();
        
    }
    
    protected function render() {
        $settings       = $this->get_settings();
        $button_style   = (isset($settings['button_style']) && $settings['button_style'] > 0) ? $settings['button_style'] : 0;
        $icons          = (isset($settings['icons']) && $settings['icons'] != '') ? $settings['icons'] : '';
        $btn_label      = (isset($settings['btn_label']) && $settings['btn_label'] != '') ? $settings['btn_label'] : '';
        $target         = $settings['btn_url']['is_external'] ? ' target="_blank"' : '' ;
        $nofollow       = $settings['btn_url']['nofollow'] ? ' rel="nofollow"' : '' ;
        $btn_url        = (isset($settings['btn_url']['url']) && $settings['btn_url']['url'] != '') ? $settings['btn_url']['url'] : '#';
        
        switch ($button_style){
            case 1:
                if($btn_label != ''): ?>
                    <a href="<?php echo esc_url($btn_url) ?>" <?php echo $target; ?> <?php echo $nofollow; ?> class="ind_btn"><span><?php echo esc_html($btn_label); ?></span></a>
                <?php endif;
                break;
            case 2:
                if($btn_label != ''): ?>
                    <a href="<?php echo esc_url($btn_url) ?>" <?php echo $target; ?> <?php echo $nofollow; ?> class="ind_btn_icon">
                        <span>
                            <?php if ($icons != ''): ?>
                                <i class="<?php echo esc_attr($icons); ?>"></i>
                            <?php endif; ?>
                            <?php echo esc_html($btn_label); ?>
                        </span>
                    </a>
                <?php endif;
                break;
            default:
                ?>
                    <div class="alert alert-warning" role="alert">
                        <?php echo esc_html__('Please select Button style first.', 'themewar'); ?>
                    </div>
                <?php
                break;
        }
    }
    
    protected function _content_template() {
        
    }
            
}