<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Skill_Bar_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-skill-bar';
    }
    
    public function get_title() {
        return esc_html__( 'Skill Bar', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-skill-bar';
    }

    public function get_categories() {
        return [ 'industing-elements' ];
    }
    
    protected function _register_controls() {
        $this->start_controls_section(
            'section_tab', [
                'label' =>esc_html__( 'Skill Bar', 'themewar' ),
            ]
        );
            $this->add_control(
                    'skill_title',
                    [
                            'label'         => esc_html__( 'Skill Title', 'themewar' ),
                            'type'          => Controls_Manager::TEXT,
                            'default'       => '',
                            'label_block'   => true,
                            'placeholder'   => esc_html__('Skill Title', 'themewar')
                    ]
            );
            $this->add_control(
                    'percent',
                    [
                            'label'         => esc_html__( 'Precent', 'themewar' ),
                            'type'          => Controls_Manager::NUMBER,
                            'default'       => '',
                            'placeholder'   => esc_html__('Precent', 'themewar')
                    ]
            );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_1',[
                    'label'     => esc_html__('Skill Style', 'themewar'),
                    'tab'       => Controls_Manager::TAB_STYLE
                ]
        );
        $this->add_control(
                    'skill_margin',
                    [
                            'label' => esc_html__( 'Margins', 'themewar' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                    '{{WRAPPER}} .singleSkill' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
                'section_tab_2',[
                    'label'     => esc_html__('Skill Title Style', 'themewar'),
                    'tab'       => Controls_Manager::TAB_STYLE
                ]
        );
        $this->add_control(
                    'title_color',[
                            'label' => esc_html__( 'Title Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .singleSkill > span' => 'color: {{VALUE}}',
                            ],
                    ]
          );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'title_typography',
                        'label' => esc_html__( 'Title Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .singleSkill > span',
                ]
        );
        $this->add_control(
                    'title_margin',
                    [
                            'label' => esc_html__( 'Margins', 'themewar' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                    '{{WRAPPER}} .singleSkill > span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                    ]
            );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_3',[
                    'label'     => esc_html__('Skill Percent Style', 'themewar'),
                    'tab'       => Controls_Manager::TAB_STYLE
                ]
        );
        $this->add_control(
                    'percent_color',[
                            'label' => esc_html__( 'Percent Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                    '{{WRAPPER}} .skillBG span' => 'color: {{VALUE}}',
                            ],
                    ]
          );
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'percent_typography',
                        'label' => esc_html__( 'Percent Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .skillBG span',
                ]
        );
        $this->add_control(
                'percent_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .skillBG span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'percent_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .skillBG span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_4',[
                    'label'     => esc_html__('Skill Bar Style', 'themewar'),
                    'tab'       => Controls_Manager::TAB_STYLE
                ]
        );
        $this->add_control(
                'skill_bar_bg',
                [
                        'label'         => esc_html__( 'Background Color', 'themewar' ),
                        'type'          => Controls_Manager::COLOR,
                        'label_block'   => true,
                        'selectors'     => [
                                '{{WRAPPER}} .skillBG' => 'background: {{VALUE}}',
                        ],
                ]
        );
        $this->add_control(
                'skill_foreground_bg',
                [
                        'label'         => esc_html__( 'Foreground Color', 'themewar' ),
                        'type'          => Controls_Manager::COLOR,
                        'label_block'   => true,
                        'selectors'     => [
                                '{{WRAPPER}} .skill' => 'background: {{VALUE}}'
                        ],
                ]
        );
        $this->add_control(
            'width',
            [
                    'label' => __( 'Skill Bar Width', 'themewar' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                            'px' => [
                                    'min' => 0,
                                    'max' => 500,
                                    'step' => 1,
                            ],
                            '%' => [
                                    'min' => 0,
                                    'max' => 100,
                            ],
                    ],
                    'default' => [],
                    'selectors' => [
                            '{{WRAPPER}} .skillBG' => 'width: {{SIZE}}{{UNIT}};',
                    ],
            ]
        );
        $this->add_control(
                'height',
                [
                        'label' => __( 'Skill Bar Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .skillBG' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
    }
    
    protected function render() {
    $settings       = $this->get_settings_for_display();
    $skill_title    = (isset($settings['skill_title']) && $settings['skill_title'] != '') ? $settings['skill_title'] : ' ';
    $percent        = (isset($settings['percent']) && $settings['percent'] != '') ? $settings['percent'] : '80';
            ?>
            <div class="singleSkill" data-parcent="<?php echo esc_attr($percent); ?>">
                <?php if($skill_title != ''): ?>
                    <span><?php echo esc_html($skill_title); ?></span>
                <?php endif; ?>
                <div class="skillBG">
                    <?php if($percent != ''): ?>
                        <div class="skill"><span class="prc"><?php echo esc_html__($percent. '%', 'themewar'); ?></span></div>
                    <?php endif; ?>
                </div>
            </div>
            <?php
    }
    
    protected function _content_template() {

    }
}