<?php
if ( ! defined( 'ABSPATH' ) ) die( 'Direct access forbidden.' );

class Tw_About_Widgets extends WP_Widget{
    function __construct() {
        $widget_opt = array(
            'classname'     => 'industing_about_widget',
            'description'   => 'Industing About Widget'
        );
        
        parent::__construct('industing_about_widget', esc_html__('Industing About', 'themewar'), $widget_opt);
    }
    
    function widget( $args, $instance ){
        echo $args['before_widget'];
        
        $logos = (isset($instance['logos']) && $instance['logos'] != '') ? $instance['logos'] : '';
        $descs = (isset($instance['descs']) && $instance['descs'] != '') ? $instance['descs'] : '';
        
        $is_phone_or_soc = (isset($instance['is_phone_or_soc']) && $instance['is_phone_or_soc'] != '') ? $instance['is_phone_or_soc'] : 1;
        
        $hot_label = (isset($instance['hot_label'])) ? $instance['hot_label'] : '';
        $hot_number = (isset($instance['hot_number'])) ? $instance['hot_number'] : '';
        
        $fac3 = (isset($instance['fac3'])) ? $instance['fac3'] : '';
        $twi3 = (isset($instance['twi3'])) ? $instance['twi3'] : '';
        $you3 = (isset($instance['you3'])) ? $instance['you3'] : '';
        $lin3 = (isset($instance['lin3'])) ? $instance['lin3'] : '';
        $dri3 = (isset($instance['dri3'])) ? $instance['dri3'] : '';
        $beh3 = (isset($instance['beh3'])) ? $instance['beh3'] : '';
        $ins3 = (isset($instance['ins3'])) ? $instance['ins3'] : '';
        
        ?>
        <?php if($is_phone_or_soc == 2): ?>
            <div class="about_widget_2">
                <?php if($logos != ''): ?>
                    <a href="<?php echo esc_url(home_url('/')); ?>">
                        <img src="<?php echo esc_url($logos); ?>" alt="<?php bloginfo('name'); ?>">
                    </a>
                <?php endif; ?>
                <p>
                    <?php echo wp_kses_post($descs); ?>
                </p>
                <div class="fo_social">
                    <?php if($fac3 != ''): ?>
                    <a href="<?php echo esc_url($fac3); ?>"><i class="twi-facebook-f"></i></a>
                    <?php endif; ?>
                    <?php if($twi3 != ''): ?>
                    <a href="<?php echo esc_url($twi3); ?>"><i class="twi-twitter"></i></a>
                    <?php endif; ?>
                    <?php if($you3 != ''): ?>
                    <a href="<?php echo esc_url($you3); ?>"><i class="twi-youtube"></i></a>
                    <?php endif; ?>
                    <?php if($lin3 != ''): ?>
                    <a href="<?php echo esc_url($lin3); ?>"><i class="twi-linkedin"></i></a>
                    <?php endif; ?>
                    <?php if($dri3 != ''): ?>
                    <a href="<?php echo esc_url($dri3); ?>"><i class="twi-dribbble"></i></a>
                    <?php endif; ?>
                    <?php if($beh3 != ''): ?>
                    <a href="<?php echo esc_url($beh3); ?>"><i class="twi-behance"></i></a>
                    <?php endif; ?>
                    <?php if($ins3 != ''): ?>
                    <a href="<?php echo esc_url($ins3); ?>"><i class="twi-instagram"></i></a>
                    <?php endif; ?>
                </div>
            </div>
        <?php else: ?>
            <div class="about_widget">
                <?php if($logos != ''): ?>
                <a href="<?php echo esc_url(home_url('/')); ?>">
                    <img src="<?php echo esc_url($logos); ?>" alt="<?php bloginfo('name'); ?>">
                </a>
                <?php endif; ?>
                <p>
                    <?php echo wp_kses_post($descs); ?>
                </p>
                <?php if($hot_label != '' && $hot_number != ''): ?>
                <div class="caller">
                    <i class="twi-headphones2"></i>
                    <?php if($hot_label != ''): ?>
                    <span><?php echo esc_html($hot_label); ?></span>
                    <?php endif; ?>
                    <?php if($hot_number != ''): ?>
                    <h3><?php echo esc_html($hot_number); ?></h3>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        
        <?php
        echo $args['after_widget'];
    }
    
    function update ( $new_instance, $old_instance) {
        return $new_instance;
    }
    
    function form($instance){
        $logos = (isset($instance['logos']) && $instance['logos'] != '') ? $instance['logos'] : '';
        $descs = (isset($instance['descs']) && $instance['descs'] != '') ? $instance['descs'] : '';
        
        $is_phone_or_soc = (isset($instance['is_phone_or_soc']) && $instance['is_phone_or_soc'] != '') ? $instance['is_phone_or_soc'] : 1;
        
        $hot_label = (isset($instance['hot_label'])) ? $instance['hot_label'] : '';
        $hot_number = (isset($instance['hot_number'])) ? $instance['hot_number'] : '';
        
        $fac3 = (isset($instance['fac3'])) ? $instance['fac3'] : '';
        $twi3 = (isset($instance['twi3'])) ? $instance['twi3'] : '';
        $you3 = (isset($instance['you3'])) ? $instance['you3'] : '';
        $lin3 = (isset($instance['lin3'])) ? $instance['lin3'] : '';
        $dri3 = (isset($instance['dri3'])) ? $instance['dri3'] : '';
        $beh3 = (isset($instance['beh3'])) ? $instance['beh3'] : '';
        $ins3 = (isset($instance['ins3'])) ? $instance['ins3'] : '';
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'logos' )); ?>"><?php esc_html_e( 'Logo:', 'themewar' ); ?></label>
            <input class="widefat logourls" id="<?php echo esc_attr($this->get_field_id( 'logos' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'logos' )); ?>" type="text" value="<?php echo esc_attr( $logos ); ?>" /><br/>
            <a href="javascript:void(0);" class="fl_uplogos button">Upload</a>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'descs' )); ?>"><?php esc_html_e( 'Description:', 'themewar' ); ?></label>
            <textarea class="widefat" rows="10" id="<?php echo esc_attr($this->get_field_id( 'descs' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'descs' )); ?>"><?php echo esc_attr( $descs ); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'is_phone_or_soc' )); ?>"><?php _e( 'Phone or Social:' , 'themewar' ); ?></label>
            <select class="widefat is_phone_or_soc" id="<?php echo esc_attr($this->get_field_id( 'is_phone_or_soc' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'is_phone_or_soc' )); ?>">
                <option value="1" <?php if($is_phone_or_soc == 1){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Phone', 'themewar'); ?></option>
                <option value="2" <?php if($is_phone_or_soc == 2){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Social', 'themewar'); ?></option>
            </select>
	</p>
        <div class="phone_properties" style="<?php if($is_phone_or_soc != 1){ echo 'display: none;'; } ?>">
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'hot_label' )); ?>"><?php _e( 'Label:' , 'themewar' ); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'hot_label' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'hot_label' )); ?>" type="text" value="<?php echo esc_attr( $hot_label ); ?>" />
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'hot_number' )); ?>"><?php _e( 'Number:' , 'themewar' ); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'hot_number' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'hot_number' )); ?>" type="text" value="<?php echo esc_attr( $hot_number ); ?>" />
            </p>
        </div>
        <div class="all_socials" style="<?php if($is_phone_or_soc != 2){ echo 'display: none;'; } ?>">
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'fac3' )); ?>"><?php _e( 'Facebook:' , 'themewar' ); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'fac3' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'fac3' )); ?>" type="text" value="<?php echo esc_attr( $fac3 ); ?>" />
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'twi3' )); ?>"><?php _e( 'Twitter:' , 'themewar' ); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'twi3' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'twi3' )); ?>" type="text" value="<?php echo esc_attr( $twi3 ); ?>" />
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'you3' )); ?>"><?php _e( 'Youtube:' , 'themewar' ); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'you3' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'you3' )); ?>" type="text" value="<?php echo esc_attr( $you3 ); ?>" />
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'lin3' )); ?>"><?php _e( 'Linkedin:' , 'themewar' ); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'lin3' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'lin3' )); ?>" type="text" value="<?php echo esc_attr( $lin3 ); ?>" />
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'dri3' )); ?>"><?php _e( 'Dribbble:' , 'themewar' ); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'dri3' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'dri3' )); ?>" type="text" value="<?php echo esc_attr( $dri3 ); ?>" />
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'beh3' )); ?>"><?php _e( 'Behance:' , 'themewar' ); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'beh3' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'beh3' )); ?>" type="text" value="<?php echo esc_attr( $beh3 ); ?>" />
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'ins3' )); ?>"><?php _e( 'Instagram:' , 'themewar' ); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'ins3' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'ins3' )); ?>" type="text" value="<?php echo esc_attr( $ins3 ); ?>" />
            </p>
        </div>
        <?php
    }
}