<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

class Tw_Helpinfo_Widgets extends WP_Widget{
    function __construct() 
    {
        $widget_opt = array(
            'classname'     => 'havqueswidget',
            'description'   => 'Industing Have Any Questions Widgets.'
        );
        
        parent::__construct('industinghelpinfo', esc_html__('Industing Have Any Questions.', 'themewar'), $widget_opt);
    }
    
    function widget( $args, $instance ){
        $title = (isset($instance['title']) && $instance['title'] != '') ? $instance['title'] : esc_html__('Have Any Questions?', 'themewar');
        $help_desc = (isset($instance['help_desc']) && $instance['help_desc'] != '') ? $instance['help_desc'] : '';
        $phonenumbers = (isset($instance['phonenumbers']) && $instance['phonenumbers'] != '') ? $instance['phonenumbers'] : '';
        $email = (isset($instance['email']) && $instance['email'] != '') ? $instance['email'] : '';
        
        echo wp_kses_post($args['before_widget']);
        ?>
        <?php if($title != ''): ?>
            <h3 class="widget_title"><?php echo wp_kses_post($title); ?></h3>
        <?php endif; ?>
        <div class="hqw_content">
            <?php if($help_desc != ''): ?>
                <p><?php echo wp_kses_post($help_desc); ?></p>
            <?php endif; ?>
            <?php if($phonenumbers != ''): ?>
                <h5><?php echo wp_kses_post($phonenumbers); ?></h5>
            <?php endif; ?>
            <?php if($email != ''): ?>
                <h5><?php echo wp_kses_post($email); ?></h5>
            <?php endif; ?>
        </div>
        <?php
        echo wp_kses_post($args['after_widget']);
    }
    
    function update ( $new_instance, $old_instance ) {
        return $new_instance;
    }
    
    function form($instance){
        $title          = (isset($instance['title']) && $instance['title'] != '') ? $instance['title'] : esc_html__('Have Any Questions?', 'themewar');
        $help_desc      = (isset($instance['help_desc']) && $instance['help_desc'] != '') ? $instance['help_desc'] : '';
        $phonenumbers   = (isset($instance['phonenumbers']) && $instance['phonenumbers'] != '') ? $instance['phonenumbers'] : '';
        $email          = (isset($instance['email']) && $instance['email'] != '') ? $instance['email'] : '';
        ?>
        <p>
	<label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php _e( 'Title:', 'themewar' ); ?></label>
	<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
	</p>
        <p>
	<label for="<?php echo esc_attr($this->get_field_id( 'help_desc' )); ?>"><?php _e( 'Description:', 'themewar' ); ?></label>
        <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id( 'help_desc' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'help_desc' )); ?>"><?php echo esc_attr( $help_desc ); ?></textarea>
	</p>
        <p>
	<label for="<?php echo esc_attr($this->get_field_id( 'phonenumbers' )); ?>"><?php _e( 'Help Line Number:', 'themewar' ); ?></label>
	<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'phonenumbers' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'phonenumbers' )); ?>" type="text" value="<?php echo esc_attr( $phonenumbers ); ?>" />
	</p>
        <p>
	<label for="<?php echo esc_attr($this->get_field_id( 'email' )); ?>"><?php _e( 'Email Us:', 'themewar' ); ?></label>
	<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'email' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'email' )); ?>" type="text" value="<?php echo esc_attr( $email ); ?>" />
	</p>
        <?php
    }
}