<?php
/**
 * Creates widget with recent post thumbnail
 */

class Tw_Recentpost_Widgets extends WP_Widget
{
    function __construct() 
    {
        $widget_opt = array(
            'classname'     => 'industing_rp_widget',
            'description'   => 'Industing Recent Post With Thumbnail'
        );
        
        parent::__construct('industing-rppwt', esc_html__('Industing Recent Post', 'themewar'), $widget_opt);
    }
    
    function widget( $args, $instance )
    {
        $title = (isset($instance['title']) && $instance['title'] != '') ? $instance['title'] : esc_html__( 'Recent Posts', 'themewar' );
        $post_type = (isset($instance['post_type']) && $instance['post_type'] != '') ? $instance['post_type'] : 'post';
        $view_style = (isset($instance['view_style']) && $instance['view_style'] != '') ? $instance['view_style'] : 1;
        $number_of_posts1 = (isset($instance['number_of_posts1']) && $instance['number_of_posts1'] != '') ? $instance['number_of_posts1'] : 3;
        $ord_by = (isset($instance['ord_by']) && $instance['ord_by'] != '') ? $instance['ord_by'] : 'date';
        $ord = (isset($instance['ord']) && $instance['ord'] != '') ? $instance['ord'] : 'DESC';
        
        
        $title = apply_filters( 'widget_title', $title );
        echo wp_kses_post($args['before_widget']);
        if ( ! empty( $title ) )
        {
            echo wp_kses_post($args['before_title']) . esc_html($title) . $args['after_title'];
        }
        
        
        $stickies = get_option( 'sticky_posts' );
        $querys = array(
            'post_type'         => array($post_type),
            'post_status'       => array('publish'),
            'orderby'           => $ord_by,
            'order'             => $ord,
            'posts_per_page'    => $number_of_posts1,
            'post__not_in'      => $stickies
        );
        $tw_query = new WP_Query($querys);
        
        if($tw_query->have_posts())
        {
            if($view_style == 2):
                echo '<div class="recentServices">';
                    while($tw_query->have_posts()): $tw_query->the_post();
                    ?>
                        <div class="serviceItem clearfix">
                            <?php if(has_post_thumbnail()): ?>
                                <?php echo get_the_post_thumbnail(get_the_ID(), 'industing-wid', array('class' => 'float-left')); ?>
                            <?php else: ?>
                                <img class="float-left" src="http://via.placeholder.com/80x70" alt="">
                            <?php endif; ?>
                            <h5><a href="<?php echo get_the_permalink(); ?>"><?php echo substr(wp_kses(get_the_title(), array()), 0, 45) ?></a></h5>
                            <span><?php echo get_the_time('d F, Y'); ?></span>
                        </div>
                    <?php
                    endwhile;
                echo '</div>';
            elseif($view_style == 3):
                echo '<div class="newsFeeds">';
                    while($tw_query->have_posts()): $tw_query->the_post();
                    ?>
                        <div class="newsfeed clearfix">
                            <p><i class="twi-calendar-alt2"></i><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_time('jS M Y'); ?></a></p>
                            <h4><a href="<?php echo get_the_permalink(); ?>"><?php echo substr(wp_kses(get_the_title(), array()), 0, 50).'...' ?></a></h4>
                        </div>
                    <?php
                    endwhile;
                echo '</div>';
            else:
                echo '<div class="allfeeds">';
                    while($tw_query->have_posts()): $tw_query->the_post();
                    ?>
                        <div class="singlefeeds clearfix">
                            <?php if(has_post_thumbnail()): ?>
                                <?php echo get_the_post_thumbnail(get_the_ID(), 'industing-wid'); ?>
                            <?php else: ?>
                                <img class="float-left" src="http://via.placeholder.com/80x70" alt="">
                            <?php endif; ?>
                            <h6><a href="<?php echo get_the_permalink(); ?>"><?php echo substr(wp_kses(get_the_title(), array()), 0, 45) ?></a></h6>
                            <span><i class="twi-clock2"></i><?php echo esc_html( human_time_diff( get_the_time('U'), current_time('timestamp') ) ) . ' ago'; ?></span>
                        </div>
                    <?php
                    endwhile;
                echo '</div>';
            endif;
        }
        wp_reset_postdata();
        
        echo wp_kses_post($args['after_widget']);
    }
    
    
    function update ( $new_instance, $old_instance ) 
    {
        return $new_instance;
    }
    
    function form($instance)
    {
        $title = (isset($instance['title']) && $instance['title'] != '') ? $instance['title'] : esc_html__( 'Recent Posts', 'themewar' );
        $tw_post_types = (isset($instance['tw_post_types']) && $instance['tw_post_types'] != '') ? $instance['tw_post_types'] : 'post';
        $view_style = (isset($instance['view_style']) && $instance['view_style'] != '') ? $instance['view_style'] : 1;
        $number_of_posts1 = (isset($instance['number_of_posts1']) && $instance['number_of_posts1'] != '') ? $instance['number_of_posts1'] : 3;
        $ord_by = (isset($instance['ord_by']) && $instance['ord_by'] != '') ? $instance['ord_by'] : 'date';
        $ord = (isset($instance['ord']) && $instance['ord'] != '') ? $instance['ord'] : 'DESC';
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php _e( 'Title:', 'themewar' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'tw_post_types' )); ?>"><?php _e( 'Post Type:' , 'themewar' ); ?></label>
            <select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'tw_post_types' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'tw_post_types' )); ?>">
                <option value="post" <?php if($tw_post_types == 'post'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Blog Post', 'themewar'); ?></option>
                <option value="tw-service" <?php if($tw_post_types == 'tw-service'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Services', 'themewar'); ?></option>
                <option value="folio" <?php if($tw_post_types == 'folio'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Portfolios', 'themewar'); ?></option>
            </select>
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'view_style' )); ?>"><?php _e( 'Style:' , 'themewar' ); ?></label>
            <select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'view_style' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'view_style' )); ?>">
                <option value="1" <?php if($view_style == 1){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Style 01', 'themewar'); ?></option>
                <option value="2" <?php if($view_style == 2){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Style 02', 'themewar'); ?></option>
                <option value="3" <?php if($view_style == 3){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Style 03', 'themewar'); ?></option>
            </select>
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'number_of_posts1' )); ?>"><?php _e( 'Number Of Posts:' , 'themewar' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'number_of_posts1' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'number_of_posts1' )); ?>" type="number" value="<?php echo esc_attr( $number_of_posts1 ); ?>" />
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'ord_by' )); ?>"><?php _e( 'Order By:' , 'themewar' ); ?></label>
            <select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'ord_by' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'ord_by' )); ?>">
                <option value="date" <?php if($ord_by == 'date'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Date', 'themewar'); ?></option>
                <option value="ID" <?php if($ord_by == 'ID'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('ID', 'themewar'); ?></option>
                <option value="title" <?php if($ord_by == 'title'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Title', 'themewar'); ?></option>
                <option value="rand" <?php if($ord_by == 'rand'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Random', 'themewar'); ?></option>
                <option value="comment_count" <?php if($ord_by == 'comment_count'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('Comment Count', 'themewar'); ?></option>
            </select>
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'ord' )); ?>"><?php _e( 'Order:' , 'themewar' ); ?></label>
            <select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'ord' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'ord' )); ?>">
                <option value="ASC" <?php if($ord == 'ASC'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('ASC', 'themewar'); ?></option>
                <option value="DESC" <?php if($ord == 'DESC'){ echo 'selected="selected"'; } ?>><?php echo esc_html__('DESC', 'themewar'); ?></option>
            </select>
	</p>
        
        <?php
    }
}