<?php
/**
 * Creates widget with recent post thumbnail
 */

class Tw_Social_Widgets extends WP_Widget
{
    function __construct() 
    {
        $widget_opt = array(
            'classname'     => 'industing_social_widget',
            'description'   => 'Industing Social Widgets'
        );
        
        parent::__construct('industing-social', esc_html__('Industing Social Widget', 'themewar'), $widget_opt);
    }
    
    function widget( $args, $instance )
    {
        $fac = (isset($instance['fac'])) ? $instance['fac'] : '';
        $twi = (isset($instance['twi'])) ? $instance['twi'] : '';
        $you = (isset($instance['you'])) ? $instance['you'] : '';
        $lin = (isset($instance['lin'])) ? $instance['lin'] : '';
        $dri = (isset($instance['dri'])) ? $instance['dri'] : '';
        $beh = (isset($instance['beh'])) ? $instance['beh'] : '';
        $pin = (isset($instance['pin'])) ? $instance['pin'] : '';
        $wor = (isset($instance['wor'])) ? $instance['wor'] : '';
        $ins = (isset($instance['ins'])) ? $instance['ins'] : '';
        $vk  = (isset($instance['vk'])) ? $instance['vk'] : '';
        $tum = (isset($instance['tum'])) ? $instance['tum'] : '';
        $vim = (isset($instance['vim'])) ? $instance['vim'] : '';
        
        echo wp_kses_post($args['before_widget']);
        if ( !empty( $instance[ 'title' ] ) ) {
            echo wp_kses_post($args[ 'before_title' ]) . apply_filters( 'widget_title', $instance[ 'title' ] ) . $args[ 'after_title' ];
        }
        ?>
        <div class="socialLinks">
            <?php if($twi != ''): ?>
            <a href="<?php echo esc_url($twi) ?>"><i class="twi-twitter"></i></a>
            <?php endif; ?>
            <?php if($pin != ''): ?>
            <a href="<?php echo esc_url($pin) ?>"><i class="twi-pinterest-p"></i></a>
            <?php endif; ?>
            <?php if($fac != ''): ?>
            <a href="<?php echo esc_url($fac) ?>"><i class="twi-facebook-f"></i></a>
            <?php endif; ?>
            <?php if($ins != ''): ?>
            <a href="<?php echo esc_url($ins) ?>"><i class="twi-instagram"></i></a>
            <?php endif; ?>
            <?php if($wor != ''): ?>
            <a href="<?php echo esc_url($wor) ?>"><i class="twi-wordpress"></i></a>
            <?php endif; ?>
            <?php if($you != ''): ?>
            <a href="<?php echo esc_url($you) ?>"><i class="twi-youtube"></i></a>
            <?php endif; ?>
            <?php if($lin != ''): ?>
            <a href="<?php echo esc_url($lin) ?>"><i class="twi-linkedin-in"></i></a>
            <?php endif; ?>
            <?php if($dri != ''): ?>
            <a href="<?php echo esc_url($dri) ?>"><i class="twi-dribbble"></i></a>
            <?php endif; ?>
            <?php if($beh != ''): ?>
            <a href="<?php echo esc_url($beh) ?>"><i class="twi-behance"></i></a>
            <?php endif; ?>
            <?php if($vk != ''): ?>
            <a href="<?php echo esc_url($vk) ?>"><i class="twi-vk"></i></a>
            <?php endif; ?>
            <?php if($tum != ''): ?>
            <a href="<?php echo esc_url($tum) ?>"><i class="twi-tumblr"></i></a>
            <?php endif; ?>
            <?php if($vim != ''): ?>
            <a href="<?php echo esc_url($vim) ?>"><i class="twi-vimeo"></i></a>
            <?php endif; ?>
        </div>
        <?php
        echo wp_kses_post($args['after_widget']);
    }
    
    
    function update ( $new_instance, $old_instance ) 
    {
        return $new_instance;
    }
    
    function form($instance)
    {
        $title = (isset($instance['title'])) ? $instance['title'] : '';
        $fac = (isset($instance['fac'])) ? $instance['fac'] : '';
        $twi = (isset($instance['twi'])) ? $instance['twi'] : '';
        $you = (isset($instance['you'])) ? $instance['you'] : '';
        $lin = (isset($instance['lin'])) ? $instance['lin'] : '';
        $dri = (isset($instance['dri'])) ? $instance['dri'] : '';
        $beh = (isset($instance['beh'])) ? $instance['beh'] : '';
        $pin = (isset($instance['pin'])) ? $instance['pin'] : '';
        $wor = (isset($instance['wor'])) ? $instance['wor'] : '';
        $ins = (isset($instance['ins'])) ? $instance['ins'] : '';
        $vk = (isset($instance['vk'])) ? $instance['vk'] : '';
        $tum = (isset($instance['tum'])) ? $instance['tum'] : '';
        $vim = (isset($instance['vim'])) ? $instance['vim'] : '';
        
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php _e( 'Title:', 'themewar' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'fac' )); ?>"><?php _e( 'Facebook:' , 'themewar' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'fac' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'fac' )); ?>" type="text" value="<?php echo esc_attr( $fac ); ?>" />
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'twi' )); ?>"><?php _e( 'Twitter:' , 'themewar' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'twi' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'twi' )); ?>" type="text" value="<?php echo esc_attr( $twi ); ?>" />
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'you' )); ?>"><?php _e( 'Youtube:' , 'themewar' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'you' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'you' )); ?>" type="text" value="<?php echo esc_attr( $you ); ?>" />
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'lin' )); ?>"><?php _e( 'Linkedin:' , 'themewar' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'lin' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'lin' )); ?>" type="text" value="<?php echo esc_attr( $lin ); ?>" />
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'dri' )); ?>"><?php _e( 'Dribbble:' , 'themewar' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'dri' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'dri' )); ?>" type="text" value="<?php echo esc_attr( $dri ); ?>" />
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'beh' )); ?>"><?php _e( 'Behance:' , 'themewar' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'beh' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'beh' )); ?>" type="text" value="<?php echo esc_attr( $beh ); ?>" />
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'pin' )); ?>"><?php _e( 'Pinterest:' , 'themewar' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'pin' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'pin' )); ?>" type="text" value="<?php echo esc_attr( $pin ); ?>" />
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'ins' )); ?>"><?php _e( 'Instagram:' , 'themewar' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'ins' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'ins' )); ?>" type="text" value="<?php echo esc_attr( $ins ); ?>" />
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'wor' )); ?>"><?php _e( 'Wordpress:' , 'themewar' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'wor' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'wor' )); ?>" type="text" value="<?php echo esc_attr( $wor ); ?>" />
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'vk' )); ?>"><?php _e( 'VK:' , 'themewar' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'vk' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'vk' )); ?>" type="text" value="<?php echo esc_attr( $vk ); ?>" />
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'tum' )); ?>"><?php _e( 'Tumblr:' , 'themewar' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'tum' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'tum' )); ?>" type="text" value="<?php echo esc_attr( $tum ); ?>" />
	</p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'vim' )); ?>"><?php _e( 'Vimeo:' , 'themewar' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'vim' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'vim' )); ?>" type="text" value="<?php echo esc_attr( $vim ); ?>" />
	</p>
        
        <?php
    }
}