<?php
    $folio_single_gallery = get_theme_mod('folio_single_gallery', 1);
    $folio_gallery_images = fw_get_db_post_option(get_the_ID(), 'folio_gallery_images', array());
    $folio_cl_title = fw_get_db_post_option(get_the_ID(), 'folio_cl_title', '');
    $folio_cl_name = fw_get_db_post_option(get_the_ID(), 'folio_cl_name', '');
    $folio_website_title = fw_get_db_post_option(get_the_ID(), 'folio_website_title', '');
    $folio_website_url = fw_get_db_post_option(get_the_ID(), 'folio_website_url', '');
    $folio_is_category = fw_get_db_post_option(get_the_ID(), 'folio_is_category', 1);
    $folio_date_title = fw_get_db_post_option(get_the_ID(), 'folio_date_title', '');
    $folio_date = fw_get_db_post_option(get_the_ID(), 'folio_date', '');
    $folio_is_social = fw_get_db_post_option(get_the_ID(), 'folio_is_social', '');
    $folio_live_label = fw_get_db_post_option(get_the_ID(), 'folio_live_label', '');
    $folio_live_url = fw_get_db_post_option(get_the_ID(), 'folio_live_url', '');
    
    $category = '';
    $terms = get_the_terms(get_the_ID(), 'folio_cat');
    if (is_array($terms) && !empty($terms)):
        $p = 1;
        $c = count($terms);
        foreach ($terms as $term):
            if($p == $c):
                $category .= '<a  class="cate" href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>';
            else:
                $category .= '<a  class="cate" href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>, ';
            endif;
            $p++;
        endforeach;
    endif;
    
?>
<div class="col-lg-12 fwidth">
    <?php if($folio_single_gallery == 1): ?>
        <div class="fsSlider owl-carousel">
            <?php if(is_array($folio_gallery_images) && !empty($folio_gallery_images)):
                    foreach($folio_gallery_images as $fg):
                        $img = wp_get_attachment_image_src($fg['attachment_id'], 'industing-folio-4');
                        ?>
                        <div class="fgs">
                            <img src="<?php echo esc_url($img[0]) ?>" alt="<?php echo get_the_ID(); ?>">
                        </div>
                        <?php
                    endforeach;
                endif;
            ?>
            <?php if(has_post_thumbnail()): ?>
                <div class="fgs">
                    <?php echo get_the_post_thumbnail(get_the_ID(), 'industing-folio-4'); ?>
                </div>
            <?php endif; ?>
        </div>
    <?php elseif($folio_single_gallery == 2): ?>
        <div class="row folioGallery">
            <?php if(has_post_thumbnail()): ?>
                <div class="col-xl-6 col-md-6 mas_item">
                    <div class="fgs">
                        <?php echo get_the_post_thumbnail(get_the_ID(), 'full'); ?>
                    </div>
                </div>
            <?php endif; ?>
            <?php if(is_array($folio_gallery_images) && !empty($folio_gallery_images)):
                    foreach($folio_gallery_images as $fg):
                        $img = wp_get_attachment_image_src($fg['attachment_id'], 'full');
                        ?>
                        <div class="col-xl-6 col-md-6 mas_item">
                            <div class="fgs">
                                <img src="<?php echo esc_url($img[0]) ?>" alt="<?php echo get_the_ID(); ?>">
                            </div>
                        </div>
                        <?php
                    endforeach;
                endif;
            ?>
        </div>
    <?php else: ?>
            <?php if(has_post_thumbnail()): ?>
                <div class="fgs">
                    <?php echo get_the_post_thumbnail(get_the_ID(), 'industing-folio-4'); ?>
                </div>
            <?php endif; ?>
            <?php if(is_array($folio_gallery_images) && !empty($folio_gallery_images)):
                    foreach($folio_gallery_images as $fg):
                        $img = wp_get_attachment_image_src($fg['attachment_id'], 'industing-folio-4');
                        ?>
                        <div class="fgs">
                            <img src="<?php echo esc_url($img[0]) ?>" alt="<?php echo get_the_ID(); ?>">
                        </div>
                        <?php
                    endforeach;
                endif;
            ?>
    <?php endif; ?>
</div>
<div class="clearfix"></div>
<div class="col-lg-12">
    <div class="fmetasarea">
        <div class="row">
            <?php if($folio_cl_title != '' || $folio_cl_name != ''): ?>
            <div class="col-lg-3 col-sm-3">
                <p><strong><?php echo esc_html($folio_cl_title); ?></strong> <?php echo esc_html($folio_cl_name); ?></p>
            </div>
            <?php endif; ?>
            <?php if($folio_is_category == 1 && $category != ''): ?>
            <div class="col-lg-3 col-sm-3">
                <p><strong><?php echo esc_html__('Category:', 'industing') ?></strong> <?php echo wp_kses($category, industing_allowed_html()); ?></p>
            </div>
            <?php endif; ?>
            <?php if($folio_date_title != '' || $folio_date != ''): ?>
            <div class="col-lg-3 col-sm-3">
                <p><strong><?php echo esc_html($folio_date_title); ?></strong> <?php echo date('jS, F, Y', strtotime($folio_date)) ?></p>
            </div>
            <?php endif; ?>
            <?php if($folio_live_label != ''): ?>
            <div class="col-lg-3 col-sm-3 text-right">
                <a href="<?php echo esc_url($folio_live_url) ?>" class="ind_btn id_light"><span><?php echo esc_html($folio_live_label); ?></span></a>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<div class="clearfix"></div>
<div class="col-xl-10 offset-xl-1">
    <div class="fw_contents text-center">
        <h3><?php echo get_the_title(); ?></h3>
        <div class="sf_details">
            <?php the_content(); ?>
        </div>
    </div>
</div>