<?php
    $blog_banner_bg = get_theme_mod('blog_banner_bg', '');
    $blog_is_breadcrumb = get_theme_mod('blog_is_breadcrumb', 1);
    $blog_bread_title = get_theme_mod('blog_bread_title', esc_html__('Blog', 'industing'));
    $blog_banner_title = get_theme_mod('blog_banner_title', esc_html__('Blog Posts', 'industing'));
    
    $bgStyle = '';
    if($blog_banner_bg != ''){
        $bgStyle = 'background-image: url('.$blog_banner_bg.'); background-repeat: no-repeat; background-position: center center; background-size: cover;';
    }
    
    if(is_archive()){
        $blog_banner_title = get_the_archive_title();
        $blog_banner_title = str_replace('Year:', '', $blog_banner_title);
        $blog_banner_title = str_replace('Tag:', '', $blog_banner_title);
        $blog_banner_title = str_replace('Author:', '', $blog_banner_title);
        $blog_banner_title = str_replace('Category:', '', $blog_banner_title);
        $blog_banner_title = str_replace('Month:', '', $blog_banner_title);
        $blog_banner_title = str_replace('Day:', '', $blog_banner_title);
        
        $blog_bread_title = wp_strip_all_tags($blog_banner_title);
    }elseif(is_search()){
        $blog_banner_title = esc_html__('Search For: ', 'industing').get_search_query();
        
        $blog_bread_title = esc_html__('Search Result', 'industing');
    }
?>
<section class="page_banner" style="<?php echo esc_attr($bgStyle) ?>">
    <div class="container">
        <div class="row">
            <div class="col-xl-12 text-center">
                <h2><?php echo wp_kses($blog_banner_title, industing_allowed_html()) ?></h2>
                <div class="breadcrumbs">
                    <?php if ($blog_is_breadcrumb == 1): ?>
                        <a href="<?php echo esc_url(home_url('/')) ?>"><?php echo esc_html__('Home', 'industing') ?></a><i>|</i><span><?php echo esc_html($blog_bread_title); ?></span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>