<?php
global $post;
$single_banner_bg = get_theme_mod('single_banner_bg', '');
$single_is_breadcrumb = get_theme_mod('single_is_breadcrumb', 1);
$single_bread_title = get_theme_mod('single_bread_title', esc_html__('Blog', 'industing'));
$single_banner_title = get_theme_mod('single_banner_title', 'Our Blog');

$bgStyle = '';
if ($single_banner_bg != '') {
    $bgStyle = 'background-image: url(' . $single_banner_bg . '); background-repeat: no-repeat; background-position: center center; background-size: cover;';
}

if (defined('FW')) {
    $single_is_bread = fw_get_db_post_option(get_the_ID(), 'single_is_bread', 1);
    $bread_title = fw_get_db_post_option(get_the_ID(), 'bread_title', '');
    $header_title = fw_get_db_post_option(get_the_ID(), 'header_title', '');
    $header_image = fw_get_db_post_option(get_the_ID(), 'header_image', '');
    $header_image = (isset($header_image['url']) && $header_image['url'] != '') ? $header_image['url'] : '';

    $single_banner_title = ($header_title != '') ? $header_title : $single_banner_title;
    $single_bread_title = ($bread_title != '') ? $bread_title : $single_bread_title;
    $single_is_breadcrumb = ($single_is_bread != '') ? $single_is_bread : $single_is_breadcrumb;
    if ($header_image != '') {
        $bgStyle = 'background-image: url(' . $header_image . '); background-repeat: no-repeat; background-attachment: scroll; background-position: center center; background-size: cover; ';
    }
}
$blog_page = (get_option( 'page_for_posts' ) != '' ? get_option( 'page_for_posts' )  : '');
$blog_title = wp_strip_all_tags(get_the_title(get_the_ID()));
?>
<section class="page_banner" style="<?php echo esc_attr($bgStyle) ?>">
    <div class="container">
        <div class="row">
            <div class="col-xl-12 text-center">
                <h2><?php echo wp_kses($single_banner_title, industing_allowed_html()) ?></h2>
                <div class="breadcrumbs">
                    <?php if ($single_is_breadcrumb == 1): ?>
                    <a href="<?php echo esc_url(home_url('/')) ?>"><?php echo esc_html__('Home', 'industing') ?></a><i>|</i><a href="<?php if ( $blog_page > 0 ) { echo get_the_permalink($blog_page); } else{ echo '#';} ?>"><?php echo esc_html($single_bread_title); ?></a><i>|</i><span><?php echo esc_html($blog_title); ?></span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>