<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked wc_print_notices - 10
 */

$pro_rating_label = get_theme_mod('pro_rating_label', esc_html__('Rating', 'industing'));
$pro_stock_label = get_theme_mod('pro_stock_label', esc_html__('Availability', 'industing'));
$pro_sku_label = get_theme_mod('pro_sku_label', esc_html__('SKU', 'industing'));
$pro_is_category = get_theme_mod('pro_is_category', 1);
$pro_cat_label = get_theme_mod('pro_cat_label', esc_html__('Category', 'industing'));
$pro_is_tag = get_theme_mod('pro_is_tag', 1);
$pro_tag_label = get_theme_mod('pro_tag_label', esc_html__('Tag', 'industing'));
$pro_is_sharing = get_theme_mod('pro_is_sharing', 1);
$pro_share_label = get_theme_mod('pro_share_label', esc_html__('Social Share', 'industing'));
$pro_is_related = get_theme_mod('pro_is_related', 1);
$pro_rel_label = get_theme_mod('pro_rel_label', esc_html__('Related Products', 'industing'));
?>
<div class="row">
    <div class="col-lg-12">
        <?php echo wc_print_notices(); ?>
    </div>
</div>
<?php if ( post_password_required() ): ?>
<div class="row">
    <div class="col-lg-12 productPassWords">
        <?php
            echo get_the_password_form(); // WPCS: XSS ok.
        ?>
    </div>
</div>
<?php return; endif; ?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>
    <div class="row mb80">
        <div class="col-lg-7">
            <?php if(function_exists('woocommerce_show_product_images')): echo woocommerce_show_product_images(); endif; ?>
        </div>
        <div class="col-lg-5">
            <div class="product_decp">
                <h3 class="proTitle"><?php echo get_the_title(); ?></h3>
                <div class="details_price">
                    <?php echo woocommerce_template_single_price(); ?>
                </div>
                <?php if(has_excerpt()): ?>
                <div class="proExcerpt">
                    <?php echo get_the_excerpt(); ?>
                </div>
                <?php endif; ?>
                <div class="pd_details_meta">
                    <div class="row">
                        <?php if($product->get_rating_count() > 0 && function_exists('woocommerce_template_single_rating')): ?>
                        <div class="col-sm-4">
                            <h3 class="metaTitle"><?php echo esc_html($pro_rating_label) ?></h3>
                            <p class="pd_rating text-left">
                                <?php echo woocommerce_template_single_rating(); ?>
                            </p>
                        </div>
                        <?php endif; ?>
                        <?php if($product->managing_stock()): ?>
                        <div class="col-sm-4">
                            <h3 class="metaTitle"><?php echo esc_html($pro_stock_label); ?></h3>
                            <?php echo wc_get_stock_html($product); ?>
                        </div>
                        <?php endif; ?>
                        <?php if($product->get_sku() != ''): ?>
                        <div class="col-sm-4">
                            <h3 class="metaTitle"><?php echo esc_html($pro_sku_label); ?></h3>
                            <p class="text_meta"><?php echo wp_kses_post($product->get_sku()); ?></p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="pd_details_meta clearfix pdtb30">
                    <?php echo woocommerce_template_single_add_to_cart(); ?>
                </div>
                <?php
                    $category = '';
                    $terms = get_the_terms(get_the_ID(), 'product_cat');
                    if (is_array($terms) && !empty($terms)):
                        $p = 1;
                        $c = count($terms);
                        foreach ($terms as $term):
                            if($p == $c):
                                $category .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>';
                            else:
                                $category .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>, ';
                            endif;
                            $p++;
                        endforeach;
                    endif;
                    $tag = '';
                    $terms = get_the_terms(get_the_ID(), 'product_tag');
                    if (is_array($terms) && !empty($terms)):
                        $p = 1;
                        $c = count($terms);
                        foreach ($terms as $term):
                            if($p == $c):
                                $tag .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>';
                            else:
                                $tag .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>, ';
                            endif;
                            $p++;
                        endforeach;
                    endif;
                ?>
                <?php if(($pro_is_category == 1 && $category != '') || ($pro_is_tag == 1 && $tag != '')): ?>
                <div class="pd_details_meta">
                    <div class="row">
                        <?php if($pro_is_category == 1 && $category != ''): ?>
                        <div class="col-sm-6">
                            <h3 class="metaTitle"><?php echo esc_html($pro_cat_label); ?></h3>
                            <p class="text_meta"><?php echo wp_kses_post($category); ?></p>
                        </div>
                        <?php endif; ?>
                        <?php if($pro_is_tag == 1 && $tag != ''): ?>
                        <div class="col-sm-6">
                            <h3 class="metaTitle"><?php echo esc_html($pro_tag_label); ?></h3>
                            <p class="text_meta"><?php echo wp_kses_post($tag); ?></p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>
                <?php if($pro_is_sharing && industing_plugin_active('industing-assistance')): ?>
                <div class="pd_details_meta pdb0">
                    <div class="social_shares">
                        <strong><?php echo esc_html($pro_share_label) ?>:</strong>
                        <?php echo do_shortcode('[post_share pid="'.get_the_ID().'"]'); ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
    <div class="row">
    <?php 
        if(function_exists('woocommerce_output_product_data_tabs')): 
            echo woocommerce_output_product_data_tabs(); 
        endif; 
    ?>
    </div>
    <?php if($pro_is_related == 1): ?>
    <div class="clearfix"></div>
    <div class="row">
        <div class="col-lg-12">
            <div class="relatedProductArea">
                <div class="row mb40">
                    <div class="col-xl-8 col-md-8">
                        <h2 class="sec_title">
                            <?php echo esc_html($pro_rel_label) ?>
                        </h2>
                    </div>
                    <div class="col-xl-4 col-md-4 text-right">
                        <div class="relatedNavs"></div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xl-12">
                        <div class="relatedProductSlider owl-carousel">
                            <?php
                                if(function_exists('woocommerce_output_related_products')):
                                    echo woocommerce_output_related_products();
                                endif;
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <div class="clearfix"></div>
</div>
