<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Contcat_Form_Widget extends Widget_Base {

    public function get_name() {
        return 'tw-contact-form';
    }

    public function get_title() {
        return esc_html__( 'Contact From', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-form-vertical';
    }

    public function get_categories() {
        return [ 'industing-elements' ];
    }

    protected function _register_controls() {
        global $wpdb;
        $table = $wpdb->prefix.'posts';
        $result = $wpdb->get_results( 'SELECT * FROM '.$table.' WHERE post_type="wpcf7_contact_form" AND post_status="publish"', OBJECT );
        $shortcodes = array('0' => esc_html__('None', 'themewar'));
        if(is_array($result) && !empty($result)){
            foreach($result as $r){
                $shortcodes[$r->ID] = $r->post_title;
            }
        }
        $this->start_controls_section(
            'section_tab', [
                'label'     => esc_html__( 'Contact Form', 'themewar' ),
            ]
        );
        $this->add_control(
                'contact_form',
                [
                        'label'     => esc_html__( 'Select Form', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => '',
                        'options'   => $shortcodes,
                ]
        );
        $this->add_control(
                'form_style',
                [
                        'label'         => esc_html__( 'From Style', 'themewar' ),
                        'type'          => Controls_Manager::SELECT,
                        'default'       => 0,
                        'options'       => [
                                0       => esc_html__( 'Select From Style', 'themewar' ),
                                1       => esc_html__( 'Light Version', 'themewar' ),
                                2       => esc_html__( 'Dark Version', 'themewar' )
                        ],
                ]
        );
        $this->add_responsive_control(
                'form_align', [
                        'label'                     =>esc_html__( 'Alignment', 'themewar' ),
                        'type'                      => Controls_Manager::CHOOSE,
                        'options'                   => [
                                'left'		 => [
                                        'title'	 =>esc_html__( 'Left', 'themewar' ),
                                        'icon'	 => 'fa fa-align-left',
                                ],
                                'center'	 => [
                                        'title'	 =>esc_html__( 'Center', 'themewar' ),
                                        'icon'	 => 'fa fa-align-center',
                                ],
                                'right'		 => [
                                        'title'	 =>esc_html__( 'Right', 'themewar' ),
                                        'icon'	 => 'fa fa-align-right',
                                ]
                        ],
                        'default'                   => 'center',
                        'prefix_class'              => 'form_align elementor%s-align-',
                ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_tab_1', [
                'label'	 =>esc_html__( 'Contact Form Style', 'themewar' ),
                'tab'	 => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs( 'style_tabs_1' );
            $this->start_controls_tab(
                    'input_style_normal',
                    [
                            'label' => __( 'Normal', 'themewar' ),
                    ]
            );
            $this->add_control(
                    'input_label_color',
                    [
                            'label' => esc_html__( 'Label Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .iconInput input:not([type="submit"])' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .iconInput textarea' => 'color: {{VALUE}}',
                            
                                '{{WRAPPER}} .iconInput input:not([type="submit"])::-moz-placeholder' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .iconInput textarea::-moz-placeholder' => 'color: {{VALUE}}',
                            
                                '{{WRAPPER}} .iconInput input:not([type="submit"])::-ms-input-placeholder' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .iconInput textarea::-ms-input-placeholder' => 'color: {{VALUE}}',
                            
                                '{{WRAPPER}} .iconInput input:not([type="submit"])::-webkit-input-placeholder' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .iconInput textarea::-webkit-input-placeholder' => 'color: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_control(
                    'input_border_color',
                    [
                            'label'     => esc_html__( 'Input Border Color', 'themewar' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .iconInput input:not([type="submit"])'     => 'border-color: {{VALUE}}',
                                '{{WRAPPER}} .iconInput textarea'                       => 'border-color: {{VALUE}}'
                            ],
                    ]
            );
            $this->end_controls_tab();
            $this->start_controls_tab(
                    'input_style_hover',
                    [
                            'label' => __( 'Focus', 'themewar' ),
                    ]
            );
            $this->add_control(
                    'input_label_hover_color',
                    [
                            'label' => esc_html__( 'Label Focus Color', 'themewar' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .iconInput input:not([type="submit"]):focus' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .iconInput textarea:focus' => 'color: {{VALUE}}',
                            
                                '{{WRAPPER}} .iconInput input:not([type="submit"]):focus::-moz-placeholder' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .iconInput textarea:focus::-moz-placeholder' => 'color: {{VALUE}}',
                            
                                '{{WRAPPER}} .iconInput input:not([type="submit"]):focus::-ms-input-placeholder' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .iconInput textarea:focus::-ms-input-placeholder' => 'color: {{VALUE}}',
                            
                                '{{WRAPPER}} .iconInput input:not([type="submit"]):focus::-webkit-input-placeholder' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .iconInput textarea:focus::-webkit-input-placeholder' => 'color: {{VALUE}}'
                            ],
                    ]
            );
            $this->add_control(
                'input_hover_border',
                [
                        'label' => esc_html__( 'Input Focus Border Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .iconInput input:not([type="submit"]):focus'     => 'border-color: {{VALUE}}',
                                '{{WRAPPER}} .iconInput textarea:focus'                       => 'border-color: {{VALUE}}'
                        ],
                ]
            );
            $this->end_controls_tab();
        $this->end_controls_tabs();
            $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                            'name'      => 'input_typography',
                            'label'     => esc_html__( 'Label Typography', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .iconInput input:not([type="submit"]), .iconInput textarea',
                    ]
            );
            $this->add_control(
                'icon_color',
                [
                        'label' => esc_html__( 'Input Icon Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .iconInput i'                       => 'color: {{VALUE}}'
                        ],
                ]
            );
            $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                            'name'      => 'icon_typography',
                            'label'     => esc_html__( 'Icon Typography', 'themewar' ),
                            'selector'  => '{{WRAPPER}} .iconInput i',
                    ]
            );
            $this->add_control(
                'input_paddings',
                [
                        'label'      => esc_html__( 'Paddings', 'themewar' ),
                        'type'       => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors'  => [
                                '{{WRAPPER}} .iconInput input:not([type="submit"]), .iconInput textarea' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_control(
                'input_margins',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .iconInput, .light_form .iconInput input:not([type="submit"]), .light_form .iconInput textarea' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_tab_2', [
                'label'     => esc_html__( 'Button Style', 'themewar' ),
                'tab'	 => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs( 'style_tabs_3' );
                $this->start_controls_tab(
                        'button_style_normal',
                        [
                                'label' => __( 'Normal', 'themewar' ),
                        ]
                );
                $this->add_control(
                        'btn_label_color',
                        [
                                'label' => esc_html__( 'Label Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .cotactForm input[type="submit"]' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_control(
                        'button_bg',
                        [
                                'label' => esc_html__( 'BG Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .cotactForm input[type="submit"]' => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'button_style_hover',
                        [
                                'label' => __( 'Hover', 'themewar' ),
                        ]
                );
                $this->add_control(
                        'btn_label_hover_color',
                        [
                                'label' => esc_html__( 'Label Hover Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .cotactForm input[type="submit"]:hover' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_control(
                        'button_bg_hover',
                        [
                                'label' => esc_html__( 'BG Hover Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .cotactForm input[type="submit"]:hover' => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_control(
			'width',
			[
				'label' => __( 'Width', 'themewar' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [],
				'selectors' => [
					'{{WRAPPER}} .cotactForm input[type="submit"]' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
            $this->add_control(
			'height',
			[
				'label' => __( 'Height', 'themewar' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [],
				'selectors' => [
					'{{WRAPPER}} .cotactForm input[type="submit"]' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
            $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                            'name' => 'button_typography',
                            'label' => esc_html__( 'Button Typography', 'themewar' ),
                            'selector' => '{{WRAPPER}} .cotactForm input[type="submit"]',
                    ]
            );
            $this->add_control(
                'paddings',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .cotactForm input[type="submit"]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_control(
                'margins',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .cotactForm input[type="submit"]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
        $this->end_controls_section();
    }
    
    protected function render() {
        $settings       = $this->get_settings();
        $contact_form   = (isset($settings['contact_form']) && $settings['contact_form'] != '') ? $settings['contact_form'] : '';
        $form_style     = (isset($settings['form_style']) && $settings['form_style'] > 0) ? $settings['form_style'] : 0;
        
        switch ($form_style) {
            case 1:
                if($contact_form > 0):
                    echo '<div class="cotactForm light_form">';
                        echo do_shortcode('[contact-form-7 id="'.$contact_form.'"]');
                    echo '</div>';
                endif;
                break;
            case 2:
                if($contact_form > 0):
                    echo '<div class="cotactForm">';
                        echo do_shortcode('[contact-form-7 id="'.$contact_form.'"]');
                    echo '</div>';
                endif;
                break;
            default:
                ?>
                    <div class="alert alert-warning" role="alert">
                        <?php echo esc_html__('Please select From style first.', 'themewar'); ?>
                    </div>
                <?php
                break;
        }
        
    }

    protected function _content_template() {

    }    
}