<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
    exit;

class Tw_Testimonial_Widgets extends Widget_Base{
    
    public function get_name() {
        return 'tw-testimonial';
    }
    
    public function get_title() {
        return esc_html__( 'Testimonial Slider', 'themewar' );
    }

    public function get_icon() {
        return 'eicon-testimonial';
    }

    public function get_categories() {
        return [ 'industing-elements' ];
    }
    
    protected function _register_controls() {
        $this->start_controls_section(
            'section_tab', [
                'label' =>esc_html__( 'Testimonial Slider', 'themewar' ),
            ]
        );
        $this->add_control(
                'testi_style',
                [
                        'label'     => esc_html__( 'Testimonial Style', 'themewar' ),
                        'type'      => Controls_Manager::SELECT,
                        'default'   => 0,
                        'options'   => [
                                0                  => esc_html__( 'Select Style', 'themewar' ),
                                1                  => esc_html__( 'Slider', 'themewar' ),
                                2                  => esc_html__( 'Fixed', 'themewar' )
                        ],
                ]
        );
        $this->add_control(
                't_rating',
                [
                            'label' => esc_html__( 'Testimonial Ratins', 'themewar' ),
                            'type'  => Controls_Manager::NUMBER,
                            'condition'     => ['testi_style' => '2'],
                            'placeholder'   => esc_html__('0', 'themewar'),
                            'min'  => 0,
                            'max'  => 5,
                            'step' => 1,
                            'default' => 0,
                ]
        );
        $this->add_control(
                't_quote',
                [
                        'label'         => esc_html__( 'Testimonial Quote Title', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'condition'     => ['testi_style' => '2'],
                        'label_block'   => true,
                        'placeholder'   => esc_html__('insert quote Title', 'themewar')
                ]
        );
        $this->add_control(
                't_desc',
                [
                        'label'         => esc_html__( 'Testimonial Description', 'themewar' ),
                        'type'          => Controls_Manager::TEXTAREA,
                        'default'       => '',
                        'condition'     => ['testi_style' => '2'],
                        'label_block'   => true,
                        'placeholder'   => esc_html__('insert Testimonial Description', 'themewar')
                ]
        );
        $this->add_control(
                't_img',
                [
                        'label'         => esc_html__( 'Author Image', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'condition'     => ['testi_style' => '2'],
                        'description'   => esc_html__('Image size should be 70x70px.', 'themewar'),
                ]
        );
        $this->add_control(
                't_title',
                [
                        'label'         => esc_html__( 'Author Name', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'condition'     => ['testi_style' => '2'],
                        'label_block'   => true,
                        'placeholder'   => esc_html__('Author Name', 'themewar')
                ]
        );
        $this->add_control(
                't_designation',
                [
                        'label'         => esc_html__( 'Author Designation', 'themewar' ),
                        'type'          => Controls_Manager::TEXT,
                        'default'       => '',
                        'condition'     => ['testi_style' => '2'],
                        'label_block'   => true,
                        'placeholder'   => esc_html__('Author designation', 'themewar')
                ]
        );
        $this->add_control(
                'questioin_img',
                [
                        'label'         => esc_html__( 'Question Image', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'condition'     => ['testi_style' => '2'],
                        'description'   => esc_html__('Image size should be 392x515px.', 'themewar'),
                ]
        );
        $repeater = new \Elementor\Repeater();
            $repeater->add_control(
                    'rating',
                    [
                                'label' => esc_html__( 'Testimonial Ratins', 'themewar' ),
				'type'  => Controls_Manager::NUMBER,
                                'placeholder'   => esc_html__('0', 'themewar'),
				'min'  => 0,
				'max'  => 5,
				'step' => 1,
				'default' => 0,
                    ]
            );
            $repeater->add_control(
                    'quote',
                    [
                            'label'         => esc_html__( 'Testimonial Quote Title', 'themewar' ),
                            'type'          => Controls_Manager::TEXT,
                            'default'       => '',
                            'label_block'   => true,
                            'placeholder'   => esc_html__('insert quote Title', 'themewar')
                    ]
            );
            $repeater->add_control(
                    'desc',
                    [
                            'label'         => esc_html__( 'Testimonial Description', 'themewar' ),
                            'type'          => Controls_Manager::TEXTAREA,
                            'default'       => '',
                            'label_block'   => true,
                            'placeholder'   => esc_html__('insert Testimonial Description', 'themewar')
                    ]
            );
            $repeater->add_control(
                    'img',
                    [
                            'label'         => esc_html__( 'Author Image', 'themewar' ),
                            'type'          => Controls_Manager::MEDIA,
                            'description'   => esc_html__('Image size should be 70x70px.', 'themewar'),
                    ]
            );
            $repeater->add_control(
                    'title',
                    [
                            'label'         => esc_html__( 'Author Name', 'themewar' ),
                            'type'          => Controls_Manager::TEXT,
                            'default'       => '',
                            'label_block'   => true,
                            'placeholder'   => esc_html__('Author Name', 'themewar')
                    ]
            );
            $repeater->add_control(
                    'designation',
                    [
                            'label'         => esc_html__( 'Author Designation', 'themewar' ),
                            'type'          => Controls_Manager::TEXT,
                            'default'       => '',
                            'label_block'   => true,
                            'placeholder'   => esc_html__('Author designation', 'themewar')
                    ]
            );
        $this->add_control(
            'list',
            [
                    'label'         => esc_html__( 'Testimonial Slider', 'themewar' ),
                    'type'          => Controls_Manager::REPEATER,
                    'condition'     => ['testi_style' => '1'],
                    'fields'        => $repeater->get_controls(),
                    'default'       => [
                            [
                                    'rating'        => esc_html__( '', 'themewar' ),
                                    'quote'         => esc_html__( '', 'themewar' ),
                                    'desc'          => esc_html__( '', 'themewar' ),
                                    'img'           => esc_html__( '', 'themewar' ),
                                    'title'         => esc_html__( '', 'themewar' ),
                                    'designation'   => esc_html__( '', 'themewar' ),

                            ],
                    ],
                    'title_field' => "{{{ title }}}",
            ]
        );
        $this->add_control(
                'column_stetch',
                [
                        'label'         => esc_html__( 'Column Strech Full', 'themewar' ),
                        'type'          => Controls_Manager::SELECT,
                        'condition'     => ['testi_style' => '1'],
                        'description'   => esc_html__('Do You Want Stech This Column?', 'themewar'),
                        'default'       => 2,
                        'options'       => [
                                1       => esc_html__( 'Yes', 'themewar' ),
                                2       => esc_html__( 'No', 'themewar' ),
                        ],
                ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_tab_0',
            [
                'label'     => esc_html__('Single Testimonial Style', 'themewar'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => ['testi_style' => '1'],
            ]
         );
            $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                            'name'      => 'Background',
                            'label'     => esc_html__( 'BG Color', 'themewar' ),
                            'types'     => [ 'classic', 'gradient', 'video' ],
                            'selector'  => '{{WRAPPER}} .testimonial_item',
                    ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'author_shadow',
                            'label' => esc_html__( 'Box Shadow', 'themewar' ),
                            'selector' => '{{WRAPPER}} .testimonial_item',
                    ]
            );
            $this->add_control(
                'border_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .testimonial_item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_control(
                'area_padding',
                [
                        'label' => esc_html__( 'Paddings', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .testimonial_item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_control(
                'area_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .testimonial_item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
        $this->end_controls_section();
        $this->start_controls_section(
                'section_tab_1',[
                    'label'     => esc_html__('Rating Style', 'themewar'),
                    'tab'       => Controls_Manager::TAB_STYLE
                ]
        );
        $this->add_control(
                'rating_color',[
                        'label' => esc_html__( 'Rating Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .testimonial_item .ratings' => 'color: {{VALUE}}',
                        ],
                ]
        );
         $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'rating_typography',
                        'label' => esc_html__( 'Rating Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .testimonial_item .ratings',
                ]
        );
        $this->add_control(
                'rating_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .testimonial_item .ratings' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_2',[
                    'label'     => esc_html__('Quote Title Style', 'themewar'),
                    'tab'       => Controls_Manager::TAB_STYLE
                ]
        );
        $this->add_control(
                'quote_color',[
                        'label' => esc_html__( 'Quote Title Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .testimonial_item h3' => 'color: {{VALUE}}',
                        ],
                ]
        );
         $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'quote_typography',
                        'label' => esc_html__( 'Quote Title Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .testimonial_item h3',
                ]
        );
        $this->add_control(
                'quote_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .testimonial_item h3' => 'Margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
                'section_tab_3',[
                    'label'     => esc_html__('Description Style', 'themewar'),
                    'tab'       => Controls_Manager::TAB_STYLE
                ]
        );
        $this->add_control(
                'desc_color',[
                        'label' => esc_html__( 'Description Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .testimonial_item p' => 'color: {{VALUE}}',
                        ],
                ]
        );
         $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'desc_typography',
                        'label' => esc_html__( 'Description Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .testimonial_item p',
                ]
        );
        $this->add_control(
                'desc_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .testimonial_item p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_4',
            [
                'label'     => esc_html__('Author Image Style', 'themewar'),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
                'width',
                [
                        'label' => __( 'Width', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .testimonial_item .ti_author img' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_control(
                    'height',
                    [
                            'label' => __( 'Height', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 500,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .testimonial_item .ti_author img' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_control(
                'border_radius_2',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .testimonial_item .ti_author img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                            'name' => 'author_shadow_2',
                            'label' => esc_html__( 'Box Shadow', 'yoox' ),
                            'selector' => '{{WRAPPER}} .testimonial_item .ti_author img',
                    ]
            );
            $this->add_control(
                'author_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .testimonial_item .ti_author img' => 'Margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
        $this->end_controls_section();
        $this->start_controls_section(
                'section_tab_5',[
                    'label'     => esc_html__('Author Name Style', 'themewar'),
                    'tab'       => Controls_Manager::TAB_STYLE
                ]
        );
        $this->add_control(
                'name_color',[
                        'label' => esc_html__( 'Name Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .ti_author h4' => 'color: {{VALUE}}',
                        ],
                ]
        );
         $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'name_typography',
                        'label' => esc_html__( 'Name Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .ti_author h4',
                ]
        );
        $this->add_control(
                'name_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .ti_author h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
                'section_tab_6',[
                    'label'     => esc_html__('Designation Style', 'themewar'),
                    'tab'       => Controls_Manager::TAB_STYLE
                ]
        );
        $this->add_control(
                'deg_color',[
                        'label' => esc_html__( 'Designation Color', 'themewar' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                                '{{WRAPPER}} .ti_author span' => 'color: {{VALUE}}',
                        ],
                ]
        );
         $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                        'name' => 'deg_typography',
                        'label' => esc_html__( 'Designation Typography', 'themewar' ),
                        'selector' => '{{WRAPPER}} .ti_author span',
                ]
        );
        $this->add_control(
                'deg_margin',
                [
                        'label' => esc_html__( 'Margins', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .ti_author span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
        );
        $this->end_controls_section();
    }
    
    protected function render() {
        $settings       = $this->get_settings();
        $testi_style    = (isset($settings['testi_style']) && $settings['testi_style'] > 0) ? $settings['testi_style'] : 0;
        $column_stetch  = (isset($settings['column_stetch']) && $settings['column_stetch'] > 0) ? $settings['column_stetch'] : 2;
        $testimonial    = (isset($settings['list']) && !empty($settings['list'])) ? $settings['list'] : array();
        
        $t_rating       = (isset($settings['t_rating']) && $settings['t_rating'] != '') ? $settings['t_rating'] : 0;
        $t_quote        = (isset($settings['t_quote']) && $settings['t_quote'] != '') ? $settings['t_quote'] : '';
        $t_desc         = (isset($settings['t_desc']) && $settings['t_desc'] != '') ? $settings['t_desc'] : '';
        $t_title        = (isset($settings['t_title']) && $settings['t_title'] != '') ? $settings['t_title'] : '';
        $t_designation  = (isset($settings['t_designation']) && $settings['t_designation'] != '') ? $settings['t_designation'] : '';
        $t_img          = (isset($settings['t_img']['url']) && $settings['t_img']['url'] != '') ? $settings['t_img']['url'] : 'https://via.placeholder.com/70x70.jpg';
        $questioin_img  = (isset($settings['questioin_img']['url']) && $settings['questioin_img']['url'] != '') ? $settings['questioin_img']['url'] : '';
        $unrating       = 5 - (is_int($t_rating) && $t_rating > 0 ? $t_rating : 0);
        
        $bgStyle = '';
        if($questioin_img != ''){
            $bgStyle = 'background-image: url('.$questioin_img.'); background-repeat: no-repeat; background-position: center center;';
        }
        
        switch ($testi_style) {
            case 1:
                if(!empty($testimonial)):
                ?>
                    <?php if($column_stetch == 1){ echo '<div class="tw-stretch-element-inside-column">';} ?>
                        <div class="testimonialSliderHolder"> 
                            <?php echo '<div class="testimonialSlider">';
                                foreach($testimonial as $item):
                                    $img        = (isset($item['img']['url'])) ? $item['img']['url'] : 'https://via.placeholder.com/70x70.jpg';
                                    $title      = (isset($item['title'])) ? $item['title'] : '';
                                    $rating     = (isset($item['rating'])) ? $item['rating'] : 0;
                                    $desig      = (isset($item['designation'])) ? $item['designation'] : '';
                                    $desc       = (isset($item['desc'])) ? $item['desc'] : '';
                                    $quote      = (isset($item['quote'])) ? $item['quote'] : '';

                                    $unrate = 5 - $rating;
                                ?>
                                <div class="ts_item">
                                    <div class="testimonial_item">
                                        <span class="ratings"><?php echo ($rating > 0 ? str_repeat('<i class="twi-star"></i>', $rating) : ''); ?><?php echo ($rating > 0 ? str_repeat('<i class="twi-star2"></i>', $unrate) : ''); ?></span>
                                        <?php if($quote != ''): ?>
                                            <h3><?php echo esc_html($quote); ?></h3>
                                        <?php endif; ?>
                                        <?php if($desc != ''): ?>
                                            <p><?php echo esc_html($desc); ?></p>
                                        <?php endif; ?>
                                        <div class="ti_author clearfix">
                                            <?php if($img != ''): ?>
                                                <img src="<?php echo esc_url($img); ?>" alt=""/>
                                            <?php endif; ?>
                                            <?php if($title != ''): ?>
                                                <h4><?php echo esc_html($title); ?></h4>
                                            <?php endif; ?>
                                            <?php if($desig != ''): ?>
                                                <span><?php echo esc_html($desig); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach;
                            echo '</div>'; ?>
                        </div>
                    <?php if($column_stetch == 1){ echo '</div>'; } ?>
                <?php endif;
                break;
            case 2:
                ?>
                    <div class="testimonial_item testimonial_item2">
                        <span class="ratings"><?php echo ($t_rating > 0 ? str_repeat('<i class="twi-star"></i>', $t_rating) : ''); ?><?php echo ($t_rating > 0 ? str_repeat('<i class="twi-star2"></i>', $unrating) : ''); ?></span>
                        <?php if($t_quote != ''): ?>
                            <h3><?php echo esc_html($t_quote); ?></h3>
                        <?php endif; ?>
                        <?php if($t_desc != ''): ?>
                            <p>
                                <?php echo esc_html($t_desc); ?>
                            </p>
                        <?php endif; ?>
                        <div class="ti_author clearfix">
                            <?php if($t_img != ''): ?>
                                <img src="<?php echo esc_url($t_img); ?>" alt="">
                            <?php endif; ?>
                            <?php if($t_title != ''): ?>
                                <h4><?php echo esc_html($t_title); ?></h4>
                            <?php endif; ?>
                            <?php if($t_designation != ''): ?>
                                <span><?php echo esc_html($t_designation); ?></span>
                            <?php endif; ?>
                        </div>
                        <?php if($bgStyle != ''): ?>
                            <div class="question" style="<?php echo esc_attr($bgStyle); ?>"></div>
                        <?php endif; ?>
                    </div>
                <?php
                break;
            default:
                ?>
                    <div class="alert alert-warning" role="alert">
                        <?php echo esc_html__('Please Select Testimonial Style first.', 'themewar'); ?>
                    </div>
                <?php
                break;
        }
        
    }
        
    protected function _content_template() {

    }
}                                       
                                        