<?php

namespace Elementor;

if( !defined('ABSPATH') )
    exit;

class Tw_Video_Widget extends Widget_Base{
    
    public function get_name() {
        return 'tw-video-element';
    }
    public function get_title() {
        return esc_html__( 'Video Element', 'themewar' );
    }
    public function get_icon() {
        return 'eicon-youtube';
    }
    public function get_categories() {
        return ['industing-elements'];
    }
    
    protected function _register_controls() {
        $this->start_controls_section(
                'section_tab', [
                    'label'     => esc_html__(' Video Element ', 'themewar')
                ]
        );
        $this->add_control(
                'video_style',
                [
                        'label' => esc_html__( 'Video Style', 'themewar' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 0,
                        'options' => [
                                0       => esc_html__( 'Select Style', 'themewar' ),
                                1       => esc_html__( 'Video Style 01', 'themewar' ),
                                2       => esc_html__( 'Video Style 02', 'themewar' ),
                                3       => esc_html__( 'Video BTN', 'themewar' ),
                        ],
                ]
        );
        $this->add_control(
                'video_img_1',
                [
                        'label'         => esc_html__( 'Video Large Image', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('Image size should be 557x598px.', 'themewar'),
                        'condition'     => ['video_style' => '1']
                ]
        );
        $this->add_control(
                'video_img_2',
                [
                        'label'         => esc_html__( 'Video Small Image', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('Image size should be 320x240px.', 'themewar'),
                        'condition'     => ['video_style' => '1']
                ]
        );
        $this->add_control(
                'video_img_3',
                [
                        'label'         => esc_html__( 'Video BG Image', 'themewar' ),
                        'type'          => Controls_Manager::MEDIA,
                        'description'   => esc_html__('Image size should be 793x856px.', 'themewar'),
                        'condition'     => ['video_style' => '2']
                ]
        );
        $this->add_control(
                'video_url',
                [
                        'label'             => esc_html__( 'Video Link', 'themewar' ),
                        'type'              => Controls_Manager::URL,
                        'placeholder'       => esc_html__( 'https://www.youtube.com/watch?v=A7ZkZazfvao', 'themewar' ),
                        'show_external'     => true,
                        'default'           => [
                                'url' => '',
                                'is_external' => true,
                                'nofollow' => true,
                        ],
                ]
        );
        $this->add_control(
                'video_stetch',
                [
                        'label'         => esc_html__( 'Image Strech Full', 'themewar' ),
                        'type'          => Controls_Manager::SELECT,
                        'description'   => esc_html__('Do You Want Stech This Column?', 'themewar'),
                        'default'       => 2,
                        'condition'     => ['video_style' => '2'],
                        'options'       => [
                                1       => esc_html__( 'Yes', 'themewar' ),
                                2       => esc_html__( 'No', 'themewar' ),
                        ],
                ]
        );
        $this->add_responsive_control(
                'btn_align', [
                        'label'                     =>esc_html__( 'Button Alignment', 'themewar' ),
                        'type'                      => Controls_Manager::CHOOSE,
                        'condition'                 => ['video_style' => '3'],
                        'options'                   => [
                                'left'		 => [
                                        'title'	 =>esc_html__( 'Left', 'themewar' ),
                                        'icon'	 => 'fa fa-align-left',
                                ],
                                'center'	 => [
                                        'title'	 =>esc_html__( 'Center', 'themewar' ),
                                        'icon'	 => 'fa fa-align-center',
                                ],
                                'right'		 => [
                                        'title'	 =>esc_html__( 'Right', 'themewar' ),
                                        'icon'	 => 'fa fa-align-right',
                                ]
                        ],
                        'default'                   => 'center',
                        'prefix_class'              => 'v_btn_align elementor%s-align-',
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_0',
            [
                'label'     => esc_html__('Small Image Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
                'condition'     => ['video_style' => '1']
            ]
        );
        $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                        'name' => 'small_img_border',
                        'label' => esc_html__( 'Border', 'themewar' ),
                        'selector' => '{{WRAPPER}} .video_01 .vp',
                ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_1',
            [
                'label'     => esc_html__('Video Button Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
                'condition'     => ['video_style' => '1']
            ]
        );
        $this->add_control(
                'icon_size',
                [
                        'label' => esc_html__( 'Font Size', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                        ],
                        'default' => [
                                'unit' => 'px',
                                'size' => '',
                        ],
                        'selectors' => [
                                '{{WRAPPER}} .video_01 .vp a' => 'font-size: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'btn_line_height',
                [
                        'label' => __( 'Line Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .video_01 .vp a' => 'line-height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs( 'style_tabs_1' );
                $this->start_controls_tab(
                        'button_style_normal',
                        [
                                'label' => __( 'Normal', 'themewar' ),
                        ]
                );
                $this->add_control(
                        'btn_color',
                        [
                                'label' => esc_html__( 'BTN Icon Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .video_01 .vp a' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_control(
                        'button_bg',
                        [
                                'label' => esc_html__( 'BG Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .video_01 .vp a' => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'button_style_hover',
                        [
                                'label' => __( 'Hover', 'themewar' ),
                        ]
                );
                $this->add_control(
                        'btn_hover_color',
                        [
                                'label' => esc_html__( 'BTN Icon Hover Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .video_01 .vp a:hover' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_control(
                        'button_bg_hover',
                        [
                                'label' => esc_html__( 'BG Hover Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .video_01 .vp a:hover' => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_control(
                    'width',
                    [
                            'label' => __( 'Width', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 500,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .video_01 .vp a' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_control(
                    'height',
                    [
                            'label' => __( 'Height', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 500,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .video_01 .vp a' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_control(
                'border_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .video_01 .vp a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_control(
                'btn_padding',
                [
                        'label' => esc_html__( 'Padding', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .video_01 .vp a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_control(
                'btn_margins',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .video_01 .vp a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_2',
            [
                'label'     => esc_html__('Video Button Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
                'condition'     => ['video_style' => '2']
            ]
        );
        $this->add_control(
                'v_2_icon_size',
                [
                        'label' => esc_html__( 'Font Size', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                        ],
                        'default' => [
                                'unit' => 'px',
                                'size' => '',
                        ],
                        'selectors' => [
                                '{{WRAPPER}} .video_02 .videoPlay1' => 'font-size: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'v_2_btn_line_height',
                [
                        'label' => __( 'Line Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .video_02 .videoPlay1' => 'line-height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs( 'style_tabs_2' );
                $this->start_controls_tab(
                        'v_2_button_style_normal',
                        [
                                'label' => __( 'Normal', 'themewar' ),
                        ]
                );
                $this->add_control(
                        'v_2_btn_color',
                        [
                                'label' => esc_html__( 'BTN Icon Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .video_02 .videoPlay1' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_control(
                        'v_2_button_bg',
                        [
                                'label' => esc_html__( 'BG Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .video_02 .videoPlay1' => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'v_2_button_style_hover',
                        [
                                'label' => __( 'Hover', 'themewar' ),
                        ]
                );
                $this->add_control(
                        'v_2btn_hover_color',
                        [
                                'label' => esc_html__( 'BTN Icon Hover Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .video_02 .videoPlay1:hover' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_control(
                        'v_2_button_bg_hover',
                        [
                                'label' => esc_html__( 'BG Hover Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .video_02 .videoPlay1:hover' => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_control(
                    'v_2_width',
                    [
                            'label' => __( 'Width', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 500,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .video_02 .videoPlay1' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_control(
                    'v_2_height',
                    [
                            'label' => __( 'Height', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 500,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .video_02 .videoPlay1' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_control(
                'v_2_border_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .video_02 .videoPlay1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_control(
                'v_2_btn_padding',
                [
                        'label' => esc_html__( 'Padding', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .video_02 .videoPlay1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_control(
                'v_2_btn_margins',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .video_02 .videoPlay1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_3',
            [
                'label'     => esc_html__('Video Button Style', 'themewar'),
                'tab'     => Controls_Manager::TAB_STYLE,
                'condition'     => ['video_style' => '3']
            ]
        );
        $this->add_control(
                'v_3_icon_size',
                [
                        'label' => esc_html__( 'Font Size', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                        ],
                        'default' => [
                                'unit' => 'px',
                                'size' => '',
                        ],
                        'selectors' => [
                                '{{WRAPPER}} .videoPlay i' => 'font-size: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->add_control(
                'v_3_btn_line_height',
                [
                        'label' => __( 'Line Height', 'themewar' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                                'px' => [
                                        'min' => 0,
                                        'max' => 500,
                                        'step' => 1,
                                ],
                                '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                ],
                        ],
                        'default' => [],
                        'selectors' => [
                                '{{WRAPPER}} .videoPlay i' => 'line-height: {{SIZE}}{{UNIT}};',
                        ],
                ]
        );
        $this->start_controls_tabs( 'style_tabs_3' );
                $this->start_controls_tab(
                        'v_3_button_style_normal',
                        [
                                'label' => __( 'Normal', 'themewar' ),
                        ]
                );
                $this->add_control(
                        'v_3_btn_color',
                        [
                                'label' => esc_html__( 'BTN Icon Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .videoPlay i' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_control(
                        'v_3_button_bg',
                        [
                                'label' => esc_html__( 'BG Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .videoPlay i' => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->end_controls_tab();
                $this->start_controls_tab(
                        'v_3_button_style_hover',
                        [
                                'label' => __( 'Hover', 'themewar' ),
                        ]
                );
                $this->add_control(
                        'v_3_btn_hover_color',
                        [
                                'label' => esc_html__( 'BTN Icon Hover Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .videoPlay:hover i' => 'color: {{VALUE}}',
                                ],
                        ]
                );
                $this->add_control(
                        'v_3_button_bg_hover',
                        [
                                'label' => esc_html__( 'BG Hover Color', 'themewar' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                        '{{WRAPPER}} .videoPlay:hover i' => 'background: {{VALUE}}',
                                ],
                        ]
                );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            $this->add_control(
                    'v_3_width',
                    [
                            'label' => __( 'Width', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 500,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .videoPlay i' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_control(
                    'v_3_height',
                    [
                            'label' => __( 'Height', 'themewar' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                    'px' => [
                                            'min' => 0,
                                            'max' => 500,
                                            'step' => 1,
                                    ],
                                    '%' => [
                                            'min' => 0,
                                            'max' => 100,
                                    ],
                            ],
                            'default' => [],
                            'selectors' => [
                                    '{{WRAPPER}} .videoPlay i' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                    ]
            );
            $this->add_control(
                'v_3_border_radius',
                [
                        'label' => esc_html__( 'Border Radius', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .videoPlay i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_control(
                'v_3_btn_padding',
                [
                        'label' => esc_html__( 'Padding', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .videoPlay i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
            $this->add_control(
                'v_3_btn_margins',
                [
                        'label' => esc_html__( 'Margin', 'themewar' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                                '{{WRAPPER}} .videoPlay' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                ]
            );
        $this->end_controls_section();
        
    }
    
    protected function render() {
        $settings     = $this->get_settings();
        $video_style  = (isset($settings['video_style']) && $settings['video_style'] > 0) ? $settings['video_style'] : 0;
        $video_img_1  = (isset($settings['video_img_1']['url']) && $settings['video_img_1']['url'] != '') ? $settings['video_img_1']['url'] : 'https://via.placeholder.com/557x598.jpg';
        $video_img_2  = (isset($settings['video_img_2']['url']) && $settings['video_img_2']['url'] != '') ? $settings['video_img_2']['url'] : 'https://via.placeholder.com/320x240.jpg';
        $video_img_3  = (isset($settings['video_img_3']['url']) && $settings['video_img_3']['url'] != '') ? $settings['video_img_3']['url'] : 'https://via.placeholder.com/793x856.jpg';
        $target       = $settings['video_url']['is_external'] ? ' target="_blank"' : '';
        $nofollow     = $settings['video_url']['nofollow'] ? ' rel="nofollow"' : '';
        $video_url    = (isset($settings['video_url']['url']) && $settings['video_url']['url'] != '') ? $settings['video_url']['url'] : 'https://www.youtube.com/watch?v=A7ZkZazfvao';
        $video_stetch = (isset($settings['video_stetch']) && $settings['video_stetch'] > 0) ? $settings['video_stetch'] : 2;
        
        switch ($video_style){
            case 1:
                ?>
                    <div class="video_01 text-right">
                        <img src="<?php echo esc_url($video_img_1) ?>" alt="">
                        <div class="vp">
                            <img src="<?php echo esc_url($video_img_2); ?>" alt="">
                            <a class="videoPlayer" href="<?php echo esc_url($video_url) ?>"><i class="twi-play"></i></a>
                        </div>
                    </div>
                <?php
                break;
            case 2:
                ?>
                    <div class="<?php if($video_stetch == 1): echo 'tw-stretch-element-inside-column video_02'; else: echo 'video_02'; endif; ?>">
                        <?php if($video_img_3 != ''): ?>
                            <img src="<?php echo esc_url($video_img_3);?>" alt=""/>
                        <?php endif; ?>
                        <a class="videoPlay1 videoPlayer" href="<?php echo esc_url($video_url) ?>"><i class="twi-play"></i></a>
                    </div>
                <?php
                break;
            case 3:
                ?>
                    <a class="videoPlay videoPlayer" href="<?php echo esc_url($video_url) ?>"><i class="twi-play"></i></a>
                <?php
                break;
            default:
                ?>
                    <div class="alert alert-warning" role="alert">
                        <?php echo esc_html__('Please select video style first.', 'themewar'); ?>
                    </div>
                <?php
                break;
        }
    }
    
    protected function _content_template() {
        
    }
}