<?php
/*
    Plugin Name: Industing Assistance
    Plugin URI: http://themewar.com/wp/industing/
    Description: Assistance plugin for all Industing Assistance.
    Version: 1.0.1
    Author: themewar
    Author URI: http://themewar.com/
    License: 
    Text Domain: themewar
*/

if (!defined('ABSPATH')) {
    exit;
}

/* * ---------------------------------------------------------------
* Including Files
* -------------------------------------------------------------* */

require_once dirname(__FILE__) . '/autoload.php';

class TW_Assistance{
    public static $_instance;

    public $plugin_name = 'Industing Assistance';
    public $plugin_version = '1.0.1';
    public $file = __FILE__;


    public function __construct(){
        $this->tw_init();
    }

    /* * ---------------------------------------------------------------
    * Init all hooks and others
    * -------------------------------------------------------------* */

    public function tw_init(){
        add_action('plugins_loaded', array($this, 'tw_load_textdomain'));
        add_action('admin_enqueue_scripts', array($this, 'tw_admin_enqueue_scripts'));
        add_action('login_enqueue_scripts', array($this, 'tw_wp_login_css'), 10);
        add_action('widgets_init', array($this, 'tw_widgets_init'));
        
        add_action('wp_ajax_nopriv_post_like', array($this, 'jobers_ajax_post_like'));
        add_action('wp_ajax_post_like', array($this, 'jobers_ajax_post_like'));
        
        add_shortcode('post_share', array($this, 'industing_post_share'));
        
        add_shortcode('tw-service-box', array($this, 'industing_service_feature_boxes'));
        
        $this->kta_taxonomy_and_post_type_caller();
        $this->kta_post_type_caller();
        new Tw_Users_Meta_Hooks();
        //check elementor load
        if ( did_action( 'elementor/loaded' ) ) {
            Tw_Elementor::tw_get_instance();
        }
        
        add_action('admin_head', array($this, 'themewar_hide_brizy_admin_notice'));
    }

    /* * ---------------------------------------------------------------
    * Load textdomain
    * -------------------------------------------------------------* */

    public function kta_taxonomy_and_post_type_caller(){
        $tmgc_tax = new Tw_Taxonomies('themewar');
        $tmgc_tax->tw_inits('folio_cat', 'Category', 'Categories', 'folio');
    }

    /* * ---------------------------------------------------------------
    * Widgets
    * -------------------------------------------------------------* */

    public function kta_post_type_caller(){
        $tmgc_tax = new Tw_Custom_Post('themewar');
        $tmgc_tax->tw_inits('tw-service', 'Service', 'Services', array('menu_icon' => 'dashicons-chart-line'));
        
        $tmgc_post = new Tw_Custom_Post('themewar');
        $tmgc_post->tw_inits('folio', 'Portfolio', 'Portfolios', array('menu_icon' => 'dashicons-portfolio'));
        
        $tmgc_team = new Tw_Custom_Post('themewar');
        $tmgc_team->tw_inits('member', 'Team Member', 'Team Members', array('menu_icon' => 'dashicons-businessman'));
        
        $tmgc_block = new Tw_Custom_Post('themewar');
        $tmgc_block->tw_inits('blocks', 'Block', 'Blocks', array('menu_icon' => 'dashicons-editor-kitchensink'));
    }

    /* * ---------------------------------------------------------------
    * JS and CSS for Frontend
    * -------------------------------------------------------------* */

    public static function tw_instance(){

        if (!isset(self::$_instance)) {
            self::$_instance = new TW_Assistance();
        }
        return self::$_instance;

    }

    /* * ---------------------------------------------------------------
    * Load Css For WP Login
    * -------------------------------------------------------------* */

    public function tw_load_textdomain(){
        load_plugin_textdomain('themewar', false, dirname(__FILE__) . '/languages');
    }

    /* * ---------------------------------------------------------------
    * Taxonomy Caller
    * -------------------------------------------------------------* */

    public function tw_widgets_init(){
        register_widget('Tw_Flickr_Widgets');
        register_widget('Tw_Recentpost_Widgets');
        
        
        register_widget('Tw_Helpinfo_Widgets');
        register_widget('Tw_Social_Widgets');
        register_widget('Tw_About_Widgets');
        register_widget('Tw_Service_Widgets');
        register_widget('Tw_Works_Widgets');
        
        register_widget('Tw_Downloadbrochures_Widgets');
    }

    /* * ---------------------------------------------------------------
    * Posttype Caller
    * -------------------------------------------------------------* */

    public function tw_admin_enqueue_scripts(){
        if (function_exists('wp_enqueue_media')) {
            wp_enqueue_media();
        } else {
            wp_enqueue_style('thickbox');
            wp_enqueue_script('media-upload');
            wp_enqueue_script('thickbox');
        }

        wp_enqueue_style('meipaly-assistance', plugin_dir_url($this->file) . 'assets/css/admin_style.css', false);
        wp_enqueue_script('tw-theme-core', plugin_dir_url($this->file) . 'assets/js/tw_admin.js', false);
        wp_localize_script('meipaly-assistance', 'jobers_ajax', array('ajaxurl' => admin_url('admin-ajax.php')));
    }

    /*======================================================================
    / Set Capabilities
    /=====================================================================*/

    public function tw_wp_login_css()
    {
        wp_enqueue_style('tw-theme-core', plugin_dir_url($this->file) . 'assets/css/login_style.css', false);
    }

    /* * ---------------------------------------------------------------
   * Create Instance
   * -------------------------------------------------------------* */

    public function kta_assign_custom_post_capabilities()
    {
        $roles = array('editor', 'administrator');
        $types = array('footers', 'cheff', 'galleries', 'blocks');

        foreach ($types as $type):
            foreach ($roles as $the_role):
                $role = get_role($the_role);
                $role->add_cap("read");
                $role->add_cap("read_{$type}");
                $role->add_cap("read_private_{$type}s");
                $role->add_cap("edit_{$type}");
                $role->add_cap("edit_{$type}s");
                $role->add_cap("edit_others_{$type}s");
                $role->add_cap("edit_published_{$type}s");
                $role->add_cap("publish_{$type}s");
                $role->add_cap("delete_others_{$type}s");
                $role->add_cap("delete_private_{$type}s");
                $role->add_cap("delete_published_{$type}s");
            endforeach;
        endforeach;
    }

    function themewar_hide_brizy_admin_notice() {
      echo '<style>
        .notice.fw-brz-dismiss {display: none;} 
      </style>';
    }
    
    /**---------------------------------------------------------------
    * Industing Single Post Share
    * -------------------------------------------------------------**/
    public function industing_post_share($atts){
        extract(
            shortcode_atts(
                array(
                    'pid'   => 0
                ), 
                $atts
            )
        );
        $html = '';
            $html .= '<a target="_blank" href="http://www.facebook.com/sharer?u='.get_the_permalink($pid).'&title='.get_the_title($pid).'"><i class="twi-facebook-f"></i></a>';
            $html .= '<a target="_blank" href="http://twitter.com/intent/tweet?status='.get_the_title($pid).'+'.get_the_permalink($pid).'"><i class="twi-twitter"></i></a>';
            $html .= '<a target="_blank" href="http://pinterest.com/pin/create/bookmarklet/?media='.get_the_post_thumbnail_url($pid, 'industing-blog-4').'&url='.get_the_permalink($pid).'&is_video=false&description='.get_the_title($pid).'"><i class="twi-pinterest-p"></i></a>';
            $html .= '<a target="_blank" href="http://www.linkedin.com/shareArticle?mini=true&url='.get_the_permalink($pid).'&title='.get_the_title($pid).'&source='.get_bloginfo('url').'"><i class="twi-linkedin"></i></a>';
            $html .= '<a target="_blank" href="https://www.tumblr.com/widgets/share/tool?canonicalUrl='.get_the_permalink($pid).'&title='.get_the_title($pid).'&caption='.get_the_title($pid).'&tags={hash_tags}"><i class="twi-tumblr"></i></a>';
            
        
        return $html;
    }
    
    public function industing_service_feature_boxes($atts){
        global $post;
        if(!is_singular('tw-service')){
            return;
        }
        ob_start();
        
        $key_features_box = array();
        if(defined('FW')){
            $key_features_box = fw_get_db_post_option($post->ID, 'key_features_box', array());
        }
        if(!empty($key_features_box)):
            ?>
            <div class="sda_tags clearfix">
                <?php
                    foreach($key_features_box as $kfb):
                        $ser_box_title = ($kfb['ser_box_title'] != '' ? $kfb['ser_box_title'] : '');
                        $ser_box_icon = ($kfb['ser_box_icon'] != '' ? $kfb['ser_box_icon'] : '');
                        $icon_or_img = '';
                        if(isset($ser_box_icon['type']) && $ser_box_icon['type'] == 'icon-font'){
                            $icon_or_img = (isset($ser_box_icon['icon-class']) && $ser_box_icon['icon-class'] != '' ? '<i class="'.$ser_box_icon['icon-class'].'"></i>' : '');
                        }elseif(isset($ser_box_icon['type']) && $ser_box_icon['type'] == 'custom-upload'){
                            $icon_or_img = (isset($ser_box_icon['url']) && $ser_box_icon['url'] != '' ? '<img src="'.$ser_box_icon['url'].'" alt=""/>' : '');
                        }
                        if($ser_box_title != ''):
                        echo '<div class="icon_box_04">
                                    '.$icon_or_img.'
                                    <h4>'.$ser_box_title.'</h4>
                                </div>';
                        endif;
                    endforeach;
                ?>
            </div>
            <?php
        else:
            ?>
            <div class="alert alert-warning" role="alert">
                <?php echo esc_html__('Feature box item not found. Please insert some...', 'themewar'); ?>
            </div>
            <?php
        endif;
        $output = ob_get_contents();
        ob_clean();
        return $output;
    }
    
}

$kta_instance = TW_Assistance::tw_instance();