<?php
$bloks = array(
        'post_type'     => 'blocks',
        'post_status'   => 'publish',
        'posts_per_page'  => -1,
        'orderby'        => 'title',
        'order'          => 'ASC'
    );
    $all_bloks = array(
        'none' => esc_html__('None', 'industing')
    );
    $blok = new WP_Query($bloks);
    if($blok->have_posts()):
        while($blok->have_posts()):
        $blok->the_post();
        $all_bloks[get_the_ID()] = get_the_title();
        endwhile;
    endif;
    wp_reset_postdata();

$fields[] = array(
	'type'        => 'image',
	'settings'    => 'ser_banner_bg',
	'label'       => esc_html__( 'Banner BG', 'industing' ),
	'section'     => 'service_settings',
);

$fields[]= array(
        'type'        => 'color',
	'settings'    => 'ser_banner_overlay',
	'label'       => esc_html__( 'Banner Overlay Color', 'industing' ),
	'section'     => 'service_settings',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.page_banner:after',
                        'property' => 'background'
		],
	],
);

$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'ser_is_breadcrumb',
	'label'       => esc_html__( 'Is Breadcrumb', 'industing' ),
	'section'     => 'service_settings',
	'default'     => '1',
	'choices'     => [
		'on'  => esc_html__( 'Show', 'industing' ),
		'off' => esc_html__( 'Hide', 'industing' ),
	],
);
$fields[]= array(
        'type'        => 'text',
        'settings'    => 'ser_banner_title',
        'label'       => esc_html__( 'Banner Title', 'industing' ),
        'section'     => 'service_settings',
        'transport'   => 'postMessage',
        'js_vars'     => array(
            array(
                'element'  => '.page_banner h2',
                'function' => 'html'
            ),
        ),
        'default'     => esc_html__( 'Service Detail', 'industing' ),
);

$fields[] = array(
        'type'          => 'text',
	'settings'      => 'ser_bread_title',
	'label'         => esc_html__( 'Breadcrumb Title', 'industing' ),
	'section'       => 'service_settings',
	'default'       => esc_html__('Service', 'industing'),
        'transport'     => 'postMessage',
        'js_vars'       => array(
            array(
                'element'  => '.breadcrumbs span',
                'function' => 'html'
            ),
        ),
);
$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'sing_serv_custom1',
	'label'       => FALSE,
	'section'     => 'service_settings',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);
$fields[]= array(
        'type'        => 'select',
	'settings'    => 'ser_sidebar_pos',
	'label'       => esc_html__( 'Sidebar Position', 'industing' ),
	'section'     => 'service_settings',
	'default'     => '3',
	'choices'     => [
		'1' => esc_html__( 'Left Sidebar', 'industing' ),
		'2' => esc_html__( 'Full Width', 'industing' ),
		'3' => esc_html__( 'Right Sidebar', 'industing' ),
	],
);

$fields[] = array(
        'type'        => 'select',
        'settings'    => 'ser_single_style',
        'label'       => esc_html__( 'Service Style', 'industing' ),
        'section'     => 'service_settings',
        'default'     => '2',
        'choices'     => array(
                '1'      => esc_html__('Slider View','industing'),
                '2'      => esc_html__('Static View','industing'),
        ),
);
$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'sing_serv_custom',
	'label'       => FALSE,
	'section'     => 'service_settings',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);
$fields[] = array(
    'type'          => 'repeater',
	'label'       => esc_html__( 'Add Blocks', 'industing' ),
	'section'     => 'service_settings',
	'settings'     => 'service_bloks',
	'row_label' => [
		'type'  => 'text',
		'value' => esc_html__('Block', 'industing' ),
	],
	'button_label' => esc_html__('Add New Block', 'industing' ),
	'default'      => [],
	'fields' => [
		'block_ids' => [
			'type'        => 'select',
                        'label'       => esc_html__( 'Block', 'industing' ),
                        'default'     => 'none',
                        'choices'     => $all_bloks
		]
	]
);