<?php
$bloks = array(
        'post_type'       => 'blocks',
        'post_status'     => 'publish',
        'posts_per_page'  => -1,
        'orderby'         => 'title',
        'order'           => 'ASC'
);
$all_bloks = array(
    'none' => esc_html__('None', 'industing')
);
$blok = new WP_Query($bloks);
if($blok->have_posts()):
    while($blok->have_posts()):
        $blok->the_post();
        $all_bloks[get_the_ID()] = get_the_title();
    endwhile;
endif;
wp_reset_postdata();

$fields[] = array(
        'type'        => 'image',
	'settings'    => 'shop_banner_bg',
	'label'       => esc_html__( 'Upload Banner BG', 'industing' ),
	'section'     => 'shop_settings',
	'default'     => '',
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'shop_overlay',
	'label'       => esc_html__( 'Banner Overlay Color', 'industing' ),
	'section'     => 'shop_settings',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.page_banner:after',
                        'property' => 'background'
		],
	],
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'shop_is_breadcrumb',
	'label'       => esc_html__( 'Is Breadcrumb', 'industing' ),
	'section'     => 'shop_settings',
	'default'     => '1',
	'choices'     => [
		'on'  => esc_html__( 'Show', 'industing' ),
		'off' => esc_html__( 'Hide', 'industing' ),
	],
);
$fields[]= array(
        'type'        => 'text',
        'settings'    => 'shop_banner_title',
        'label'       => esc_html__( 'Banner Title', 'industing' ),
        'section'     => 'shop_settings',
        'transport'   => 'postMessage',
        'js_vars'     => array(
            array(
                'element'  => '.page_banner h2',
                'function' => 'html'
            ),
        ),
        'default'     => esc_html__( 'Our Store', 'industing' ),
);
$fields[] = array(
        'type'          => 'text',
	'settings'      => 'shop_bread_title',
	'label'         => esc_html__( 'Breadcrumb Title', 'industing' ),
	'section'       => 'shop_settings',
	'default'       => esc_html__('Shop', 'industing'),
        'transport'     => 'postMessage',
        'js_vars'       => array(
            array(
                'element'  => '.breadcrumbs span',
                'function' => 'html'
            ),
        ),
);
$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'shop_custom',
	'label'       => FALSE,
	'section'     => 'shop_settings',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);

$fields[] = array(
    'type'        => 'select',
    'settings'    => 'shop_view',
    'label'       => esc_html__( 'Shop View', 'industing' ),
    'section'     => 'shop_settings',
    'default'     => '1',
    'choices'     => array(
        '1'      => esc_html__('Grid View','industing'),
        '2'      => esc_html__('List View','industing')
    ),
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'shop_is_view_switch',
	'label'       => esc_html__( 'Is View Switcher', 'industing' ),
	'section'     => 'shop_settings',
	'default'     => '1',
	'choices'     => [
		'on'  => esc_html__( 'Show', 'industing' ),
		'off' => esc_html__( 'Hide', 'industing' ),
	],
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'shop_is_count',
	'label'       => esc_html__( 'Is Count', 'industing' ),
	'section'     => 'shop_settings',
	'default'     => '1',
	'choices'     => [
		'on'  => esc_html__( 'Show', 'industing' ),
		'off' => esc_html__( 'Hide', 'industing' ),
	],
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'shop_is_order',
	'label'       => esc_html__( 'Is Sort', 'industing' ),
	'section'     => 'shop_settings',
	'default'     => '1',
	'choices'     => [
		'on'  => esc_html__( 'Show', 'industing' ),
		'off' => esc_html__( 'Hide', 'industing' ),
	],
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'shop_is_search',
	'label'       => esc_html__( 'Is Search Bar', 'industing' ),
	'section'     => 'shop_settings',
	'default'     => '1',
	'choices'     => [
		'on'  => esc_html__( 'Show', 'industing' ),
		'off' => esc_html__( 'Hide', 'industing' ),
	],
);
$fields[] = array(
    'type'        => 'select',
    'settings'    => 'shop_sidebar',
    'label'       => esc_html__( 'Shop Sidebar Position', 'industing' ),
    'section'     => 'shop_settings',
    'default'     => '1',
    'choices'     => array(
        '1'      => esc_html__('Full Width','industing'),
        '2'      => esc_html__('Left Sidebar','industing'),
        '3'      => esc_html__('Right Sidebar','industing'),
    ),
);
$fields[] = array(
        'type'        => 'slider',
	'settings'    => 'shop_pro_per_page',
	'label'       => esc_html__( 'Product Per Page', 'industing' ),
	'section'     => 'shop_settings',
	'default'     => 8,
	'choices'     => [
		'min'  => 0,
		'max'  => 100,
		'step' => 1,
	]
);
$fields[] = array(
        'type'        => 'select',
        'settings'    => 'shop_pagi_align',
        'label'       => esc_html__( 'Pagination Alignment', 'industing' ),
        'section'     => 'shop_settings',
        'default'     => 'center',
        'choices'     => array(
                'left'      => esc_html__('Left','industing'),
                'center'      => esc_html__('Center','industing'),
                'right'      => esc_html__('Right','industing'),
        ),
);
$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'shop_custom2',
	'label'       => FALSE,
	'section'     => 'shop_settings',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'shop_is_sale_flash',
	'label'       => esc_html__( 'Is Sale Flash', 'industing' ),
	'section'     => 'shop_settings',
	'default'     => '1',
	'choices'     => [
		'on'  => esc_html__( 'Show', 'industing' ),
		'off' => esc_html__( 'Hide', 'industing' ),
	],
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'shop_is_bs_flash',
	'label'       => esc_html__( 'Is Best Seller Flash', 'industing' ),
	'section'     => 'shop_settings',
	'default'     => '1',
	'choices'     => [
		'on'  => esc_html__( 'Show', 'industing' ),
		'off' => esc_html__( 'Hide', 'industing' ),
	],
);
$fields[] = array(
        'type'        => 'slider',
	'settings'    => 'shop_bs_limit',
	'label'       => esc_html__( 'Best Seller Limit', 'industing' ),
	'section'     => 'shop_settings',
	'default'     => 50,
	'choices'     => [
		'min'  => 0,
		'max'  => 500,
		'step' => 5,
	]
);
$fields[]= array(
        'type'        => 'text',
        'settings'    => 'shop_bs_label',
        'label'       => esc_html__( 'Best Seller Label', 'industing' ),
        'section'     => 'shop_settings',
        'default'     => esc_html__( 'Best Seller', 'industing' ),
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'shop_is_ls_flash',
	'label'       => esc_html__( 'Is Limited Stoke Flash', 'industing' ),
	'section'     => 'shop_settings',
	'default'     => '1',
	'choices'     => [
		'on'  => esc_html__( 'Show', 'industing' ),
		'off' => esc_html__( 'Hide', 'industing' ),
	],
);
$fields[]= array(
        'type'        => 'text',
        'settings'    => 'shop_ls_flash_label',
        'label'       => esc_html__( 'Limited Stoke Flash Label', 'industing' ),
        'section'     => 'shop_settings',
        'default'     => esc_html__( 'Limited Stock', 'industing' ),
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'shop_is_ji_flash',
	'label'       => esc_html__( 'Is Just In Flash', 'industing' ),
	'section'     => 'shop_settings',
	'default'     => '1',
	'choices'     => [
		'on'  => esc_html__( 'Show', 'industing' ),
		'off' => esc_html__( 'Hide', 'industing' ),
	],
);
$fields[] = array(
        'type'        => 'slider',
	'settings'    => 'shop_ji_limit',
	'label'       => esc_html__( 'Just In Day Limit', 'industing' ),
	'section'     => 'shop_settings',
	'default'     => 7,
	'choices'     => [
		'min'  => 0,
		'max'  => 100,
		'step' => 1,
	]
);
$fields[]= array(
        'type'        => 'text',
        'settings'    => 'shop_ji_flash_label',
        'label'       => esc_html__( 'Just In Flash Label', 'industing' ),
        'section'     => 'shop_settings',
        'default'     => esc_html__( 'Just In', 'industing' ),
);


$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'shop_custom3',
	'label'       => FALSE,
	'section'     => 'shop_settings',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);
$fields[] = array(
    'type'              => 'repeater',
	'label'         => esc_html__( 'Add Blocks', 'industing' ),
	'section'       => 'shop_settings',
	'settings'      => 'shop_bloks',
	'row_label' => [
		'type'  => 'text',
		'value' => esc_html__('Block', 'industing' ),
	],
	'button_label' => esc_html__('Add New Block', 'industing' ),
	'default'      => [],
	'fields' => [
		'block_ids' => [
			'type'        => 'select',
                        'label'       => esc_html__( 'Block', 'industing' ),
                        'default'     => 'none',
                        'choices'     => $all_bloks
		]
	]
);
