<?php
$bloks = array(
        'post_type'       => 'blocks',
        'post_status'     => 'publish',
        'posts_per_page'  => -1,
        'orderby'         => 'title',
        'order'           => 'ASC'
);
$all_bloks = array(
    'none' => esc_html__('None', 'industing')
);
$blok = new WP_Query($bloks);
if($blok->have_posts()):
    while($blok->have_posts()):
        $blok->the_post();
        $all_bloks[get_the_ID()] = get_the_title();
    endwhile;
endif;
wp_reset_postdata();

$fields[] = array(
        'type'        => 'image',
	'settings'    => 'pro_banner_bg',
	'label'       => esc_html__( 'Upload Banner BG', 'industing' ),
	'section'     => 'shop_single_settings',
	'default'     => '',
);
$fields[]= array(
        'type'        => 'color',
	'settings'    => 'pro_overlay',
	'label'       => esc_html__( 'Banner Overlay Color', 'industing' ),
	'section'     => 'shop_single_settings',
	'default'     => '',
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '.page_banner:after',
                        'property' => 'background'
		],
	],
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'pro_is_breadcrumb',
	'label'       => esc_html__( 'Is Breadcrumb', 'industing' ),
	'section'     => 'shop_single_settings',
	'default'     => '1',
	'choices'     => [
		'on'  => esc_html__( 'Show', 'industing' ),
		'off' => esc_html__( 'Hide', 'industing' ),
	],
);
$fields[]= array(
        'type'        => 'text',
        'settings'    => 'pro_banner_title',
        'label'       => esc_html__( 'Banner Title', 'industing' ),
        'section'     => 'shop_single_settings',
        'transport'   => 'postMessage',
        'js_vars'     => array(
            array(
                'element'  => '.page_banner h2',
                'function' => 'html'
            ),
        ),
        'default'     => esc_html__( 'Product Details', 'industing' ),
);
$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'pro_custom',
	'label'       => FALSE,
	'section'     => 'shop_single_settings',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);
$fields[]= array(
        'type'        => 'text',
        'settings'    => 'pro_rating_label',
        'label'       => esc_html__( 'Rating Area Title', 'industing' ),
        'section'     => 'shop_single_settings',
        'default'     => esc_html__( 'Rating', 'industing' ),
);
$fields[]= array(
        'type'        => 'text',
        'settings'    => 'pro_stock_label',
        'label'       => esc_html__( 'Stock Area Title', 'industing' ),
        'section'     => 'shop_single_settings',
        'default'     => esc_html__( 'Availability', 'industing' ),
);
$fields[]= array(
        'type'        => 'text',
        'settings'    => 'pro_sku_label',
        'label'       => esc_html__( 'SKU Area Title', 'industing' ),
        'section'     => 'shop_single_settings',
        'default'     => esc_html__( 'SKU', 'industing' ),
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'pro_is_category',
	'label'       => esc_html__( 'Is Category', 'industing' ),
	'section'     => 'shop_single_settings',
	'default'     => '1',
	'choices'     => [
		'on'  => esc_html__( 'Show', 'industing' ),
		'off' => esc_html__( 'Hide', 'industing' ),
	],
);
$fields[]= array(
        'type'        => 'text',
        'settings'    => 'pro_cat_label',
        'label'       => esc_html__( 'Category Area Title', 'industing' ),
        'section'     => 'shop_single_settings',
        'default'     => esc_html__( 'Category', 'industing' ),
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'pro_is_tag',
	'label'       => esc_html__( 'Is Tags', 'industing' ),
	'section'     => 'shop_single_settings',
	'default'     => '1',
	'choices'     => [
		'on'  => esc_html__( 'Show', 'industing' ),
		'off' => esc_html__( 'Hide', 'industing' ),
	],
);
$fields[]= array(
        'type'        => 'text',
        'settings'    => 'pro_tag_label',
        'label'       => esc_html__( 'Tag Area Title', 'industing' ),
        'section'     => 'shop_single_settings',
        'default'     => esc_html__( 'Tag', 'industing' ),
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'pro_is_sharing',
	'label'       => esc_html__( 'Is Sharing', 'industing' ),
	'section'     => 'shop_single_settings',
	'default'     => '1',
	'choices'     => [
		'on'  => esc_html__( 'Show', 'industing' ),
		'off' => esc_html__( 'Hide', 'industing' ),
	],
);
$fields[]= array(
        'type'        => 'text',
        'settings'    => 'pro_share_label',
        'label'       => esc_html__( 'Share Area Title', 'industing' ),
        'section'     => 'shop_single_settings',
        'default'     => esc_html__( 'Social Share', 'industing' ),
);
$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'pro_custom2',
	'label'       => FALSE,
	'section'     => 'shop_single_settings',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);
$fields[]= array(
        'type'        => 'switch',
	'settings'    => 'pro_is_related',
	'label'       => esc_html__( 'Is Related Product', 'industing' ),
	'section'     => 'shop_single_settings',
	'default'     => '1',
	'choices'     => [
		'on'  => esc_html__( 'Show', 'industing' ),
		'off' => esc_html__( 'Hide', 'industing' ),
	],
);
$fields[]= array(
        'type'        => 'text',
        'settings'    => 'pro_rel_label',
        'label'       => esc_html__( 'Related Area Title', 'industing' ),
        'section'     => 'shop_single_settings',
        'default'     => esc_html__( 'Related Products', 'industing' ),
);
$fields[] = array(
        'type'        => 'custom',
	'settings'    => 'pro_custom3',
	'label'       => FALSE,
	'section'     => 'shop_single_settings',
	'default'     => '<div style="height: 2px; margin: 20px 0 15px; border-top: 2px dashed #333; border-radius: 0px;"></div>',
);
$fields[] = array(
    'type'              => 'repeater',
	'label'         => esc_html__( 'Add Blocks', 'industing' ),
	'section'       => 'shop_single_settings',
	'settings'      => 'product_bloks',
	'row_label' => [
		'type'  => 'text',
		'value' => esc_html__('Block', 'industing' ),
	],
	'button_label' => esc_html__('Add New Block', 'industing' ),
	'default'      => [],
	'fields' => [
		'block_ids' => [
			'type'        => 'select',
                        'label'       => esc_html__( 'Block', 'industing' ),
                        'default'     => 'none',
                        'choices'     => $all_bloks
		]
	]
);