<?php
/**
 * Template Name: Service Page
 */
get_header();
get_template_part('template-parts/header/service', 'header');

$service_style = get_theme_mod('service_style', 1);
$service_sedebar = get_theme_mod('service_sedebar', 1);
$serv_order_by = get_theme_mod('serv_order_by', 'date');
$serv_order = get_theme_mod('serv_order', 'DESC');
$serv_num_of_item = get_theme_mod('serv_num_of_item', 6);
$service_pagi_align = get_theme_mod('service_pagi_align', 'left');
$service_is_masonry = get_theme_mod('service_is_masonry', 2);

$col = '';
$inner_col = '';
if($service_sedebar == 1):
    $col = 'col-lg-12 col-md-12 col-sm-12';
    $inner_col = 'col-xl-4 col-md-6 col-lg-4';
else:
    $col = 'col-lg-8 col-md-6 col-sm-12';
    $inner_col = 'col-xl-6 col-md-6 col-lg-6';
endif;
if($service_is_masonry == 1){
    $inner_col .= ' serv-mash-item';
}
?>
<section class="commonSection serviceListingPage">
    <div class="container">
        <div class="row">
            <?php if($service_sedebar == 2 && is_active_sidebar('sidebar-3')): ?>
            <div class="col-lg-4 col-md-6 sidebar_1">
                <?php dynamic_sidebar('sidebar-3'); ?>
            </div>
            <?php endif; ?>
            <div class="<?php echo esc_attr($col); ?>">
                <div class="row <?php if($service_is_masonry == 1){ echo 'serviceListingMas'; } ?>">
                    <?php
                        global $wp_query;
                        $page = (get_query_var('paged') != '') ? get_query_var('paged') : 1;
                        $servs = array(
                            'post_type'             => array('tw-service'),
                            'post_status'           => 'publish',
                            'posts_per_page'        => $serv_num_of_item,
                            'orderby'               => $serv_order_by,
                            'order'                 => $serv_order,
                            'paged'                 => $page
                        );

                        $wp_query = new WP_Query($servs);
                        if($wp_query->have_posts()):
                            while($wp_query->have_posts()):
                                $wp_query->the_post();
                                if($service_style == 2):
                                ?>
                                    <div class="<?php echo esc_attr($inner_col); ?>">
                                        <div class="singleService style2">
                                            <div class="serviceThumb">
                                                <?php if(has_post_thumbnail()): ?>
                                                    <?php echo get_the_post_thumbnail(get_the_ID(), 'industing-service-2'); ?>
                                                <?php else: ?>
                                                    <img src="http://via.placeholder.com/333x220" alt="<?php echo get_the_title(); ?>">
                                                <?php endif; ?>
                                            </div>
                                            <div class="serviceDetails">
                                                <h2><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h2>
                                                <p>
                                                    <?php echo substr(wp_strip_all_tags(get_the_content()), 0, 101); ?>
                                                </p>
                                                <a href="<?php echo get_the_permalink(); ?>"><?php echo esc_html__('Read More', 'industing') ?><i class="twi-long-arrow-right2"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <?php
                                        $demo_icon_v2 = array();
                                        $key_service = array();
                                        if(defined('FW')){
                                            $demo_icon_v2 = fw_get_db_post_option(get_the_ID(), 'demo_icon_v2', array());
                                            $key_service = fw_get_db_post_option(get_the_ID(), 'key_service', array());
                                        }
                                        $icon_or_img = '';
                                        if(isset($demo_icon_v2['type']) && $demo_icon_v2['type'] == 'icon-font'){
                                            $icon_or_img = (isset($demo_icon_v2['icon-class']) && $demo_icon_v2['icon-class'] != '' ? '<i class="'.$demo_icon_v2['icon-class'].'"></i>' : '');
                                        }elseif(isset($demo_icon_v2['type']) && $demo_icon_v2['type'] == 'custom-upload'){
                                            $icon_or_img = (isset($demo_icon_v2['url']) && $demo_icon_v2['url'] != '' ? '<img src="'.$demo_icon_v2['url'].'" alt="'.get_the_title().'"/>' : '');
                                        }
                                    ?>
                                    <div class="<?php echo esc_attr($inner_col); ?>">
                                        <div class="icon_box_03">
                                            <?php echo wp_kses($icon_or_img, industing_allowed_html()); ?>
                                            <h3><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h3>
                                            <p>
                                                <?php 
                                                    echo substr(wp_strip_all_tags(get_the_content()), 0, 66);
                                                ?>
                                            </p>
                                            <?php if(!empty($key_service)): ?>
                                            <ul>
                                                <?php foreach($key_service as $fea): ?>
                                                    <?php if($fea['ser_key_name'] && $fea['ser_key_name'] != ''):?>
                                                        <li><?php echo wp_kses($fea['ser_key_name'], industing_allowed_html()); ?></li>
                                                    <?php endif; ?>
                                                <?php endforeach; ?>
                                            </ul>
                                            <?php endif; ?>
                                        </div>
                                    </div>  
                                <?php endif;
                            endwhile;
                            ?>
                            <div class="clearfix"></div>
                            <div class="col-lg-12 col-sm-12">
                                <div class="ind_pagination service_patinations text-<?php echo esc_attr($service_pagi_align); ?>">
                                    <?php 
                                        the_posts_pagination( array(
                                            'prev_text' => '<i class="twi-arrow-left2"></i>',
                                            'next_text' =>  '<i class="twi-arrow-right2"></i>',
                                            'before_page_number' => '0'
                                        ));
                                    ?>
                                </div>
                            </div>
                            <?php
                        endif;
                        wp_reset_postdata();
                    ?>
                </div>
            </div>
            <?php if($service_sedebar == 3 && is_active_sidebar('sidebar-3')): ?>
            <div class="col-lg-4 col-md-6 sidebar_1">
                <?php dynamic_sidebar('sidebar-3'); ?>
            </div>
            <?php endif; ?>
        </div>
    </div>
</section>
<?php
    $services_bloks = get_theme_mod('services_bloks', '');
    $blocks_id = array();
    if(!empty($services_bloks)){
        foreach($services_bloks as $sb):
            if($sb['block_ids'] != '' && $sb['block_ids'] != 'none'):
                $blocks_id[] = $sb['block_ids'];
            endif;
        endforeach;
        $bloks = array(
            'post_type'     => 'blocks',
            'post_status'   => 'publish',
            'post__in'      => $blocks_id
        );
        $blok = new WP_Query($bloks);
        if($blok->have_posts()):
            while($blok->have_posts()):
            $blok->the_post();
            the_content();
            endwhile;
        endif;
    }
get_footer();